/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.token;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.DefaultProtocolVersion;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.api.core.metadata.token.TokenRange;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.DefaultTokenMap;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3Token;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenFactory;
import com.datastax.oss.driver.internal.core.metadata.token.Murmur3TokenRange;
import com.datastax.oss.driver.internal.core.metadata.token.ReplicationStrategyFactory;
import com.datastax.oss.driver.internal.core.metadata.token.TokenFactory;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class DefaultTokenMapTest {
    private static final String DC1 = "DC1";
    private static final String DC2 = "DC2";
    private static final String RACK1 = "RACK1";
    private static final String RACK2 = "RACK2";
    private static final CqlIdentifier KS1 = CqlIdentifier.fromInternal((String)"ks1");
    private static final CqlIdentifier KS2 = CqlIdentifier.fromInternal((String)"ks2");
    private static final TokenFactory TOKEN_FACTORY = new Murmur3TokenFactory();
    private static final String TOKEN1 = "-9000000000000000000";
    private static final String TOKEN2 = "-6000000000000000000";
    private static final String TOKEN3 = "4000000000000000000";
    private static final String TOKEN4 = "9000000000000000000";
    private static final TokenRange RANGE12 = DefaultTokenMapTest.range("-9000000000000000000", "-6000000000000000000");
    private static final TokenRange RANGE23 = DefaultTokenMapTest.range("-6000000000000000000", "4000000000000000000");
    private static final TokenRange RANGE34 = DefaultTokenMapTest.range("4000000000000000000", "9000000000000000000");
    private static final TokenRange RANGE41 = DefaultTokenMapTest.range("9000000000000000000", "-9000000000000000000");
    private static final TokenRange FULL_RING = DefaultTokenMapTest.range(TOKEN_FACTORY.minToken(), TOKEN_FACTORY.minToken());
    private static ByteBuffer ROUTING_KEY12 = TypeCodecs.BIGINT.encode(Long.valueOf(2L), (ProtocolVersion)DefaultProtocolVersion.V3);
    private static ByteBuffer ROUTING_KEY23 = TypeCodecs.BIGINT.encode(Long.valueOf(0L), (ProtocolVersion)DefaultProtocolVersion.V3);
    private static ByteBuffer ROUTING_KEY34 = TypeCodecs.BIGINT.encode(Long.valueOf(1L), (ProtocolVersion)DefaultProtocolVersion.V3);
    private static ByteBuffer ROUTING_KEY41 = TypeCodecs.BIGINT.encode(Long.valueOf(99L), (ProtocolVersion)DefaultProtocolVersion.V3);
    private static final ImmutableMap<String, String> REPLICATE_ON_BOTH_DCS = ImmutableMap.of((Object)"class", (Object)"org.apache.cassandra.locator.NetworkTopologyStrategy", (Object)"DC1", (Object)"1", (Object)"DC2", (Object)"1");
    private static final ImmutableMap<String, String> REPLICATE_ON_DC1 = ImmutableMap.of((Object)"class", (Object)"org.apache.cassandra.locator.NetworkTopologyStrategy", (Object)"DC1", (Object)"1");
    @Mock
    private InternalDriverContext context;
    private ReplicationStrategyFactory replicationStrategyFactory;

    @Before
    public void setup() {
        this.replicationStrategyFactory = new DefaultReplicationStrategyFactory(this.context);
    }

    @Test
    public void should_build_token_map() {
        DefaultNode node1 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN1));
        DefaultNode node2 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN2));
        DefaultNode node3 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN3));
        DefaultNode node4 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN4));
        ImmutableList nodes = ImmutableList.of((Object)node1, (Object)node2, (Object)node3, (Object)node4);
        ImmutableList keyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_DC1));
        DefaultTokenMap tokenMap = DefaultTokenMap.build((Collection)nodes, (Collection)keyspaces, (TokenFactory)TOKEN_FACTORY, (ReplicationStrategyFactory)this.replicationStrategyFactory, (String)"test");
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges()).containsExactly((Object[])new TokenRange[]{RANGE12, RANGE23, RANGE34, RANGE41});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS1, (Node)node1)).containsOnly((Object[])new TokenRange[]{RANGE41, RANGE34});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS1, (Node)node2)).containsOnly((Object[])new TokenRange[]{RANGE12, RANGE41});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS1, (Node)node3)).containsOnly((Object[])new TokenRange[]{RANGE23, RANGE12});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS1, (Node)node4)).containsOnly((Object[])new TokenRange[]{RANGE34, RANGE23});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, RANGE12)).containsOnly((Object[])new Node[]{node2, node3});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, RANGE23)).containsOnly((Object[])new Node[]{node3, node4});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, RANGE34)).containsOnly((Object[])new Node[]{node1, node4});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, RANGE41)).containsOnly((Object[])new Node[]{node1, node2});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, ROUTING_KEY12)).containsOnly((Object[])new Node[]{node2, node3});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, ROUTING_KEY23)).containsOnly((Object[])new Node[]{node3, node4});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, ROUTING_KEY34)).containsOnly((Object[])new Node[]{node1, node4});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, ROUTING_KEY41)).containsOnly((Object[])new Node[]{node1, node2});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS2, (Node)node1)).containsOnly((Object[])new TokenRange[]{RANGE41, RANGE34});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS2, (Node)node3)).containsOnly((Object[])new TokenRange[]{RANGE23, RANGE12});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS2, (Node)node2)).isEmpty();
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS2, (Node)node4)).isEmpty();
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, RANGE12)).containsOnly((Object[])new Node[]{node3});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, RANGE23)).containsOnly((Object[])new Node[]{node3});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, RANGE34)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, RANGE41)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, ROUTING_KEY12)).containsOnly((Object[])new Node[]{node3});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, ROUTING_KEY23)).containsOnly((Object[])new Node[]{node3});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, ROUTING_KEY34)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, ROUTING_KEY41)).containsOnly((Object[])new Node[]{node1});
    }

    @Test
    public void should_build_token_map_with_single_node() {
        DefaultNode node1 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN1));
        ImmutableList nodes = ImmutableList.of((Object)node1);
        ImmutableList keyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_DC1));
        DefaultTokenMap tokenMap = DefaultTokenMap.build((Collection)nodes, (Collection)keyspaces, (TokenFactory)TOKEN_FACTORY, (ReplicationStrategyFactory)this.replicationStrategyFactory, (String)"test");
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges()).containsExactly((Object[])new TokenRange[]{FULL_RING});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS1, (Node)node1)).containsOnly((Object[])new TokenRange[]{FULL_RING});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, FULL_RING)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, ROUTING_KEY12)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, ROUTING_KEY23)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, ROUTING_KEY34)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS1, ROUTING_KEY41)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getTokenRanges(KS2, (Node)node1)).containsOnly((Object[])new TokenRange[]{FULL_RING});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, FULL_RING)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, ROUTING_KEY12)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, ROUTING_KEY23)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, ROUTING_KEY34)).containsOnly((Object[])new Node[]{node1});
        Assertions.assertThat((Iterable)tokenMap.getReplicas(KS2, ROUTING_KEY41)).containsOnly((Object[])new Node[]{node1});
    }

    @Test
    public void should_refresh_when_keyspace_replication_has_not_changed() {
        DefaultNode node1 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN1));
        DefaultNode node2 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN2));
        DefaultNode node3 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN3));
        DefaultNode node4 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN4));
        ImmutableList nodes = ImmutableList.of((Object)node1, (Object)node2, (Object)node3, (Object)node4);
        ImmutableList oldKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_DC1));
        DefaultTokenMap oldTokenMap = DefaultTokenMap.build((Collection)nodes, (Collection)oldKeyspaces, (TokenFactory)TOKEN_FACTORY, (ReplicationStrategyFactory)this.replicationStrategyFactory, (String)"test");
        ImmutableList newKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_DC1));
        DefaultTokenMap newTokenMap = oldTokenMap.refresh((Collection)nodes, (Collection)newKeyspaces, this.replicationStrategyFactory);
        Assertions.assertThat((Iterable)newTokenMap.tokenRanges).isSameAs((Object)oldTokenMap.tokenRanges);
        Assertions.assertThat((Object)newTokenMap.tokenRangesByPrimary).isSameAs((Object)oldTokenMap.tokenRangesByPrimary);
        Assertions.assertThat((Map)newTokenMap.replicationConfigs).isSameAs((Object)oldTokenMap.replicationConfigs);
        Assertions.assertThat((Map)newTokenMap.keyspaceMaps).isSameAs((Object)oldTokenMap.keyspaceMaps);
    }

    @Test
    public void should_refresh_when_new_keyspace_with_existing_replication() {
        DefaultNode node1 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN1));
        DefaultNode node2 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN2));
        DefaultNode node3 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN3));
        DefaultNode node4 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN4));
        ImmutableList nodes = ImmutableList.of((Object)node1, (Object)node2, (Object)node3, (Object)node4);
        ImmutableList oldKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS));
        DefaultTokenMap oldTokenMap = DefaultTokenMap.build((Collection)nodes, (Collection)oldKeyspaces, (TokenFactory)TOKEN_FACTORY, (ReplicationStrategyFactory)this.replicationStrategyFactory, (String)"test");
        Assertions.assertThat((Map)oldTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS});
        ImmutableList newKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_BOTH_DCS));
        DefaultTokenMap newTokenMap = oldTokenMap.refresh((Collection)nodes, (Collection)newKeyspaces, this.replicationStrategyFactory);
        Assertions.assertThat((Iterable)newTokenMap.tokenRanges).isSameAs((Object)oldTokenMap.tokenRanges);
        Assertions.assertThat((Object)newTokenMap.tokenRangesByPrimary).isSameAs((Object)oldTokenMap.tokenRangesByPrimary);
        Assertions.assertThat((Map)newTokenMap.keyspaceMaps).isEqualTo((Object)oldTokenMap.keyspaceMaps);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)newTokenMap.replicationConfigs).hasSize(2)).containsEntry((Object)KS1, REPLICATE_ON_BOTH_DCS)).containsEntry((Object)KS2, REPLICATE_ON_BOTH_DCS);
    }

    @Test
    public void should_refresh_when_new_keyspace_with_new_replication() {
        DefaultNode node1 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN1));
        DefaultNode node2 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN2));
        DefaultNode node3 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN3));
        DefaultNode node4 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN4));
        ImmutableList nodes = ImmutableList.of((Object)node1, (Object)node2, (Object)node3, (Object)node4);
        ImmutableList oldKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS));
        DefaultTokenMap oldTokenMap = DefaultTokenMap.build((Collection)nodes, (Collection)oldKeyspaces, (TokenFactory)TOKEN_FACTORY, (ReplicationStrategyFactory)this.replicationStrategyFactory, (String)"test");
        Assertions.assertThat((Map)oldTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS});
        ImmutableList newKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_DC1));
        DefaultTokenMap newTokenMap = oldTokenMap.refresh((Collection)nodes, (Collection)newKeyspaces, this.replicationStrategyFactory);
        Assertions.assertThat((Iterable)newTokenMap.tokenRanges).isSameAs((Object)oldTokenMap.tokenRanges);
        Assertions.assertThat((Object)newTokenMap.tokenRangesByPrimary).isSameAs((Object)oldTokenMap.tokenRangesByPrimary);
        Assertions.assertThat((Map)newTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS, REPLICATE_ON_DC1});
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)newTokenMap.replicationConfigs).hasSize(2)).containsEntry((Object)KS1, REPLICATE_ON_BOTH_DCS)).containsEntry((Object)KS2, REPLICATE_ON_DC1);
    }

    @Test
    public void should_refresh_when_dropped_keyspace_with_replication_still_used() {
        DefaultNode node1 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN1));
        DefaultNode node2 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN2));
        DefaultNode node3 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN3));
        DefaultNode node4 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN4));
        ImmutableList nodes = ImmutableList.of((Object)node1, (Object)node2, (Object)node3, (Object)node4);
        ImmutableList oldKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_BOTH_DCS));
        DefaultTokenMap oldTokenMap = DefaultTokenMap.build((Collection)nodes, (Collection)oldKeyspaces, (TokenFactory)TOKEN_FACTORY, (ReplicationStrategyFactory)this.replicationStrategyFactory, (String)"test");
        Assertions.assertThat((Map)oldTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS});
        ImmutableList newKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS));
        DefaultTokenMap newTokenMap = oldTokenMap.refresh((Collection)nodes, (Collection)newKeyspaces, this.replicationStrategyFactory);
        Assertions.assertThat((Iterable)newTokenMap.tokenRanges).isSameAs((Object)oldTokenMap.tokenRanges);
        Assertions.assertThat((Object)newTokenMap.tokenRangesByPrimary).isSameAs((Object)oldTokenMap.tokenRangesByPrimary);
        Assertions.assertThat((Map)newTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS});
        ((MapAssert)Assertions.assertThat((Map)newTokenMap.replicationConfigs).hasSize(1)).containsEntry((Object)KS1, REPLICATE_ON_BOTH_DCS);
    }

    @Test
    public void should_refresh_when_dropped_keyspace_with_replication_not_used_anymore() {
        DefaultNode node1 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN1));
        DefaultNode node2 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN2));
        DefaultNode node3 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN3));
        DefaultNode node4 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN4));
        ImmutableList nodes = ImmutableList.of((Object)node1, (Object)node2, (Object)node3, (Object)node4);
        ImmutableList oldKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_DC1));
        DefaultTokenMap oldTokenMap = DefaultTokenMap.build((Collection)nodes, (Collection)oldKeyspaces, (TokenFactory)TOKEN_FACTORY, (ReplicationStrategyFactory)this.replicationStrategyFactory, (String)"test");
        Assertions.assertThat((Map)oldTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS, REPLICATE_ON_DC1});
        ImmutableList newKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS));
        DefaultTokenMap newTokenMap = oldTokenMap.refresh((Collection)nodes, (Collection)newKeyspaces, this.replicationStrategyFactory);
        Assertions.assertThat((Iterable)newTokenMap.tokenRanges).isSameAs((Object)oldTokenMap.tokenRanges);
        Assertions.assertThat((Object)newTokenMap.tokenRangesByPrimary).isSameAs((Object)oldTokenMap.tokenRangesByPrimary);
        Assertions.assertThat((Map)newTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS});
        ((MapAssert)Assertions.assertThat((Map)newTokenMap.replicationConfigs).hasSize(1)).containsEntry((Object)KS1, REPLICATE_ON_BOTH_DCS);
    }

    @Test
    public void should_refresh_when_updated_keyspace_with_different_replication() {
        DefaultNode node1 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN1));
        DefaultNode node2 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN2));
        DefaultNode node3 = this.mockNode(DC1, RACK1, (Set<String>)ImmutableSet.of((Object)TOKEN3));
        DefaultNode node4 = this.mockNode(DC2, RACK2, (Set<String>)ImmutableSet.of((Object)TOKEN4));
        ImmutableList nodes = ImmutableList.of((Object)node1, (Object)node2, (Object)node3, (Object)node4);
        ImmutableList oldKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_DC1));
        DefaultTokenMap oldTokenMap = DefaultTokenMap.build((Collection)nodes, (Collection)oldKeyspaces, (TokenFactory)TOKEN_FACTORY, (ReplicationStrategyFactory)this.replicationStrategyFactory, (String)"test");
        Assertions.assertThat((Map)oldTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS, REPLICATE_ON_DC1});
        ImmutableList newKeyspaces = ImmutableList.of((Object)this.mockKeyspace(KS1, (Map<String, String>)REPLICATE_ON_BOTH_DCS), (Object)this.mockKeyspace(KS2, (Map<String, String>)REPLICATE_ON_BOTH_DCS));
        DefaultTokenMap newTokenMap = oldTokenMap.refresh((Collection)nodes, (Collection)newKeyspaces, this.replicationStrategyFactory);
        Assertions.assertThat((Iterable)newTokenMap.tokenRanges).isSameAs((Object)oldTokenMap.tokenRanges);
        Assertions.assertThat((Object)newTokenMap.tokenRangesByPrimary).isSameAs((Object)oldTokenMap.tokenRangesByPrimary);
        Assertions.assertThat((Map)newTokenMap.keyspaceMaps).containsOnlyKeys((Object[])new Map[]{REPLICATE_ON_BOTH_DCS});
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)newTokenMap.replicationConfigs).hasSize(2)).containsEntry((Object)KS1, REPLICATE_ON_BOTH_DCS)).containsEntry((Object)KS2, REPLICATE_ON_BOTH_DCS);
    }

    private DefaultNode mockNode(String dc, String rack, Set<String> tokens) {
        DefaultNode node = (DefaultNode)Mockito.mock(DefaultNode.class);
        Mockito.when((Object)node.getDatacenter()).thenReturn((Object)dc);
        Mockito.when((Object)node.getRack()).thenReturn((Object)rack);
        Mockito.when((Object)node.getRawTokens()).thenReturn(tokens);
        return node;
    }

    private KeyspaceMetadata mockKeyspace(CqlIdentifier name, Map<String, String> replicationConfig) {
        KeyspaceMetadata keyspace = (KeyspaceMetadata)Mockito.mock(KeyspaceMetadata.class);
        Mockito.when((Object)keyspace.getName()).thenReturn((Object)name);
        Mockito.when((Object)keyspace.getReplication()).thenReturn(replicationConfig);
        return keyspace;
    }

    private static TokenRange range(String start, String end) {
        return DefaultTokenMapTest.range(TOKEN_FACTORY.parse(start), TOKEN_FACTORY.parse(end));
    }

    private static TokenRange range(Token startToken, Token endToken) {
        return new Murmur3TokenRange((Murmur3Token)startToken, (Murmur3Token)endToken);
    }
}

