/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra21SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra22SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra3SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra4SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.DefaultSchemaQueriesFactory;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Dse68SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueries;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class DefaultSchemaQueriesFactoryTest {
    private static ImmutableList<ImmutableList<Object>> cassandraVersions = ImmutableList.builder().add((Object)ImmutableList.of((Object)"2.1.0", Optional.empty(), (Object)((Object)Expected.CASS_21))).add((Object)ImmutableList.of((Object)"2.2.0", Optional.empty(), (Object)((Object)Expected.CASS_22))).add((Object)ImmutableList.of((Object)"2.2.1", Optional.empty(), (Object)((Object)Expected.CASS_22))).add((Object)ImmutableList.of((Object)"2.3.0", Optional.empty(), (Object)((Object)Expected.CASS_22))).add((Object)ImmutableList.of((Object)"3.0.0", Optional.empty(), (Object)((Object)Expected.CASS_3))).add((Object)ImmutableList.of((Object)"3.0.1", Optional.empty(), (Object)((Object)Expected.CASS_3))).add((Object)ImmutableList.of((Object)"3.1.0", Optional.empty(), (Object)((Object)Expected.CASS_3))).add((Object)ImmutableList.of((Object)"4.0.0", Optional.empty(), (Object)((Object)Expected.CASS_4))).add((Object)ImmutableList.of((Object)"4.0.1", Optional.empty(), (Object)((Object)Expected.CASS_4))).add((Object)ImmutableList.of((Object)"4.1.0", Optional.empty(), (Object)((Object)Expected.CASS_4))).build();
    private static ImmutableList<ImmutableList<Object>> dseVersions = ImmutableList.builder().add((Object)ImmutableList.of((Object)"4.0.0.2284", Optional.of("6.0.0"), (Object)((Object)Expected.CASS_3))).add((Object)ImmutableList.of((Object)"4.0.0.2349", Optional.of("6.0.1"), (Object)((Object)Expected.CASS_3))).add((Object)ImmutableList.of((Object)"4.0.0.602", Optional.of("6.0.2"), (Object)((Object)Expected.CASS_3))).add((Object)ImmutableList.of((Object)"4.0.0.670", Optional.of("6.7.0"), (Object)((Object)Expected.CASS_4))).add((Object)ImmutableList.of((Object)"4.0.0.680", Optional.of("6.8.0"), (Object)((Object)Expected.DSE_6_8))).build();
    private static ImmutableList<ImmutableList<Object>> allVersions = ImmutableList.builder().addAll(cassandraVersions).addAll(dseVersions).build();

    @DataProvider(format="%m %p[1] => %p[0]")
    public static Iterable<?> expected() {
        return allVersions;
    }

    @Test
    @UseDataProvider(value="expected")
    public void should_return_correct_schema_queries_impl(String cassandraVersion, Optional<String> dseVersion, Expected expected) {
        Node mockNode = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)mockNode.getCassandraVersion()).thenReturn((Object)Version.parse((String)cassandraVersion));
        dseVersion.ifPresent(versionStr -> Mockito.when((Object)mockNode.getExtras()).thenReturn((Object)ImmutableMap.of((Object)"DSE_VERSION", (Object)Version.parse((String)versionStr))));
        DefaultSchemaQueriesFactory factory = this.buildFactory();
        SchemaQueries queries = factory.newInstance(mockNode, (DriverChannel)Mockito.mock(DriverChannel.class));
        Assertions.assertThat(queries.getClass()).isEqualTo(expected.getClz());
    }

    private DefaultSchemaQueriesFactory buildFactory() {
        DriverExecutionProfile mockProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        DriverConfig mockConfig = (DriverConfig)Mockito.mock(DriverConfig.class);
        Mockito.when((Object)mockConfig.getDefaultProfile()).thenReturn((Object)mockProfile);
        InternalDriverContext mockInternalCtx = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        Mockito.when((Object)mockInternalCtx.getConfig()).thenReturn((Object)mockConfig);
        return new DefaultSchemaQueriesFactory(mockInternalCtx);
    }

    static enum Expected {
        CASS_21(Cassandra21SchemaQueries.class),
        CASS_22(Cassandra22SchemaQueries.class),
        CASS_3(Cassandra3SchemaQueries.class),
        CASS_4(Cassandra4SchemaQueries.class),
        DSE_6_8(Dse68SchemaQueries.class);

        final Class<? extends SchemaQueries> clz;

        private Expected(Class<? extends SchemaQueries> clz) {
            this.clz = clz;
        }

        public Class<? extends SchemaQueries> getClz() {
            return this.clz;
        }
    }
}

