/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.queries;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.adminrequest.AdminResult;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.Cassandra21SchemaQueries;
import com.datastax.oss.driver.internal.core.metadata.schema.queries.SchemaQueriesTest;
import com.datastax.oss.driver.shaded.guava.common.collect.Multimap;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingDeque;
import org.junit.Test;
import org.mockito.Mockito;

public class Cassandra21SchemaQueriesTest
extends SchemaQueriesTest {
    @Test
    public void should_query() {
        Mockito.when((Object)this.config.getStringList((DriverOption)DefaultDriverOption.METADATA_SCHEMA_REFRESHED_KEYSPACES, Collections.emptyList())).thenReturn(Collections.emptyList());
        Mockito.when((Object)this.node.getCassandraVersion()).thenReturn((Object)Version.V2_1_0);
        SchemaQueriesWithMockedChannel queries = new SchemaQueriesWithMockedChannel(this.driverChannel, this.node, this.config, "test");
        CompletionStage result = queries.execute();
        SchemaQueriesTest.Call call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system.schema_keyspaces");
        call.result.complete(Cassandra21SchemaQueriesTest.mockResult(Cassandra21SchemaQueriesTest.mockRow("keyspace_name", "ks1"), Cassandra21SchemaQueriesTest.mockRow("keyspace_name", "ks2")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system.schema_usertypes");
        call.result.complete(Cassandra21SchemaQueriesTest.mockResult(Cassandra21SchemaQueriesTest.mockRow("keyspace_name", "ks1", "type_name", "type")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system.schema_columnfamilies");
        call.result.complete(Cassandra21SchemaQueriesTest.mockResult(Cassandra21SchemaQueriesTest.mockRow("keyspace_name", "ks1", "columnfamily_name", "foo")));
        call = queries.calls.poll();
        Assertions.assertThat((String)call.query).isEqualTo("SELECT * FROM system.schema_columns");
        call.result.complete(Cassandra21SchemaQueriesTest.mockResult(Cassandra21SchemaQueriesTest.mockRow("keyspace_name", "ks1", "columnfamily_name", "foo", "column_name", "k")));
        this.channel.runPendingTasks();
        Assertions.assertThatStage(result).isSuccess(rows -> {
            Assertions.assertThat((Object)rows.getNode()).isEqualTo((Object)this.node);
            Assertions.assertThat((List)rows.keyspaces()).hasSize(2);
            Assertions.assertThat((String)((AdminRow)rows.keyspaces().get(0)).getString("keyspace_name")).isEqualTo("ks1");
            Assertions.assertThat((String)((AdminRow)rows.keyspaces().get(1)).getString("keyspace_name")).isEqualTo("ks2");
            Assertions.assertThat((Iterable)rows.types().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS1_ID});
            Assertions.assertThat((Iterable)rows.types().get((Object)KS1_ID)).hasSize(1);
            Assertions.assertThat((String)((AdminRow)rows.types().get((Object)KS1_ID).iterator().next()).getString("type_name")).isEqualTo("type");
            Assertions.assertThat((Iterable)rows.tables().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS1_ID});
            Assertions.assertThat((Iterable)rows.tables().get((Object)KS1_ID)).hasSize(1);
            Assertions.assertThat((String)((AdminRow)rows.tables().get((Object)KS1_ID).iterator().next()).getString("columnfamily_name")).isEqualTo("foo");
            Assertions.assertThat(rows.columns().keySet()).containsOnly((Object[])new CqlIdentifier[]{KS1_ID});
            Assertions.assertThat((Iterable)((Multimap)rows.columns().get(KS1_ID)).keySet()).containsOnly((Object[])new CqlIdentifier[]{FOO_ID});
            Assertions.assertThat((String)((AdminRow)((Multimap)rows.columns().get(KS1_ID)).get((Object)FOO_ID).iterator().next()).getString("column_name")).isEqualTo("k");
            Assertions.assertThat((Iterable)rows.views().keySet()).isEmpty();
            Assertions.assertThat((Iterable)rows.functions().keySet()).isEmpty();
            Assertions.assertThat((Iterable)rows.aggregates().keySet()).isEmpty();
        });
    }

    static class SchemaQueriesWithMockedChannel
    extends Cassandra21SchemaQueries {
        final Queue<SchemaQueriesTest.Call> calls = new LinkedBlockingDeque<SchemaQueriesTest.Call>();

        SchemaQueriesWithMockedChannel(DriverChannel channel, Node node, DriverExecutionProfile config, String logPrefix) {
            super(channel, node, config, logPrefix);
        }

        protected CompletionStage<AdminResult> query(String query) {
            SchemaQueriesTest.Call call = new SchemaQueriesTest.Call(query);
            this.calls.add(call);
            return call.result;
        }
    }
}

