/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata.schema.parsing;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeClassNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeCqlNameParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.DataTypeParser;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.SchemaParserTestBase;
import com.datastax.oss.driver.internal.core.metadata.schema.parsing.UserDefinedTypeParser;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class UserDefinedTypeListParserTest
extends SchemaParserTestBase {
    private static final AdminRow PERSON_ROW_2_2 = UserDefinedTypeListParserTest.mockTypeRow("ks", "person", (List<String>)ImmutableList.of((Object)"first_name", (Object)"last_name", (Object)"address"), (List<String>)ImmutableList.of((Object)"org.apache.cassandra.db.marshal.UTF8Type", (Object)"org.apache.cassandra.db.marshal.UTF8Type", (Object)"org.apache.cassandra.db.marshal.UserType(ks,61646472657373,737472656574:org.apache.cassandra.db.marshal.UTF8Type,7a6970636f6465:org.apache.cassandra.db.marshal.Int32Type)"));
    private static final AdminRow PERSON_ROW_3_0 = UserDefinedTypeListParserTest.mockTypeRow("ks", "person", (List<String>)ImmutableList.of((Object)"first_name", (Object)"last_name", (Object)"address"), (List<String>)ImmutableList.of((Object)"text", (Object)"text", (Object)"address"));
    private static final AdminRow ADDRESS_ROW_3_0 = UserDefinedTypeListParserTest.mockTypeRow("ks", "address", (List<String>)ImmutableList.of((Object)"street", (Object)"zipcode"), (List<String>)ImmutableList.of((Object)"text", (Object)"int"));

    @Test
    public void should_parse_modern_table() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        Map types = parser.parse(KEYSPACE_ID, new AdminRow[]{PERSON_ROW_3_0, ADDRESS_ROW_3_0});
        Assertions.assertThat((Map)types).hasSize(2);
        UserDefinedType personType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"person"));
        UserDefinedType addressType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"address"));
        Assertions.assertThat((String)personType.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)personType.getName().asInternal()).isEqualTo("person");
        Assertions.assertThat((List)personType.getFieldNames()).containsExactly((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"first_name"), CqlIdentifier.fromInternal((String)"last_name"), CqlIdentifier.fromInternal((String)"address")});
        Assertions.assertThat((Object)((DataType)personType.getFieldTypes().get(0))).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat((Object)((DataType)personType.getFieldTypes().get(1))).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat((Object)((DataType)personType.getFieldTypes().get(2))).isSameAs((Object)addressType);
    }

    @Test
    public void should_parse_legacy_table() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeClassNameParser(), this.context);
        Map types = parser.parse(KEYSPACE_ID, new AdminRow[]{PERSON_ROW_2_2});
        Assertions.assertThat((Map)types).hasSize(1);
        UserDefinedType personType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"person"));
        Assertions.assertThat((String)personType.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)personType.getName().asInternal()).isEqualTo("person");
        Assertions.assertThat((List)personType.getFieldNames()).containsExactly((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"first_name"), CqlIdentifier.fromInternal((String)"last_name"), CqlIdentifier.fromInternal((String)"address")});
        Assertions.assertThat((Object)((DataType)personType.getFieldTypes().get(0))).isEqualTo((Object)DataTypes.TEXT);
        Assertions.assertThat((Object)((DataType)personType.getFieldTypes().get(1))).isEqualTo((Object)DataTypes.TEXT);
        UserDefinedType addressType = (UserDefinedType)personType.getFieldTypes().get(2);
        Assertions.assertThat((String)addressType.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)addressType.getName().asInternal()).isEqualTo("address");
        Assertions.assertThat((List)addressType.getFieldNames()).containsExactly((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"street"), CqlIdentifier.fromInternal((String)"zipcode")});
    }

    @Test
    public void should_parse_empty_list() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        Assertions.assertThat((Map)parser.parse(KEYSPACE_ID, new AdminRow[0])).isEmpty();
    }

    @Test
    public void should_parse_singleton_list() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        Map types = parser.parse(KEYSPACE_ID, new AdminRow[]{UserDefinedTypeListParserTest.mockTypeRow("ks", "t", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int"))});
        Assertions.assertThat((Map)types).hasSize(1);
        UserDefinedType type = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"t"));
        Assertions.assertThat((String)type.getKeyspace().asInternal()).isEqualTo("ks");
        Assertions.assertThat((String)type.getName().asInternal()).isEqualTo("t");
        Assertions.assertThat((List)type.getFieldNames()).containsExactly((Object[])new CqlIdentifier[]{CqlIdentifier.fromInternal((String)"i")});
        Assertions.assertThat((List)type.getFieldTypes()).containsExactly((Object[])new DataType[]{DataTypes.INT});
    }

    @Test
    public void should_resolve_list_dependency() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        Map types = parser.parse(KEYSPACE_ID, new AdminRow[]{UserDefinedTypeListParserTest.mockTypeRow("ks", "a", (List<String>)ImmutableList.of((Object)"bs"), (List<String>)ImmutableList.of((Object)"frozen<list<frozen<b>>>")), UserDefinedTypeListParserTest.mockTypeRow("ks", "b", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int"))});
        Assertions.assertThat((Map)types).hasSize(2);
        UserDefinedType aType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"a"));
        UserDefinedType bType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"b"));
        Assertions.assertThat((Object)((ListType)aType.getFieldTypes().get(0)).getElementType()).isEqualTo((Object)bType);
    }

    @Test
    public void should_resolve_set_dependency() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        Map types = parser.parse(KEYSPACE_ID, new AdminRow[]{UserDefinedTypeListParserTest.mockTypeRow("ks", "a", (List<String>)ImmutableList.of((Object)"bs"), (List<String>)ImmutableList.of((Object)"frozen<set<frozen<b>>>")), UserDefinedTypeListParserTest.mockTypeRow("ks", "b", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int"))});
        Assertions.assertThat((Map)types).hasSize(2);
        UserDefinedType aType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"a"));
        UserDefinedType bType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"b"));
        Assertions.assertThat((Object)((SetType)aType.getFieldTypes().get(0)).getElementType()).isEqualTo((Object)bType);
    }

    @Test
    public void should_resolve_map_dependency() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        Map types = parser.parse(KEYSPACE_ID, new AdminRow[]{UserDefinedTypeListParserTest.mockTypeRow("ks", "a1", (List<String>)ImmutableList.of((Object)"bs"), (List<String>)ImmutableList.of((Object)"frozen<map<int, frozen<b>>>")), UserDefinedTypeListParserTest.mockTypeRow("ks", "a2", (List<String>)ImmutableList.of((Object)"bs"), (List<String>)ImmutableList.of((Object)"frozen<map<frozen<b>, int>>")), UserDefinedTypeListParserTest.mockTypeRow("ks", "b", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int"))});
        Assertions.assertThat((Map)types).hasSize(3);
        UserDefinedType a1Type = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"a1"));
        UserDefinedType a2Type = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"a2"));
        UserDefinedType bType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"b"));
        Assertions.assertThat((Object)((MapType)a1Type.getFieldTypes().get(0)).getValueType()).isEqualTo((Object)bType);
        Assertions.assertThat((Object)((MapType)a2Type.getFieldTypes().get(0)).getKeyType()).isEqualTo((Object)bType);
    }

    @Test
    public void should_resolve_tuple_dependency() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        Map types = parser.parse(KEYSPACE_ID, new AdminRow[]{UserDefinedTypeListParserTest.mockTypeRow("ks", "a", (List<String>)ImmutableList.of((Object)"b"), (List<String>)ImmutableList.of((Object)"frozen<tuple<int, frozen<b>>>")), UserDefinedTypeListParserTest.mockTypeRow("ks", "b", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int"))});
        Assertions.assertThat((Map)types).hasSize(2);
        UserDefinedType aType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"a"));
        UserDefinedType bType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"b"));
        Assertions.assertThat((Object)((DataType)((TupleType)aType.getFieldTypes().get(0)).getComponentTypes().get(1))).isEqualTo((Object)bType);
    }

    @Test
    public void should_resolve_nested_dependency() {
        UserDefinedTypeParser parser = new UserDefinedTypeParser((DataTypeParser)new DataTypeCqlNameParser(), this.context);
        Map types = parser.parse(KEYSPACE_ID, new AdminRow[]{UserDefinedTypeListParserTest.mockTypeRow("ks", "a", (List<String>)ImmutableList.of((Object)"bs"), (List<String>)ImmutableList.of((Object)"frozen<tuple<int, frozen<list<frozen<b>>>>>")), UserDefinedTypeListParserTest.mockTypeRow("ks", "b", (List<String>)ImmutableList.of((Object)"i"), (List<String>)ImmutableList.of((Object)"int"))});
        Assertions.assertThat((Map)types).hasSize(2);
        UserDefinedType aType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"a"));
        UserDefinedType bType = (UserDefinedType)types.get(CqlIdentifier.fromInternal((String)"b"));
        TupleType tupleType = (TupleType)aType.getFieldTypes().get(0);
        ListType listType = (ListType)tupleType.getComponentTypes().get(1);
        Assertions.assertThat((Object)listType.getElementType()).isEqualTo((Object)bType);
    }
}

