/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.internal.core.adminrequest.AdminRow;
import com.datastax.oss.driver.internal.core.metadata.PeerRowValidator;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class PeerRowValidatorTest {
    @DataProvider
    public static Object[][] nullColumnsV1() {
        return new Object[][]{{"rpc_address"}, {"host_id"}, {"data_center"}, {"rack"}, {"tokens"}, {"schema_version"}};
    }

    @DataProvider
    public static Object[][] nullColumnsV2() {
        return new Object[][]{{"native_address"}, {"native_port"}, {"host_id"}, {"data_center"}, {"rack"}, {"tokens"}, {"schema_version"}};
    }

    @Test
    @UseDataProvider(value="nullColumnsV1")
    public void should_fail_for_invalid_peer_v1(String nullColumn) {
        Assertions.assertThat((boolean)PeerRowValidator.isValid((AdminRow)this.mockRowV1(nullColumn))).isFalse();
    }

    @Test
    @UseDataProvider(value="nullColumnsV2")
    public void should_fail_for_invalid_peer_v2(String nullColumn) {
        Assertions.assertThat((boolean)PeerRowValidator.isValid((AdminRow)this.mockRowV2(nullColumn))).isFalse();
    }

    @Test
    public void should_succeed_for_valid_peer_v1() {
        AdminRow peerRow = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)peerRow.isNull("host_id")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("rpc_address")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("native_address")).thenReturn((Object)true);
        Mockito.when((Object)peerRow.isNull("native_port")).thenReturn((Object)true);
        Mockito.when((Object)peerRow.isNull("data_center")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("rack")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("tokens")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("schema_version")).thenReturn((Object)false);
        Assertions.assertThat((boolean)PeerRowValidator.isValid((AdminRow)peerRow)).isTrue();
    }

    @Test
    public void should_succeed_for_valid_peer_v2() {
        AdminRow peerRow = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)peerRow.isNull("host_id")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("rpc_address")).thenReturn((Object)true);
        Mockito.when((Object)peerRow.isNull("native_address")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("native_port")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("data_center")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("rack")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("tokens")).thenReturn((Object)false);
        Mockito.when((Object)peerRow.isNull("schema_version")).thenReturn((Object)false);
        Assertions.assertThat((boolean)PeerRowValidator.isValid((AdminRow)peerRow)).isTrue();
    }

    private AdminRow mockRowV1(String nullColumn) {
        AdminRow peerRow = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)peerRow.isNull("host_id")).thenReturn((Object)nullColumn.equals("host_id"));
        Mockito.when((Object)peerRow.isNull("rpc_address")).thenReturn((Object)nullColumn.equals("rpc_address"));
        Mockito.when((Object)peerRow.isNull("native_address")).thenReturn((Object)true);
        Mockito.when((Object)peerRow.isNull("native_port")).thenReturn((Object)true);
        Mockito.when((Object)peerRow.isNull("data_center")).thenReturn((Object)nullColumn.equals("data_center"));
        Mockito.when((Object)peerRow.isNull("rack")).thenReturn((Object)nullColumn.equals("rack"));
        Mockito.when((Object)peerRow.isNull("tokens")).thenReturn((Object)nullColumn.equals("tokens"));
        Mockito.when((Object)peerRow.isNull("schema_version")).thenReturn((Object)nullColumn.equals("schema_version"));
        return peerRow;
    }

    private AdminRow mockRowV2(String nullColumn) {
        AdminRow peerRow = (AdminRow)Mockito.mock(AdminRow.class);
        Mockito.when((Object)peerRow.isNull("host_id")).thenReturn((Object)nullColumn.equals("host_id"));
        Mockito.when((Object)peerRow.isNull("native_address")).thenReturn((Object)nullColumn.equals("native_address"));
        Mockito.when((Object)peerRow.isNull("native_port")).thenReturn((Object)nullColumn.equals("native_port"));
        Mockito.when((Object)peerRow.isNull("rpc_address")).thenReturn((Object)true);
        Mockito.when((Object)peerRow.isNull("data_center")).thenReturn((Object)nullColumn.equals("data_center"));
        Mockito.when((Object)peerRow.isNull("rack")).thenReturn((Object)nullColumn.equals("rack"));
        Mockito.when((Object)peerRow.isNull("tokens")).thenReturn((Object)nullColumn.equals("tokens"));
        Mockito.when((Object)peerRow.isNull("schema_version")).thenReturn((Object)nullColumn.equals("schema_version"));
        return peerRow;
    }
}

