/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metadata.NodeState;
import com.datastax.oss.driver.internal.core.channel.ChannelEvent;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.metadata.DefaultMetadata;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.NodeStateEvent;
import com.datastax.oss.driver.internal.core.metadata.NodeStateManager;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metadata.TopologyEvent;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import com.datastax.oss.driver.internal.core.util.concurrent.BlockingOperation;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.UnmodifiableIterator;
import com.datastax.oss.driver.shaded.guava.common.util.concurrent.Uninterruptibles;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class NodeStateManagerTest {
    private static final InetSocketAddress NEW_ADDRESS = new InetSocketAddress("127.0.0.3", 9042);
    @Mock
    private InternalDriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;
    @Mock
    private NettyOptions nettyOptions;
    @Mock
    private MetadataManager metadataManager;
    @Mock
    protected MetricsFactory metricsFactory;
    private DefaultNode node1;
    private DefaultNode node2;
    private EventBus eventBus;
    private DefaultEventLoopGroup adminEventLoopGroup;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.METADATA_TOPOLOGY_WINDOW)).thenReturn((Object)Duration.ofSeconds(0L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.METADATA_TOPOLOGY_MAX_EVENTS)).thenReturn((Object)1);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        this.eventBus = (EventBus)Mockito.spy((Object)new EventBus("test"));
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)this.eventBus);
        this.adminEventLoopGroup = new DefaultEventLoopGroup(1, (ThreadFactory)new BlockingOperation.SafeThreadFactory());
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)this.adminEventLoopGroup);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        this.node1 = TestNodeFactory.newNode(1, this.context);
        this.node2 = TestNodeFactory.newNode(2, this.context);
        ImmutableMap nodes = ImmutableMap.builder().put((Object)this.node1.getHostId(), (Object)this.node1).put((Object)this.node2.getHostId(), (Object)this.node2).build();
        DefaultMetadata metadata = new DefaultMetadata((Map)nodes, Collections.emptyMap(), null, null);
        Mockito.when((Object)this.metadataManager.getMetadata()).thenReturn((Object)metadata);
        Mockito.when((Object)this.metadataManager.refreshNode((Node)ArgumentMatchers.any(Node.class))).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.context.getMetadataManager()).thenReturn((Object)this.metadataManager);
    }

    @After
    public void teardown() {
        this.adminEventLoopGroup.shutdownGracefully(100L, 200L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void should_ignore_up_event_if_node_is_already_up_or_forced_down() {
        new NodeStateManager(this.context);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)NodeState.UP, (Object)NodeState.FORCED_DOWN).iterator();
        while (unmodifiableIterator.hasNext()) {
            NodeState oldState;
            this.node1.state = oldState = (NodeState)unmodifiableIterator.next();
            this.eventBus.fire((Object)TopologyEvent.suggestUp((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
            this.waitForPendingAdminTasks();
            Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)oldState);
        }
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
    }

    @Test
    public void should_apply_up_event_if_node_is_unknown_or_down() {
        new NodeStateManager(this.context);
        int i = 0;
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)NodeState.UNKNOWN, (Object)NodeState.DOWN).iterator();
        while (unmodifiableIterator.hasNext()) {
            NodeState oldState;
            this.node1.state = oldState = (NodeState)unmodifiableIterator.next();
            this.eventBus.fire((Object)TopologyEvent.suggestUp((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
            this.waitForPendingAdminTasks();
            Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.UP);
            if (oldState != NodeState.UNKNOWN) {
                ((MetadataManager)Mockito.verify((Object)this.metadataManager, (VerificationMode)Mockito.times((int)(++i)))).refreshNode((Node)this.node1);
            }
            ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)NodeStateEvent.changed((NodeState)oldState, (NodeState)NodeState.UP, (DefaultNode)this.node1));
        }
    }

    @Test
    public void should_refresh_node_list_if_up_event_and_not_in_metadata() {
        new NodeStateManager(this.context);
        this.eventBus.fire((Object)TopologyEvent.suggestUp((InetSocketAddress)NEW_ADDRESS));
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
        ((MetadataManager)Mockito.verify((Object)this.metadataManager)).refreshNodes();
    }

    @Test
    public void should_ignore_down_event_if_node_is_down_or_forced_down() {
        new NodeStateManager(this.context);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)NodeState.DOWN, (Object)NodeState.FORCED_DOWN).iterator();
        while (unmodifiableIterator.hasNext()) {
            NodeState oldState;
            this.node1.state = oldState = (NodeState)unmodifiableIterator.next();
            this.eventBus.fire((Object)TopologyEvent.suggestDown((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
            this.waitForPendingAdminTasks();
            Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)oldState);
        }
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
    }

    @Test
    public void should_ignore_down_event_if_node_has_active_connections() {
        new NodeStateManager(this.context);
        this.node1.state = NodeState.UP;
        this.eventBus.fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((int)this.node1.openConnections).isEqualTo(1);
        this.eventBus.fire((Object)TopologyEvent.suggestDown((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.UP);
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
    }

    @Test
    public void should_apply_down_event_if_node_has_no_active_connections() {
        new NodeStateManager(this.context);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)NodeState.UP, (Object)NodeState.UNKNOWN).iterator();
        while (unmodifiableIterator.hasNext()) {
            NodeState oldState;
            this.node1.state = oldState = (NodeState)unmodifiableIterator.next();
            Assertions.assertThat((int)this.node1.openConnections).isEqualTo(0);
            this.eventBus.fire((Object)TopologyEvent.suggestDown((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
            this.waitForPendingAdminTasks();
            Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.DOWN);
            ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)NodeStateEvent.changed((NodeState)oldState, (NodeState)NodeState.DOWN, (DefaultNode)this.node1));
        }
    }

    @Test
    public void should_ignore_down_event_if_not_in_metadata() {
        new NodeStateManager(this.context);
        this.eventBus.fire((Object)TopologyEvent.suggestDown((InetSocketAddress)NEW_ADDRESS));
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
        ((MetadataManager)Mockito.verify((Object)this.metadataManager, (VerificationMode)Mockito.never())).addNode(NEW_ADDRESS);
    }

    @Test
    public void should_ignore_force_down_event_if_already_forced_down() {
        new NodeStateManager(this.context);
        this.node1.state = NodeState.FORCED_DOWN;
        this.eventBus.fire((Object)TopologyEvent.forceDown((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.FORCED_DOWN);
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
    }

    @Test
    public void should_apply_force_down_event_over_any_other_state() {
        new NodeStateManager(this.context);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)NodeState.UNKNOWN, (Object)NodeState.DOWN, (Object)NodeState.UP).iterator();
        while (unmodifiableIterator.hasNext()) {
            NodeState oldState;
            this.node1.state = oldState = (NodeState)unmodifiableIterator.next();
            this.eventBus.fire((Object)TopologyEvent.forceDown((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
            this.waitForPendingAdminTasks();
            Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.FORCED_DOWN);
            ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)NodeStateEvent.changed((NodeState)oldState, (NodeState)NodeState.FORCED_DOWN, (DefaultNode)this.node1));
        }
    }

    @Test
    public void should_ignore_force_down_event_if_not_in_metadata() {
        new NodeStateManager(this.context);
        this.eventBus.fire((Object)TopologyEvent.forceDown((InetSocketAddress)NEW_ADDRESS));
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
        ((MetadataManager)Mockito.verify((Object)this.metadataManager, (VerificationMode)Mockito.never())).addNode(NEW_ADDRESS);
    }

    @Test
    public void should_ignore_force_up_event_if_node_is_already_up() {
        new NodeStateManager(this.context);
        this.node1.state = NodeState.UP;
        this.eventBus.fire((Object)TopologyEvent.forceUp((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.UP);
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
    }

    @Test
    public void should_apply_force_up_event_if_node_is_not_up() {
        new NodeStateManager(this.context);
        int i = 0;
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)NodeState.UNKNOWN, (Object)NodeState.DOWN, (Object)NodeState.FORCED_DOWN).iterator();
        while (unmodifiableIterator.hasNext()) {
            NodeState oldState;
            this.node1.state = oldState = (NodeState)unmodifiableIterator.next();
            this.eventBus.fire((Object)TopologyEvent.forceUp((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
            this.waitForPendingAdminTasks();
            Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.UP);
            ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)NodeStateEvent.changed((NodeState)oldState, (NodeState)NodeState.UP, (DefaultNode)this.node1));
            if (oldState == NodeState.UNKNOWN) continue;
            ((MetadataManager)Mockito.verify((Object)this.metadataManager, (VerificationMode)Mockito.times((int)(++i)))).refreshNode((Node)this.node1);
        }
    }

    @Test
    public void should_add_node_if_force_up_and_not_in_metadata() {
        new NodeStateManager(this.context);
        this.eventBus.fire((Object)TopologyEvent.forceUp((InetSocketAddress)NEW_ADDRESS));
        this.waitForPendingAdminTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
        ((MetadataManager)Mockito.verify((Object)this.metadataManager)).addNode(NEW_ADDRESS);
    }

    @Test
    public void should_notify_metadata_of_node_addition() {
        new NodeStateManager(this.context);
        InetSocketAddress newAddress = NEW_ADDRESS;
        this.eventBus.fire((Object)TopologyEvent.suggestAdded((InetSocketAddress)newAddress));
        this.waitForPendingAdminTasks();
        ((MetadataManager)Mockito.verify((Object)this.metadataManager)).addNode(newAddress);
    }

    @Test
    public void should_ignore_addition_of_existing_node() {
        new NodeStateManager(this.context);
        this.eventBus.fire((Object)TopologyEvent.suggestAdded((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
        this.waitForPendingAdminTasks();
        ((MetadataManager)Mockito.verify((Object)this.metadataManager, (VerificationMode)Mockito.never())).addNode((InetSocketAddress)ArgumentMatchers.any(InetSocketAddress.class));
    }

    @Test
    public void should_notify_metadata_of_node_removal() {
        new NodeStateManager(this.context);
        this.eventBus.fire((Object)TopologyEvent.suggestRemoved((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
        this.waitForPendingAdminTasks();
        ((MetadataManager)Mockito.verify((Object)this.metadataManager)).removeNode((InetSocketAddress)this.node1.getBroadcastRpcAddress().get());
    }

    @Test
    public void should_ignore_removal_of_nonexistent_node() {
        new NodeStateManager(this.context);
        InetSocketAddress newAddress = NEW_ADDRESS;
        this.eventBus.fire((Object)TopologyEvent.suggestRemoved((InetSocketAddress)newAddress));
        this.waitForPendingAdminTasks();
        ((MetadataManager)Mockito.verify((Object)this.metadataManager, (VerificationMode)Mockito.never())).removeNode((InetSocketAddress)ArgumentMatchers.any(InetSocketAddress.class));
    }

    @Test
    public void should_coalesce_topology_events() {
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.METADATA_TOPOLOGY_WINDOW)).thenReturn((Object)Duration.ofDays(1L));
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.METADATA_TOPOLOGY_MAX_EVENTS)).thenReturn((Object)5);
        new NodeStateManager(this.context);
        this.node1.state = NodeState.FORCED_DOWN;
        this.node2.state = NodeState.DOWN;
        this.eventBus.fire((Object)TopologyEvent.suggestDown((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
        this.eventBus.fire((Object)TopologyEvent.forceUp((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
        this.eventBus.fire((Object)TopologyEvent.suggestDown((InetSocketAddress)((InetSocketAddress)this.node2.getBroadcastRpcAddress().get())));
        this.eventBus.fire((Object)TopologyEvent.suggestDown((InetSocketAddress)((InetSocketAddress)this.node1.getBroadcastRpcAddress().get())));
        this.eventBus.fire((Object)TopologyEvent.suggestUp((InetSocketAddress)((InetSocketAddress)this.node2.getBroadcastRpcAddress().get())));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.UP);
        Assertions.assertThat((Comparable)this.node2.state).isEqualTo((Object)NodeState.UP);
    }

    @Test
    public void should_track_open_connections() {
        new NodeStateManager(this.context);
        Assertions.assertThat((int)this.node1.openConnections).isEqualTo(0);
        this.eventBus.fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.eventBus.fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((int)this.node1.openConnections).isEqualTo(2);
        this.eventBus.fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((int)this.node1.openConnections).isEqualTo(1);
    }

    @Test
    public void should_mark_node_up_if_down_or_unknown_and_connection_opened() {
        new NodeStateManager(this.context);
        UnmodifiableIterator unmodifiableIterator = ImmutableList.of((Object)NodeState.DOWN, (Object)NodeState.UNKNOWN).iterator();
        while (unmodifiableIterator.hasNext()) {
            NodeState oldState;
            this.node1.state = oldState = (NodeState)unmodifiableIterator.next();
            this.eventBus.fire((Object)ChannelEvent.channelOpened((Node)this.node1));
            this.waitForPendingAdminTasks();
            Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.UP);
            ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)NodeStateEvent.changed((NodeState)oldState, (NodeState)NodeState.UP, (DefaultNode)this.node1));
        }
    }

    @Test
    public void should_not_mark_node_up_if_forced_down_and_connection_opened() {
        new NodeStateManager(this.context);
        this.node1.state = NodeState.FORCED_DOWN;
        this.eventBus.fire((Object)ChannelEvent.channelOpened((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.FORCED_DOWN);
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
    }

    @Test
    public void should_track_reconnections() {
        new NodeStateManager(this.context);
        Assertions.assertThat((int)this.node1.reconnections).isEqualTo(0);
        this.eventBus.fire((Object)ChannelEvent.reconnectionStarted((Node)this.node1));
        this.eventBus.fire((Object)ChannelEvent.reconnectionStarted((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((int)this.node1.reconnections).isEqualTo(2);
        this.eventBus.fire((Object)ChannelEvent.reconnectionStopped((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((int)this.node1.reconnections).isEqualTo(1);
    }

    @Test
    public void should_mark_node_down_if_reconnection_starts_with_no_connections() {
        new NodeStateManager(this.context);
        this.node1.state = NodeState.UP;
        this.node1.openConnections = 1;
        this.eventBus.fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        this.eventBus.fire((Object)ChannelEvent.reconnectionStarted((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.DOWN);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)NodeStateEvent.changed((NodeState)NodeState.UP, (NodeState)NodeState.DOWN, (DefaultNode)this.node1));
    }

    @Test
    public void should_mark_node_down_if_no_connections_and_reconnection_already_started() {
        new NodeStateManager(this.context);
        this.node1.state = NodeState.UP;
        this.node1.openConnections = 1;
        this.eventBus.fire((Object)ChannelEvent.reconnectionStarted((Node)this.node1));
        this.eventBus.fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.DOWN);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)NodeStateEvent.changed((NodeState)NodeState.UP, (NodeState)NodeState.DOWN, (DefaultNode)this.node1));
    }

    @Test
    public void should_keep_node_up_if_reconnection_starts_with_some_connections() {
        new NodeStateManager(this.context);
        this.node1.state = NodeState.UP;
        this.node1.openConnections = 2;
        this.eventBus.fire((Object)ChannelEvent.channelClosed((Node)this.node1));
        this.eventBus.fire((Object)ChannelEvent.reconnectionStarted((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((Comparable)this.node1.state).isEqualTo((Object)NodeState.UP);
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire(ArgumentMatchers.any(NodeStateEvent.class));
    }

    @Test
    public void should_ignore_events_when_closed() throws Exception {
        NodeStateManager manager = new NodeStateManager(this.context);
        Assertions.assertThat((int)this.node1.reconnections).isEqualTo(0);
        manager.close();
        this.eventBus.fire((Object)ChannelEvent.reconnectionStarted((Node)this.node1));
        this.waitForPendingAdminTasks();
        Assertions.assertThat((int)this.node1.reconnections).isEqualTo(0);
    }

    private void waitForPendingAdminTasks() {
        ScheduledFuture f = this.adminEventLoopGroup.schedule(() -> null, 5L, TimeUnit.NANOSECONDS);
        try {
            Uninterruptibles.getUninterruptibly((Future)f, (long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException e) {
            org.assertj.core.api.Assertions.fail((String)"unexpected error", (Throwable)e.getCause());
        }
        catch (TimeoutException e) {
            org.assertj.core.api.Assertions.fail((String)"timed out while waiting for admin tasks to complete", (Throwable)e);
        }
    }
}

