/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.metadata;

import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import java.net.InetSocketAddress;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class DefaultEndPointTest {
    @Test
    public void should_create_from_host_name() {
        DefaultEndPoint endPoint = new DefaultEndPoint(new InetSocketAddress("localhost", 9042));
        Assertions.assertThat((String)endPoint.asMetricPrefix()).isEqualTo("localhost:9042");
    }

    @Test
    public void should_create_from_literal_ipv4_address() {
        DefaultEndPoint endPoint = new DefaultEndPoint(new InetSocketAddress("127.0.0.1", 9042));
        Assertions.assertThat((String)endPoint.asMetricPrefix()).isEqualTo("127_0_0_1:9042");
    }

    @Test
    public void should_create_from_literal_ipv6_address() {
        DefaultEndPoint endPoint = new DefaultEndPoint(new InetSocketAddress("::1", 9042));
        Assertions.assertThat((String)endPoint.asMetricPrefix()).isEqualTo("0:0:0:0:0:0:0:1:9042");
    }

    @Test
    public void should_create_from_unresolved_address() {
        InetSocketAddress address = InetSocketAddress.createUnresolved("test.com", 9042);
        DefaultEndPoint endPoint = new DefaultEndPoint(address);
        Assertions.assertThat((String)endPoint.asMetricPrefix()).isEqualTo("test_com:9042");
        Assertions.assertThat((boolean)address.isUnresolved()).isTrue();
    }

    @Test
    public void should_reject_null_address() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new DefaultEndPoint(null)).isInstanceOf(NullPointerException.class)).hasMessage("address can't be null");
    }
}

