/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing.nodeset;

import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.loadbalancing.nodeset.DcAgnosticNodeSet;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class DcAgnosticNodeSetTest {
    @Test
    public void should_add_node() {
        DcAgnosticNodeSet set = new DcAgnosticNodeSet();
        Node node = (Node)Mockito.mock(Node.class);
        Assertions.assertThat((boolean)set.add(node)).isTrue();
        Assertions.assertThat((boolean)set.add(node)).isFalse();
    }

    @Test
    public void should_remove_node() {
        DcAgnosticNodeSet set = new DcAgnosticNodeSet();
        Node node = (Node)Mockito.mock(Node.class);
        set.add(node);
        Assertions.assertThat((boolean)set.remove(node)).isTrue();
        Assertions.assertThat((boolean)set.remove(node)).isFalse();
    }

    @Test
    public void should_return_all_nodes() {
        DcAgnosticNodeSet set = new DcAgnosticNodeSet();
        Node node1 = (Node)Mockito.mock(Node.class);
        set.add(node1);
        Node node2 = (Node)Mockito.mock(Node.class);
        set.add(node2);
        Assertions.assertThat((Iterable)set.dc(null)).contains((Object[])new Node[]{node1, node2});
        Assertions.assertThat((Iterable)set.dc("irrelevant")).contains((Object[])new Node[]{node1, node2});
    }

    @Test
    public void should_return_empty_dcs() {
        DcAgnosticNodeSet set = new DcAgnosticNodeSet();
        Assertions.assertThat((Iterable)set.dcs()).isEmpty();
    }
}

