/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.LoadBalancingPolicyTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Map;
import java.util.UUID;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.BDDMockito;
import org.mockito.Mock;

public class DefaultLoadBalancingPolicyRequestTrackerTest
extends LoadBalancingPolicyTestBase {
    @Mock
    Request request;
    @Mock
    DriverExecutionProfile profile;
    final String logPrefix = "lbp-test-log-prefix";
    private DefaultLoadBalancingPolicy policy;
    private long nextNanoTime;

    @Override
    @Before
    public void setup() {
        super.setup();
        BDDMockito.given((Object)this.metadataManager.getContactPoints()).willReturn((Object)ImmutableSet.of((Object)this.node1));
        this.policy = new DefaultLoadBalancingPolicy((DriverContext)this.context, "default"){

            protected long nanoTime() {
                return DefaultLoadBalancingPolicyRequestTrackerTest.this.nextNanoTime;
            }
        };
        this.policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3), this.distanceReporter);
    }

    @Test
    public void should_record_first_response_time_on_node_success() {
        this.nextNanoTime = 123L;
        this.policy.onNodeSuccess(this.request, 0L, this.profile, (Node)this.node1, "lbp-test-log-prefix");
        ((MapAssert)Assertions.assertThat((Map)this.policy.responseTimes).hasEntrySatisfying((Object)this.node1, value -> Assertions.assertThat((long)value.get(0)).isEqualTo(123L))).doesNotContainKeys((Object[])new Node[]{this.node2, this.node3});
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node1, this.nextNanoTime)).isTrue();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node2, this.nextNanoTime)).isTrue();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node3, this.nextNanoTime)).isTrue();
    }

    @Test
    public void should_record_second_response_time_on_node_success() {
        this.should_record_first_response_time_on_node_success();
        this.nextNanoTime = 456L;
        this.policy.onNodeSuccess(this.request, 0L, this.profile, (Node)this.node1, "lbp-test-log-prefix");
        ((MapAssert)Assertions.assertThat((Map)this.policy.responseTimes).hasEntrySatisfying((Object)this.node1, value -> {
            Assertions.assertThat((long)value.get(0)).isEqualTo(123L);
            Assertions.assertThat((long)value.get(1)).isEqualTo(456L);
        })).doesNotContainKeys((Object[])new Node[]{this.node2, this.node3});
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node1, this.nextNanoTime)).isFalse();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node2, this.nextNanoTime)).isTrue();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node3, this.nextNanoTime)).isTrue();
    }

    @Test
    public void should_record_further_response_times_on_node_success() {
        this.should_record_second_response_time_on_node_success();
        this.nextNanoTime = 789L;
        this.policy.onNodeSuccess(this.request, 0L, this.profile, (Node)this.node1, "lbp-test-log-prefix");
        this.policy.onNodeSuccess(this.request, 0L, this.profile, (Node)this.node2, "lbp-test-log-prefix");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)this.policy.responseTimes).hasEntrySatisfying((Object)this.node1, value -> {
            Assertions.assertThat((long)value.get(0)).isEqualTo(456L);
            Assertions.assertThat((long)value.get(1)).isEqualTo(789L);
        })).hasEntrySatisfying((Object)this.node2, value -> Assertions.assertThat((long)value.get(0)).isEqualTo(789L))).doesNotContainKey((Object)this.node3);
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node1, this.nextNanoTime)).isFalse();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node2, this.nextNanoTime)).isTrue();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node3, this.nextNanoTime)).isTrue();
    }

    @Test
    public void should_record_first_response_time_on_node_error() {
        this.nextNanoTime = 123L;
        IllegalArgumentException iae = new IllegalArgumentException();
        this.policy.onNodeError(this.request, (Throwable)iae, 0L, this.profile, (Node)this.node1, "lbp-test-log-prefix");
        ((MapAssert)Assertions.assertThat((Map)this.policy.responseTimes).hasEntrySatisfying((Object)this.node1, value -> Assertions.assertThat((long)value.get(0)).isEqualTo(123L))).doesNotContainKeys((Object[])new Node[]{this.node2, this.node3});
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node1, this.nextNanoTime)).isTrue();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node2, this.nextNanoTime)).isTrue();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node3, this.nextNanoTime)).isTrue();
    }

    @Test
    public void should_record_second_response_time_on_node_error() {
        this.should_record_first_response_time_on_node_error();
        this.nextNanoTime = 456L;
        IllegalArgumentException iae = new IllegalArgumentException();
        this.policy.onNodeError(this.request, (Throwable)iae, 0L, this.profile, (Node)this.node1, "lbp-test-log-prefix");
        ((MapAssert)Assertions.assertThat((Map)this.policy.responseTimes).hasEntrySatisfying((Object)this.node1, value -> {
            Assertions.assertThat((long)value.get(0)).isEqualTo(123L);
            Assertions.assertThat((long)value.get(1)).isEqualTo(456L);
        })).doesNotContainKeys((Object[])new Node[]{this.node2, this.node3});
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node1, this.nextNanoTime)).isFalse();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node2, this.nextNanoTime)).isTrue();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node3, this.nextNanoTime)).isTrue();
    }

    @Test
    public void should_record_further_response_times_on_node_error() {
        this.should_record_second_response_time_on_node_error();
        this.nextNanoTime = 789L;
        IllegalArgumentException iae = new IllegalArgumentException();
        this.policy.onNodeError(this.request, (Throwable)iae, 0L, this.profile, (Node)this.node1, "lbp-test-log-prefix");
        this.policy.onNodeError(this.request, (Throwable)iae, 0L, this.profile, (Node)this.node2, "lbp-test-log-prefix");
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)this.policy.responseTimes).hasEntrySatisfying((Object)this.node1, value -> {
            Assertions.assertThat((long)value.get(0)).isEqualTo(456L);
            Assertions.assertThat((long)value.get(1)).isEqualTo(789L);
        })).hasEntrySatisfying((Object)this.node2, value -> Assertions.assertThat((long)value.get(0)).isEqualTo(789L))).doesNotContainKey((Object)this.node3);
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node1, this.nextNanoTime)).isFalse();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node2, this.nextNanoTime)).isTrue();
        Assertions.assertThat((boolean)this.policy.isResponseRateInsufficient((Node)this.node3, this.nextNanoTime)).isTrue();
    }
}

