/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.session.Session;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicyQueryPlanTest;
import com.datastax.oss.driver.internal.core.loadbalancing.DefaultLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.pool.ChannelPool;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLongArray;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;

public class DefaultLoadBalancingPolicyQueryPlanTest
extends BasicLoadBalancingPolicyQueryPlanTest {
    private static final long T0 = Long.MIN_VALUE;
    private static final long T1 = 100L;
    private static final long T2 = 200L;
    private static final long T3 = 300L;
    @Mock
    protected ChannelPool pool1;
    @Mock
    protected ChannelPool pool2;
    @Mock
    protected ChannelPool pool3;
    @Mock
    protected ChannelPool pool4;
    @Mock
    protected ChannelPool pool5;
    long nanoTime;
    int diceRoll;
    private DefaultLoadBalancingPolicy dsePolicy;

    @Override
    @Before
    public void setup() {
        this.nanoTime = 100L;
        this.diceRoll = 4;
        BDDMockito.given((Object)this.node4.getDatacenter()).willReturn((Object)"dc1");
        BDDMockito.given((Object)this.node5.getDatacenter()).willReturn((Object)"dc1");
        BDDMockito.given((Object)this.session.getPools()).willReturn((Object)ImmutableMap.of((Object)this.node1, (Object)this.pool1, (Object)this.node2, (Object)this.pool2, (Object)this.node3, (Object)this.pool3, (Object)this.node4, (Object)this.pool4, (Object)this.node5, (Object)this.pool5));
        BDDMockito.given((Object)this.context.getMetadataManager()).willReturn((Object)this.metadataManager);
        BDDMockito.given((Object)this.metadataManager.getMetadata()).willReturn((Object)this.metadata);
        BDDMockito.given((Object)this.metadataManager.getContactPoints()).willReturn((Object)ImmutableSet.of((Object)this.node1));
        BDDMockito.given((Object)this.metadata.getTokenMap()).willAnswer(invocation -> Optional.of(this.tokenMap));
        super.setup();
        this.dsePolicy = (DefaultLoadBalancingPolicy)this.policy;
        Assertions.assertThat((Iterable)this.dsePolicy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4, this.node5});
    }

    @Test
    public void should_prioritize_and_shuffle_2_replicas() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node3, (Object)this.node5));
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan3 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node2, this.node4, this.node1});
        Assertions.assertThat((Iterable)plan3).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node4, this.node1, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)3))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.never())).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.never())).diceRoll1d4();
    }

    @Test
    public void should_prioritize_and_shuffle_3_or_more_replicas_when_all_healthy_and_all_newly_up() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node3, (Object)this.node5));
        this.dsePolicy.upTimes.put(this.node1, 100L);
        this.dsePolicy.upTimes.put(this.node3, 200L);
        this.dsePolicy.upTimes.put(this.node5, 300L);
        BDDMockito.given((Object)this.pool1.getInFlight()).willReturn((Object)0);
        BDDMockito.given((Object)this.pool3.getInFlight()).willReturn((Object)0);
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node1, this.node3, this.node5, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node1, this.node3, this.node5, this.node4, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.never())).diceRoll1d4();
    }

    @Test
    public void should_prioritize_and_shuffle_3_or_more_replicas_when_all_healthy_and_some_newly_up_and_dice_roll_4() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node3, (Object)this.node5));
        this.dsePolicy.upTimes.put(this.node1, 200L);
        this.dsePolicy.upTimes.put(this.node3, 100L);
        BDDMockito.given((Object)this.pool3.getInFlight()).willReturn((Object)0);
        BDDMockito.given((Object)this.pool5.getInFlight()).willReturn((Object)0);
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node4, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).diceRoll1d4();
    }

    @Test
    public void should_prioritize_and_shuffle_3_or_more_replicas_when_all_healthy_and_some_newly_up_and_dice_roll_1() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node3, (Object)this.node5));
        this.dsePolicy.upTimes.put(this.node1, 200L);
        this.dsePolicy.upTimes.put(this.node3, 100L);
        BDDMockito.given((Object)this.pool1.getInFlight()).willReturn((Object)0);
        BDDMockito.given((Object)this.pool3.getInFlight()).willReturn((Object)0);
        this.diceRoll = 1;
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node1, this.node3, this.node5, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node1, this.node3, this.node5, this.node4, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).diceRoll1d4();
    }

    @Test
    public void should_prioritize_and_shuffle_3_or_more_replicas_when_first_unhealthy() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node3, (Object)this.node5));
        BDDMockito.given((Object)this.pool1.getInFlight()).willReturn((Object)100);
        BDDMockito.given((Object)this.pool3.getInFlight()).willReturn((Object)0);
        BDDMockito.given((Object)this.pool5.getInFlight()).willReturn((Object)0);
        this.dsePolicy.responseTimes.put(this.node1, new AtomicLongArray(new long[]{Long.MIN_VALUE, Long.MIN_VALUE}));
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node3, this.node5, this.node1, this.node4, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.never())).diceRoll1d4();
    }

    @Test
    public void should_not_treat_node_as_unhealthy_if_has_in_flight_exceeded_but_response_times_normal() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node3, (Object)this.node5));
        BDDMockito.given((Object)this.pool1.getInFlight()).willReturn((Object)100);
        BDDMockito.given((Object)this.pool3.getInFlight()).willReturn((Object)0);
        BDDMockito.given((Object)this.pool5.getInFlight()).willReturn((Object)0);
        this.dsePolicy.responseTimes.put(this.node1, new AtomicLongArray(new long[]{100L, 100L}));
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node5, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node5, this.node4, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.never())).diceRoll1d4();
    }

    @Test
    public void should_prioritize_and_shuffle_3_or_more_replicas_when_last_unhealthy() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node3, (Object)this.node5));
        BDDMockito.given((Object)this.pool1.getInFlight()).willReturn((Object)0);
        BDDMockito.given((Object)this.pool3.getInFlight()).willReturn((Object)0);
        BDDMockito.given((Object)this.pool5.getInFlight()).willReturn((Object)100);
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node1, this.node3, this.node5, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node1, this.node3, this.node5, this.node4, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.never())).diceRoll1d4();
    }

    @Test
    public void should_prioritize_and_shuffle_3_or_more_replicas_when_majority_unhealthy() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node3, (Object)this.node5));
        BDDMockito.given((Object)this.pool1.getInFlight()).willReturn((Object)100);
        BDDMockito.given((Object)this.pool3.getInFlight()).willReturn((Object)100);
        BDDMockito.given((Object)this.pool5.getInFlight()).willReturn((Object)0);
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node1, this.node3, this.node5, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node1, this.node3, this.node5, this.node4, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.never())).diceRoll1d4();
    }

    @Test
    public void should_reorder_first_two_replicas_when_first_has_more_in_flight_than_second() {
        BDDMockito.given((Object)this.request.getRoutingKeyspace()).willReturn((Object)KEYSPACE);
        BDDMockito.given((Object)this.request.getRoutingKey()).willReturn((Object)ROUTING_KEY);
        BDDMockito.given((Object)this.tokenMap.getReplicas(KEYSPACE, ROUTING_KEY)).willReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node3, (Object)this.node5));
        BDDMockito.given((Object)this.pool1.getInFlight()).willReturn((Object)200);
        BDDMockito.given((Object)this.pool3.getInFlight()).willReturn((Object)100);
        Queue plan1 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Queue plan2 = this.dsePolicy.newQueryPlan(this.request, (Session)this.session);
        Assertions.assertThat((Iterable)plan1).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node5, this.node2, this.node4});
        Assertions.assertThat((Iterable)plan2).containsExactly((Object[])new Node[]{this.node3, this.node1, this.node5, this.node4, this.node2});
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).shuffleHead((Object[])ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.times((int)2))).nanoTime();
        ((DefaultLoadBalancingPolicy)BDDMockito.then((Object)this.dsePolicy).should(Mockito.never())).diceRoll1d4();
    }

    protected DefaultLoadBalancingPolicy createAndInitPolicy() {
        DefaultLoadBalancingPolicy policy = (DefaultLoadBalancingPolicy)Mockito.spy((Object)new DefaultLoadBalancingPolicy((DriverContext)this.context, "default"){

            protected void shuffleHead(Object[] array, int n) {
            }

            protected long nanoTime() {
                return DefaultLoadBalancingPolicyQueryPlanTest.this.nanoTime;
            }

            protected int diceRoll1d4() {
                return DefaultLoadBalancingPolicyQueryPlanTest.this.diceRoll;
            }
        });
        policy.init((Map)ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3, (Object)UUID.randomUUID(), (Object)this.node4, (Object)UUID.randomUUID(), (Object)this.node5), this.distanceReporter);
        return policy;
    }
}

