/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicyDistanceTest;
import com.datastax.oss.driver.internal.core.loadbalancing.DcInferringLoadBalancingPolicy;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.assertj.core.api.Assertions;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class DcInferringLoadBalancingPolicyDistanceTest
extends BasicLoadBalancingPolicyDistanceTest {
    @Override
    public void should_report_LOCAL_when_dc_agnostic() {
        Throwable error = Assertions.catchThrowable(() -> super.should_report_LOCAL_when_dc_agnostic());
        Assertions.assertThat((Throwable)error).isInstanceOfSatisfying(IllegalStateException.class, ise -> Assertions.assertThat((Throwable)ise).hasMessageContaining("No local DC was provided, but the contact points are from different DCs").hasMessageContaining("node1=null").hasMessageContaining("node2=dc1").hasMessageContaining("node3=dc2"));
    }

    @Override
    @NonNull
    protected BasicLoadBalancingPolicy createPolicy() {
        return new DcInferringLoadBalancingPolicy((DriverContext)this.context, "default");
    }
}

