/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.loadbalancing;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.loadbalancing.LoadBalancingPolicy;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistanceEvaluator;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.loadbalancing.BasicLoadBalancingPolicy;
import com.datastax.oss.driver.internal.core.loadbalancing.LoadBalancingPolicyTestBase;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.UUID;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Silent.class)
public class BasicLoadBalancingPolicyDistanceTest
extends LoadBalancingPolicyTestBase {
    @Mock
    private NodeDistanceEvaluator nodeDistanceEvaluator;
    private ImmutableMap<UUID, Node> nodes;

    @Override
    @Before
    public void setup() {
        super.setup();
        Mockito.when((Object)this.context.getNodeDistanceEvaluator("default")).thenReturn((Object)this.nodeDistanceEvaluator);
        Mockito.when((Object)this.metadataManager.getContactPoints()).thenReturn((Object)ImmutableSet.of((Object)this.node1, (Object)this.node2, (Object)this.node3));
        this.nodes = ImmutableMap.of((Object)UUID.randomUUID(), (Object)this.node1, (Object)UUID.randomUUID(), (Object)this.node2, (Object)UUID.randomUUID(), (Object)this.node3);
    }

    @Test
    public void should_report_distance_reported_by_user_distance_reporter() {
        BDDMockito.given((Object)this.node2.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.nodeDistanceEvaluator.evaluateDistance((Node)this.node1, "dc1")).willReturn((Object)NodeDistance.LOCAL);
        BDDMockito.given((Object)this.nodeDistanceEvaluator.evaluateDistance((Node)this.node2, "dc1")).willReturn((Object)NodeDistance.REMOTE);
        BDDMockito.given((Object)this.nodeDistanceEvaluator.evaluateDistance((Node)this.node3, "dc1")).willReturn((Object)NodeDistance.IGNORED);
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init(this.nodes, this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1});
    }

    @Test
    public void should_report_LOCAL_when_dc_agnostic() {
        BDDMockito.given((Object)this.defaultProfile.isDefined((DriverOption)DefaultDriverOption.LOAD_BALANCING_LOCAL_DATACENTER)).willReturn((Object)false);
        BDDMockito.given((Object)this.node1.getDatacenter()).willReturn(null);
        BDDMockito.given((Object)this.node2.getDatacenter()).willReturn((Object)"dc1");
        BDDMockito.given((Object)this.node3.getDatacenter()).willReturn((Object)"dc2");
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init(this.nodes, this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.LOCAL);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc(null)).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
    }

    @Test
    public void should_report_LOCAL_when_node_in_local_dc() {
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init(this.nodes, this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.LOCAL);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.LOCAL);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
    }

    @Test
    public void should_report_IGNORED_when_node_not_in_local_dc() {
        BDDMockito.given((Object)this.node1.getDatacenter()).willReturn(null);
        BDDMockito.given((Object)this.node2.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node3.getDatacenter()).willReturn((Object)"dc3");
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init(this.nodes, this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.IGNORED);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.IGNORED);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc(null)).isEmpty();
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).isEmpty();
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc2")).isEmpty();
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc3")).isEmpty();
    }

    @Test
    public void should_report_REMOTE_when_node_not_in_local_dc_and_dc_failover_enabled() {
        BDDMockito.given((Object)this.node1.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node2.getDatacenter()).willReturn((Object)"dc3");
        BDDMockito.given((Object)this.node3.getDatacenter()).willReturn((Object)"dc4");
        BDDMockito.given((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC)).willReturn((Object)1);
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init(this.nodes, this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.REMOTE);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).isEmpty();
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc2")).containsExactly((Object[])new Node[]{this.node1});
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc3")).containsExactly((Object[])new Node[]{this.node2});
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc4")).containsExactly((Object[])new Node[]{this.node3});
    }

    @Test
    public void should_report_IGNORED_when_node_not_in_local_dc_and_too_many_nodes_for_dc_failover() {
        BDDMockito.given((Object)this.node1.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node2.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node3.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC)).willReturn((Object)2);
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init(this.nodes, this.distanceReporter);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).isEmpty();
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc2")).containsExactly((Object[])new Node[]{this.node1, this.node2});
    }

    @Test
    public void should_report_REMOTE_when_remote_node_up_and_dc_failover() {
        BDDMockito.given((Object)this.node1.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node2.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node3.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node4.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC)).willReturn((Object)4);
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init(this.nodes, this.distanceReporter);
        policy.onUp((Node)this.node4);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node4, NodeDistance.REMOTE);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).isEmpty();
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc2")).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3, this.node4});
    }

    @Test
    public void should_report_IGNORED_when_remote_node_up_and_too_many_nodes_for_dc_failover() {
        BDDMockito.given((Object)this.node1.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node2.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node3.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.node4.getDatacenter()).willReturn((Object)"dc2");
        BDDMockito.given((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.LOAD_BALANCING_DC_FAILOVER_MAX_NODES_PER_REMOTE_DC)).willReturn((Object)3);
        BasicLoadBalancingPolicy policy = this.createPolicy();
        policy.init(this.nodes, this.distanceReporter);
        policy.onUp((Node)this.node4);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node1, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node2, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node3, NodeDistance.REMOTE);
        ((LoadBalancingPolicy.DistanceReporter)Mockito.verify((Object)this.distanceReporter)).setDistance((Node)this.node4, NodeDistance.IGNORED);
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc1")).isEmpty();
        Assertions.assertThat((Iterable)policy.getLiveNodes().dc("dc2")).containsExactly((Object[])new Node[]{this.node1, this.node2, this.node3});
    }

    @NonNull
    protected BasicLoadBalancingPolicy createPolicy() {
        return new BasicLoadBalancingPolicy((DriverContext)this.context, "default");
    }
}

