/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.core.util.CountingIterator;
import com.datastax.oss.driver.shaded.guava.common.collect.Lists;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.assertj.core.api.Assertions;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;

public abstract class ResultSetTestBase {
    protected AsyncResultSet mockPage(boolean nextPage, Integer ... data) {
        AsyncResultSet page = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        ColumnDefinitions columnDefinitions = (ColumnDefinitions)Mockito.mock(ColumnDefinitions.class);
        Mockito.when((Object)page.getColumnDefinitions()).thenReturn((Object)columnDefinitions);
        ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
        Mockito.when((Object)page.getExecutionInfo()).thenReturn((Object)executionInfo);
        if (nextPage) {
            Mockito.when((Object)page.hasMorePages()).thenReturn((Object)true);
            Mockito.when((Object)page.fetchNextPage()).thenReturn((Object)((CompletionStage)Mockito.spy(new CompletableFuture())));
        } else {
            Mockito.when((Object)page.hasMorePages()).thenReturn((Object)false);
            Mockito.when((Object)page.fetchNextPage()).thenThrow(new Throwable[]{new IllegalStateException()});
        }
        final LinkedList queue = Lists.newLinkedList(Arrays.asList(data));
        CountingIterator<Row> iterator = new CountingIterator<Row>(queue.size()){

            protected Row computeNext() {
                Integer index = (Integer)queue.poll();
                return index == null ? (Row)this.endOfData() : ResultSetTestBase.this.mockRow(index);
            }
        };
        Mockito.when((Object)page.currentPage()).thenReturn(() -> ResultSetTestBase.lambda$mockPage$0((CountingIterator)iterator));
        Mockito.when((Object)page.remaining()).thenAnswer(arg_0 -> ResultSetTestBase.lambda$mockPage$1((CountingIterator)iterator, arg_0));
        return page;
    }

    private Row mockRow(int index) {
        Row row = (Row)Mockito.mock(Row.class);
        Mockito.when((Object)row.getInt(0)).thenReturn((Object)index);
        return row;
    }

    protected static void complete(CompletionStage<AsyncResultSet> stage, AsyncResultSet result) {
        stage.toCompletableFuture().complete(result);
    }

    protected void assertNextRow(Iterator<Row> iterator, int expectedValue) {
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Row row = iterator.next();
        Assertions.assertThat((int)row.getInt(0)).isEqualTo(expectedValue);
    }

    private static /* synthetic */ Object lambda$mockPage$1(CountingIterator iterator, InvocationOnMock invocation) throws Throwable {
        return iterator.remaining();
    }

    private static /* synthetic */ Iterator lambda$mockPage$0(CountingIterator iterator) {
        return iterator;
    }
}

