/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.cql.SimpleStatement;
import com.datastax.oss.driver.api.core.cql.Statement;
import com.datastax.oss.driver.api.core.cql.TraceEvent;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.cql.QueryTraceFetcher;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.util.Bytes;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class QueryTraceFetcherTest {
    private static final UUID TRACING_ID = UUID.randomUUID();
    private static final ByteBuffer PAGING_STATE = Bytes.fromHexString((String)"0xdeadbeef");
    private static final int PORT = 7000;
    @Mock
    private CqlSession session;
    @Mock
    private InternalDriverContext context;
    @Mock
    private DriverExecutionProfile config;
    @Mock
    private DriverExecutionProfile traceConfig;
    @Mock
    private NettyOptions nettyOptions;
    @Mock
    private EventExecutorGroup adminEventExecutorGroup;
    @Mock
    private EventExecutor eventExecutor;
    @Mock
    private InetAddress address;
    @Captor
    private ArgumentCaptor<SimpleStatement> statementCaptor;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)this.adminEventExecutorGroup);
        Mockito.when((Object)this.adminEventExecutorGroup.next()).thenReturn((Object)this.eventExecutor);
        Mockito.when((Object)this.eventExecutor.schedule((Runnable)ArgumentMatchers.any(Runnable.class), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.any(TimeUnit.class)))).thenAnswer(invocation -> {
            Runnable runnable = (Runnable)invocation.getArgument(0);
            runnable.run();
            return null;
        });
        Mockito.when((Object)this.config.getInt((DriverOption)DefaultDriverOption.REQUEST_TRACE_ATTEMPTS)).thenReturn((Object)3);
        Mockito.when((Object)this.config.getDuration((DriverOption)DefaultDriverOption.REQUEST_TRACE_INTERVAL)).thenReturn((Object)Duration.ZERO);
        Mockito.when((Object)this.config.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).thenReturn((Object)DefaultConsistencyLevel.LOCAL_ONE.name());
        Mockito.when((Object)this.config.getString((DriverOption)DefaultDriverOption.REQUEST_TRACE_CONSISTENCY)).thenReturn((Object)DefaultConsistencyLevel.ONE.name());
        Mockito.when((Object)this.config.withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, DefaultConsistencyLevel.ONE.name())).thenReturn((Object)this.traceConfig);
    }

    @Test
    public void should_succeed_when_both_queries_succeed_immediately() {
        CompletionStage<AsyncResultSet> sessionRow = this.completeSessionRow();
        CompletionStage<AsyncResultSet> eventRows = this.singlePageEventRows();
        Mockito.when((Object)this.session.executeAsync((Statement)ArgumentMatchers.any(SimpleStatement.class))).thenAnswer(invocation -> sessionRow).thenAnswer(invocation -> eventRows);
        QueryTraceFetcher fetcher = new QueryTraceFetcher(TRACING_ID, this.session, this.context, this.config);
        CompletionStage traceFuture = fetcher.fetch();
        ((CqlSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)2))).executeAsync((Statement)this.statementCaptor.capture());
        List statements = this.statementCaptor.getAllValues();
        this.assertSessionQuery((SimpleStatement)statements.get(0));
        SimpleStatement statement = (SimpleStatement)statements.get(1);
        this.assertEventsQuery(statement);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
        Assertions.assertThatStage(traceFuture).isSuccess(trace -> {
            Assertions.assertThat((Comparable)trace.getTracingId()).isEqualTo((Object)TRACING_ID);
            Assertions.assertThat((String)trace.getRequestType()).isEqualTo("mock request");
            Assertions.assertThat((int)trace.getDurationMicros()).isEqualTo(42);
            Assertions.assertThat((Object)trace.getCoordinatorAddress().getAddress()).isEqualTo((Object)this.address);
            Assertions.assertThat((int)trace.getCoordinatorAddress().getPort()).isEqualTo(7000);
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)trace.getParameters()).hasSize(2)).containsEntry((Object)"key1", (Object)"value1")).containsEntry((Object)"key2", (Object)"value2");
            Assertions.assertThat((long)trace.getStartedAt()).isEqualTo(0L);
            List events = trace.getEvents();
            Assertions.assertThat((List)events).hasSize(3);
            for (int i = 0; i < events.size(); ++i) {
                TraceEvent event = (TraceEvent)events.get(i);
                Assertions.assertThat((String)event.getActivity()).isEqualTo("mock activity " + i);
                Assertions.assertThat((long)event.getTimestamp()).isEqualTo((long)i);
                Assertions.assertThat((Object)event.getSourceAddress()).isNotNull();
                Assertions.assertThat((Object)event.getSourceAddress().getAddress()).isEqualTo((Object)this.address);
                Assertions.assertThat((int)event.getSourceAddress().getPort()).isEqualTo(7000);
                Assertions.assertThat((int)event.getSourceElapsedMicros()).isEqualTo(i);
                Assertions.assertThat((String)event.getThreadName()).isEqualTo("mock thread " + i);
            }
        });
    }

    @Test
    public void should_succeed_when_events_query_is_paged() {
        CompletionStage<AsyncResultSet> sessionRow = this.completeSessionRow();
        CompletionStage<AsyncResultSet> eventRows1 = this.multiPageEventRows1();
        CompletionStage<AsyncResultSet> eventRows2 = this.multiPageEventRows2();
        Mockito.when((Object)this.session.executeAsync((Statement)ArgumentMatchers.any(SimpleStatement.class))).thenAnswer(invocation -> sessionRow).thenAnswer(invocation -> eventRows1).thenAnswer(invocation -> eventRows2);
        QueryTraceFetcher fetcher = new QueryTraceFetcher(TRACING_ID, this.session, this.context, this.config);
        CompletionStage traceFuture = fetcher.fetch();
        ((CqlSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)3))).executeAsync((Statement)this.statementCaptor.capture());
        List statements = this.statementCaptor.getAllValues();
        this.assertSessionQuery((SimpleStatement)statements.get(0));
        this.assertEventsQuery((SimpleStatement)statements.get(1));
        this.assertEventsQuery((SimpleStatement)statements.get(2));
        Assertions.assertThat((Comparable)((SimpleStatement)statements.get(2)).getPagingState()).isEqualTo((Object)PAGING_STATE);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
        Assertions.assertThatStage(traceFuture).isSuccess(trace -> {
            ListAssert cfr_ignored_0 = (ListAssert)Assertions.assertThat((List)trace.getEvents()).hasSize(2);
        });
    }

    @Test
    public void should_retry_when_session_row_is_incomplete() {
        CompletionStage<AsyncResultSet> sessionRow1 = this.incompleteSessionRow();
        CompletionStage<AsyncResultSet> sessionRow2 = this.completeSessionRow();
        CompletionStage<AsyncResultSet> eventRows = this.singlePageEventRows();
        Mockito.when((Object)this.session.executeAsync((Statement)ArgumentMatchers.any(SimpleStatement.class))).thenAnswer(invocation -> sessionRow1).thenAnswer(invocation -> sessionRow2).thenAnswer(invocation -> eventRows);
        QueryTraceFetcher fetcher = new QueryTraceFetcher(TRACING_ID, this.session, this.context, this.config);
        CompletionStage traceFuture = fetcher.fetch();
        ((CqlSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)3))).executeAsync((Statement)this.statementCaptor.capture());
        List statements = this.statementCaptor.getAllValues();
        this.assertSessionQuery((SimpleStatement)statements.get(0));
        this.assertSessionQuery((SimpleStatement)statements.get(1));
        this.assertEventsQuery((SimpleStatement)statements.get(2));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
        Assertions.assertThatStage(traceFuture).isSuccess(trace -> {
            Assertions.assertThat((Comparable)trace.getTracingId()).isEqualTo((Object)TRACING_ID);
            Assertions.assertThat((String)trace.getRequestType()).isEqualTo("mock request");
            Assertions.assertThat((int)trace.getDurationMicros()).isEqualTo(42);
            Assertions.assertThat((Object)trace.getCoordinatorAddress().getAddress()).isEqualTo((Object)this.address);
            Assertions.assertThat((int)trace.getCoordinatorAddress().getPort()).isEqualTo(7000);
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)trace.getParameters()).hasSize(2)).containsEntry((Object)"key1", (Object)"value1")).containsEntry((Object)"key2", (Object)"value2");
            Assertions.assertThat((long)trace.getStartedAt()).isEqualTo(0L);
            List events = trace.getEvents();
            Assertions.assertThat((List)events).hasSize(3);
            for (int i = 0; i < events.size(); ++i) {
                TraceEvent event = (TraceEvent)events.get(i);
                Assertions.assertThat((String)event.getActivity()).isEqualTo("mock activity " + i);
                Assertions.assertThat((long)event.getTimestamp()).isEqualTo((long)i);
                Assertions.assertThat((Object)event.getSourceAddress()).isNotNull();
                Assertions.assertThat((Object)event.getSourceAddress().getAddress()).isEqualTo((Object)this.address);
                Assertions.assertThat((int)event.getSourceAddress().getPort()).isEqualTo(7000);
                Assertions.assertThat((int)event.getSourceElapsedMicros()).isEqualTo(i);
                Assertions.assertThat((String)event.getThreadName()).isEqualTo("mock thread " + i);
            }
        });
    }

    @Test
    public void should_fail_when_session_query_fails() {
        RuntimeException mockError = new RuntimeException("mock error");
        Mockito.when((Object)this.session.executeAsync((Statement)ArgumentMatchers.any(SimpleStatement.class))).thenReturn((Object)CompletableFutures.failedFuture((Throwable)mockError));
        QueryTraceFetcher fetcher = new QueryTraceFetcher(TRACING_ID, this.session, this.context, this.config);
        CompletionStage traceFuture = fetcher.fetch();
        ((CqlSession)Mockito.verify((Object)this.session)).executeAsync((Statement)this.statementCaptor.capture());
        SimpleStatement statement = (SimpleStatement)this.statementCaptor.getValue();
        this.assertSessionQuery(statement);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.session});
        Assertions.assertThatStage(traceFuture).isFailed(error -> {
            AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isSameAs((Object)mockError);
        });
    }

    @Test
    public void should_fail_when_session_query_still_incomplete_after_max_tries() {
        CompletionStage<AsyncResultSet> sessionRow1 = this.incompleteSessionRow();
        CompletionStage<AsyncResultSet> sessionRow2 = this.incompleteSessionRow();
        CompletionStage<AsyncResultSet> sessionRow3 = this.incompleteSessionRow();
        Mockito.when((Object)this.session.executeAsync((Statement)ArgumentMatchers.any(SimpleStatement.class))).thenAnswer(invocation -> sessionRow1).thenAnswer(invocation -> sessionRow2).thenAnswer(invocation -> sessionRow3);
        QueryTraceFetcher fetcher = new QueryTraceFetcher(TRACING_ID, this.session, this.context, this.config);
        CompletionStage traceFuture = fetcher.fetch();
        ((CqlSession)Mockito.verify((Object)this.session, (VerificationMode)Mockito.times((int)3))).executeAsync((Statement)this.statementCaptor.capture());
        List statements = this.statementCaptor.getAllValues();
        for (int i = 0; i < 3; ++i) {
            this.assertSessionQuery((SimpleStatement)statements.get(i));
        }
        Assertions.assertThatStage(traceFuture).isFailed(error -> Assertions.assertThat((String)error.getMessage()).isEqualTo(String.format("Trace %s still not complete after 3 attempts", TRACING_ID)));
    }

    private CompletionStage<AsyncResultSet> completeSessionRow() {
        return this.sessionRow(42);
    }

    private CompletionStage<AsyncResultSet> incompleteSessionRow() {
        return this.sessionRow(null);
    }

    private CompletionStage<AsyncResultSet> sessionRow(Integer duration) {
        Row row = (Row)Mockito.mock(Row.class);
        ColumnDefinitions definitions = (ColumnDefinitions)Mockito.mock(ColumnDefinitions.class);
        Mockito.when((Object)row.getColumnDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)row.getString("request")).thenReturn((Object)"mock request");
        if (duration == null) {
            Mockito.when((Object)row.isNull("duration")).thenReturn((Object)true);
        } else {
            Mockito.when((Object)row.getInt("duration")).thenReturn((Object)duration);
        }
        Mockito.when((Object)row.getInetAddress("coordinator")).thenReturn((Object)this.address);
        Mockito.when((Object)definitions.contains("coordinator_port")).thenReturn((Object)true);
        Mockito.when((Object)row.getInt("coordinator_port")).thenReturn((Object)7000);
        Mockito.when((Object)row.getMap("parameters", String.class, String.class)).thenReturn((Object)ImmutableMap.of((Object)"key1", (Object)"value1", (Object)"key2", (Object)"value2"));
        Mockito.when((Object)row.isNull("started_at")).thenReturn((Object)false);
        Mockito.when((Object)row.getInstant("started_at")).thenReturn((Object)Instant.EPOCH);
        AsyncResultSet rs = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        Mockito.when((Object)((Row)rs.one())).thenReturn((Object)row);
        return CompletableFuture.completedFuture(rs);
    }

    private CompletionStage<AsyncResultSet> singlePageEventRows() {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (int i = 0; i < 3; ++i) {
            rows.add(this.eventRow(i));
        }
        AsyncResultSet rs = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        Mockito.when((Object)rs.currentPage()).thenReturn(rows);
        ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
        Mockito.when((Object)executionInfo.getPagingState()).thenReturn(null);
        Mockito.when((Object)rs.getExecutionInfo()).thenReturn((Object)executionInfo);
        return CompletableFuture.completedFuture(rs);
    }

    private CompletionStage<AsyncResultSet> multiPageEventRows1() {
        AsyncResultSet rs = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        ImmutableList rows = ImmutableList.of((Object)this.eventRow(0));
        Mockito.when((Object)rs.currentPage()).thenReturn((Object)rows);
        ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
        Mockito.when((Object)executionInfo.getPagingState()).thenReturn((Object)PAGING_STATE);
        Mockito.when((Object)rs.getExecutionInfo()).thenReturn((Object)executionInfo);
        return CompletableFuture.completedFuture(rs);
    }

    private CompletionStage<AsyncResultSet> multiPageEventRows2() {
        AsyncResultSet rs = (AsyncResultSet)Mockito.mock(AsyncResultSet.class);
        ImmutableList rows = ImmutableList.of((Object)this.eventRow(1));
        Mockito.when((Object)rs.currentPage()).thenReturn((Object)rows);
        ExecutionInfo executionInfo = (ExecutionInfo)Mockito.mock(ExecutionInfo.class);
        Mockito.when((Object)executionInfo.getPagingState()).thenReturn(null);
        Mockito.when((Object)rs.getExecutionInfo()).thenReturn((Object)executionInfo);
        return CompletableFuture.completedFuture(rs);
    }

    private Row eventRow(int i) {
        Row row = (Row)Mockito.mock(Row.class);
        ColumnDefinitions definitions = (ColumnDefinitions)Mockito.mock(ColumnDefinitions.class);
        Mockito.when((Object)row.getColumnDefinitions()).thenReturn((Object)definitions);
        Mockito.when((Object)row.getString("activity")).thenReturn((Object)("mock activity " + i));
        Mockito.when((Object)row.getUuid("event_id")).thenReturn((Object)Uuids.startOf((long)i));
        Mockito.when((Object)row.getInetAddress("source")).thenReturn((Object)this.address);
        Mockito.when((Object)definitions.contains("source_port")).thenReturn((Object)true);
        Mockito.when((Object)row.getInt("source_port")).thenReturn((Object)7000);
        Mockito.when((Object)row.getInt("source_elapsed")).thenReturn((Object)i);
        Mockito.when((Object)row.getString("thread")).thenReturn((Object)("mock thread " + i));
        return row;
    }

    private void assertSessionQuery(SimpleStatement statement) {
        Assertions.assertThat((String)statement.getQuery()).isEqualTo("SELECT * FROM system_traces.sessions WHERE session_id = ?");
        Assertions.assertThat((List)statement.getPositionalValues()).containsOnly(new Object[]{TRACING_ID});
        Assertions.assertThat((Object)statement.getExecutionProfile()).isEqualTo((Object)this.traceConfig);
    }

    private void assertEventsQuery(SimpleStatement statement) {
        Assertions.assertThat((String)statement.getQuery()).isEqualTo("SELECT * FROM system_traces.events WHERE session_id = ?");
        Assertions.assertThat((List)statement.getPositionalValues()).containsOnly(new Object[]{TRACING_ID});
        Assertions.assertThat((Object)statement.getExecutionProfile()).isEqualTo((Object)this.traceConfig);
    }
}

