/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.control;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.connection.ReconnectionPolicy;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.channel.ChannelFactory;
import com.datastax.oss.driver.internal.core.channel.DriverChannel;
import com.datastax.oss.driver.internal.core.channel.DriverChannelOptions;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.control.ControlConnection;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metadata.LoadBalancingPolicyWrapper;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.datastax.oss.driver.internal.core.metadata.TestNodeFactory;
import com.datastax.oss.driver.internal.core.metrics.MetricsFactory;
import io.netty.channel.Channel;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import java.net.InetSocketAddress;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Exchanger;
import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationWithTimeout;

abstract class ControlConnectionTestBase {
    protected static final InetSocketAddress ADDRESS1 = new InetSocketAddress("127.0.0.1", 9042);
    protected static final VerificationWithTimeout VERIFY_TIMEOUT = Mockito.timeout((long)500L);
    @Mock
    protected InternalDriverContext context;
    @Mock
    protected DriverConfig config;
    @Mock
    protected DriverExecutionProfile defaultProfile;
    @Mock
    protected ReconnectionPolicy reconnectionPolicy;
    @Mock
    protected ReconnectionPolicy.ReconnectionSchedule reconnectionSchedule;
    @Mock
    protected NettyOptions nettyOptions;
    protected DefaultEventLoopGroup adminEventLoopGroup;
    protected EventBus eventBus;
    @Mock
    protected ChannelFactory channelFactory;
    protected Exchanger<CompletableFuture<DriverChannel>> channelFactoryFuture;
    @Mock
    protected LoadBalancingPolicyWrapper loadBalancingPolicyWrapper;
    @Mock
    protected MetadataManager metadataManager;
    @Mock
    protected MetricsFactory metricsFactory;
    protected DefaultNode node1;
    protected DefaultNode node2;
    protected ControlConnection controlConnection;

    ControlConnectionTestBase() {
    }

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.adminEventLoopGroup = new DefaultEventLoopGroup(1);
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)this.adminEventLoopGroup);
        this.eventBus = (EventBus)Mockito.spy((Object)new EventBus("test"));
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)this.eventBus);
        Mockito.when((Object)this.context.getChannelFactory()).thenReturn((Object)this.channelFactory);
        this.channelFactoryFuture = new Exchanger();
        Mockito.when((Object)this.channelFactory.connect((Node)ArgumentMatchers.any(Node.class), (DriverChannelOptions)ArgumentMatchers.any(DriverChannelOptions.class))).thenAnswer(invocation -> {
            CompletableFuture channelFuture = new CompletableFuture();
            this.channelFactoryFuture.exchange(channelFuture, 100L, TimeUnit.MILLISECONDS);
            return channelFuture;
        });
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.RECONNECT_ON_INIT)).thenReturn((Object)false);
        Mockito.when((Object)this.context.getReconnectionPolicy()).thenReturn((Object)this.reconnectionPolicy);
        Mockito.when((Object)this.reconnectionPolicy.newControlConnectionSchedule(false)).thenReturn((Object)this.reconnectionSchedule);
        Mockito.when((Object)this.reconnectionSchedule.nextDelay()).thenReturn((Object)Duration.ofDays(1L));
        Mockito.when((Object)this.context.getLoadBalancingPolicyWrapper()).thenReturn((Object)this.loadBalancingPolicyWrapper);
        Mockito.when((Object)this.context.getMetricsFactory()).thenReturn((Object)this.metricsFactory);
        this.node1 = TestNodeFactory.newNode(1, this.context);
        this.node2 = TestNodeFactory.newNode(2, this.context);
        this.mockQueryPlan(new Node[]{this.node1, this.node2});
        Mockito.when((Object)this.metadataManager.refreshNodes()).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.metadataManager.refreshSchema(ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn(CompletableFuture.completedFuture(null));
        Mockito.when((Object)this.context.getMetadataManager()).thenReturn((Object)this.metadataManager);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.getBoolean((DriverOption)DefaultDriverOption.CONNECTION_WARN_INIT_ERROR)).thenReturn((Object)false);
        this.controlConnection = new ControlConnection(this.context);
    }

    protected void mockQueryPlan(Node ... nodes) {
        Mockito.when((Object)this.loadBalancingPolicyWrapper.newQueryPlan()).thenAnswer(i -> {
            ConcurrentLinkedQueue<Node> queryPlan = new ConcurrentLinkedQueue<Node>();
            for (Node node : nodes) {
                queryPlan.offer(node);
            }
            return queryPlan;
        });
    }

    @After
    public void teardown() {
        this.adminEventLoopGroup.shutdownGracefully(100L, 200L, TimeUnit.MILLISECONDS);
    }

    protected DriverChannel newMockDriverChannel(int id) {
        DriverChannel driverChannel = (DriverChannel)Mockito.mock(DriverChannel.class);
        Channel channel = (Channel)Mockito.mock(Channel.class);
        EventLoop adminExecutor = this.adminEventLoopGroup.next();
        DefaultChannelPromise closeFuture = new DefaultChannelPromise(channel, (EventExecutor)adminExecutor);
        Mockito.when((Object)driverChannel.close()).thenAnswer(i -> {
            closeFuture.trySuccess(null);
            return closeFuture;
        });
        Mockito.when((Object)driverChannel.forceClose()).thenAnswer(i -> {
            closeFuture.trySuccess(null);
            return closeFuture;
        });
        Mockito.when((Object)driverChannel.closeFuture()).thenReturn((Object)closeFuture);
        Mockito.when((Object)driverChannel.toString()).thenReturn((Object)("channel" + id));
        Mockito.when((Object)driverChannel.getEndPoint()).thenReturn((Object)new DefaultEndPoint(new InetSocketAddress("127.0.0." + id, 9042)));
        return driverChannel;
    }
}

