/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context.bus;

import com.datastax.oss.driver.internal.core.context.EventBus;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Before;
import org.junit.Test;

public class EventBusTest {
    private EventBus bus;
    private Map<String, ParentEvent> results;
    private ChildEvent event = new ChildEvent();

    @Before
    public void setup() {
        this.bus = new EventBus("test");
        this.results = new HashMap<String, ParentEvent>();
    }

    @Test
    public void should_notify_registered_listeners() {
        this.bus.register(ChildEvent.class, e -> this.results.put("listener1", (ParentEvent)e));
        this.bus.register(ChildEvent.class, e -> this.results.put("listener2", (ParentEvent)e));
        this.bus.fire((Object)this.event);
        ((MapAssert)((MapAssert)Assertions.assertThat(this.results).hasSize(2)).containsEntry((Object)"listener1", (Object)this.event)).containsEntry((Object)"listener2", (Object)this.event);
    }

    @Test
    public void should_unregister_listener() {
        Object key1 = this.bus.register(ChildEvent.class, e -> this.results.put("listener1", (ParentEvent)e));
        this.bus.register(ChildEvent.class, e -> this.results.put("listener2", (ParentEvent)e));
        this.bus.unregister(key1, ChildEvent.class);
        this.bus.fire((Object)this.event);
        ((MapAssert)Assertions.assertThat(this.results).hasSize(1)).containsEntry((Object)"listener2", (Object)this.event);
    }

    @Test
    public void should_use_exact_class() {
        this.bus.register(ChildEvent.class, e -> this.results.put("listener1", (ParentEvent)e));
        this.bus.register(ParentEvent.class, e -> this.results.put("listener2", (ParentEvent)e));
        this.bus.fire((Object)this.event);
        ((MapAssert)Assertions.assertThat(this.results).hasSize(1)).containsEntry((Object)"listener1", (Object)this.event);
        this.results.clear();
        ParentEvent parentEvent = new ParentEvent();
        this.bus.fire((Object)parentEvent);
        ((MapAssert)Assertions.assertThat(this.results).hasSize(1)).containsEntry((Object)"listener2", (Object)parentEvent);
    }

    private static class ChildEvent
    extends ParentEvent {
        private ChildEvent() {
        }
    }

    private static class ParentEvent {
        private ParentEvent() {
        }
    }
}

