/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.context;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.MockedDriverContextFactory;
import com.datastax.oss.driver.internal.core.protocol.Lz4Compressor;
import com.datastax.oss.driver.internal.core.protocol.SnappyCompressor;
import com.datastax.oss.protocol.internal.Compressor;
import com.datastax.oss.protocol.internal.NoopCompressor;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class DefaultDriverContextTest {
    private DefaultDriverContext buildMockedContext(Optional<String> compressionOption) {
        DriverExecutionProfile defaultProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)defaultProfile.getString((DriverOption)DefaultDriverOption.PROTOCOL_COMPRESSION, "none")).thenReturn((Object)compressionOption.orElse("none"));
        return MockedDriverContextFactory.defaultDriverContext(Optional.of(defaultProfile));
    }

    private void doCreateCompressorTest(Optional<String> configVal, Class<?> expectedClz) {
        DefaultDriverContext ctx = this.buildMockedContext(configVal);
        Compressor compressor = ctx.getCompressor();
        Assertions.assertThat((Object)compressor).isNotNull();
        Assertions.assertThat((Object)compressor).isInstanceOf(expectedClz);
    }

    @Test
    @DataProvider(value={"lz4", "lZ4", "Lz4", "LZ4"})
    public void should_create_lz4_compressor(String name) {
        this.doCreateCompressorTest(Optional.of(name), Lz4Compressor.class);
    }

    @Test
    @DataProvider(value={"snappy", "SNAPPY", "sNaPpY", "SNapPy"})
    public void should_create_snappy_compressor(String name) {
        this.doCreateCompressorTest(Optional.of(name), SnappyCompressor.class);
    }

    @Test
    public void should_create_noop_compressor_if_undefined() {
        this.doCreateCompressorTest(Optional.empty(), NoopCompressor.class);
    }

    @Test
    @DataProvider(value={"none", "NONE", "NoNe", "nONe"})
    public void should_create_noop_compressor_if_defined_as_none(String name) {
        this.doCreateCompressorTest(Optional.of(name), NoopCompressor.class);
    }
}

