/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.internal.core.config.typesafe.TypesafeDriverConfig;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigMergeable;
import java.time.Duration;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TypeSafeDriverConfigOverrideDefaultsTest {
    @Test
    public void should_replace_if_value_comes_from_reference() {
        TypesafeDriverConfig config = this.config("");
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_ONE");
        config.overrideDefaults((Map)ImmutableMap.of((Object)DefaultDriverOption.REQUEST_CONSISTENCY, (Object)"LOCAL_QUORUM"));
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_QUORUM");
    }

    @Test
    public void should_replace_multiple_times() {
        TypesafeDriverConfig config = this.config("");
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_ONE");
        config.overrideDefaults((Map)ImmutableMap.of((Object)DefaultDriverOption.REQUEST_CONSISTENCY, (Object)"LOCAL_QUORUM"));
        config.overrideDefaults((Map)ImmutableMap.of((Object)DefaultDriverOption.REQUEST_CONSISTENCY, (Object)"TWO"));
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("TWO");
    }

    @Test
    public void should_not_replace_if_overridden_from_application() {
        TypesafeDriverConfig config = this.config("datastax-java-driver.basic.request.consistency = LOCAL_ONE");
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_ONE");
        config.overrideDefaults((Map)ImmutableMap.of((Object)DefaultDriverOption.REQUEST_CONSISTENCY, (Object)"LOCAL_QUORUM"));
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_ONE");
    }

    @Test
    public void should_handle_reloads() {
        TypesafeDriverConfig config = this.config("");
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_ONE");
        config.overrideDefaults((Map)ImmutableMap.of((Object)DefaultDriverOption.REQUEST_CONSISTENCY, (Object)"LOCAL_QUORUM"));
        this.reload(config, "");
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_QUORUM");
        this.reload(config, "datastax-java-driver.basic.request.consistency = ONE");
        Assertions.assertThat((String)config.getDefaultProfile().getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("ONE");
    }

    @Test
    public void should_ignore_non_existent_option() {
        TypesafeDriverConfig config = this.config("");
        DriverOption nonExistent = () -> "non existent";
        config.overrideDefaults((Map)ImmutableMap.of((Object)nonExistent, (Object)"IRRELEVANT"));
        Assertions.assertThat((boolean)config.getDefaultProfile().isDefined(nonExistent)).isFalse();
    }

    @Test
    public void should_handle_profiles() {
        TypesafeDriverConfig config = this.config("datastax-java-driver.profiles.profile1.basic.request.consistency = TWO\ndatastax-java-driver.profiles.profile2.basic.request.timeout = 5 seconds");
        DriverExecutionProfile profile1 = config.getProfile("profile1");
        DriverExecutionProfile profile2 = config.getProfile("profile2");
        DriverExecutionProfile derivedProfile21 = profile2.withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(10L));
        DriverExecutionProfile derivedProfile22 = profile2.withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, "QUORUM");
        Assertions.assertThat((String)profile1.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("TWO");
        Assertions.assertThat((String)profile2.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_ONE");
        Assertions.assertThat((String)derivedProfile21.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_ONE");
        Assertions.assertThat((String)derivedProfile22.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("QUORUM");
        config.overrideDefaults((Map)ImmutableMap.of((Object)DefaultDriverOption.REQUEST_CONSISTENCY, (Object)"LOCAL_QUORUM"));
        Assertions.assertThat((String)profile1.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("TWO");
        Assertions.assertThat((String)profile2.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_QUORUM");
        Assertions.assertThat((String)derivedProfile21.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_QUORUM");
        Assertions.assertThat((String)derivedProfile22.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("QUORUM");
    }

    private TypesafeDriverConfig config(String application) {
        return new TypesafeDriverConfig(this.rawConfig(application));
    }

    private boolean reload(TypesafeDriverConfig config, String newApplication) {
        return config.reload(this.rawConfig(newApplication));
    }

    private Config rawConfig(String application) {
        ConfigFactory.invalidateCaches();
        return ConfigFactory.parseString((String)application).withFallback((ConfigMergeable)ConfigFactory.defaultReference()).resolve().getConfig("datastax-java-driver");
    }
}

