/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.typesafe;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.internal.core.config.ConfigChangeEvent;
import com.datastax.oss.driver.internal.core.config.MockOptions;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.datastax.oss.driver.internal.core.context.EventBus;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.context.NettyOptions;
import com.datastax.oss.driver.internal.core.util.concurrent.ScheduledTaskCapturingEventLoop;
import com.typesafe.config.ConfigFactory;
import io.netty.channel.EventLoopGroup;
import java.io.File;
import java.time.Duration;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class DefaultDriverConfigLoaderTest {
    @Mock
    private InternalDriverContext context;
    @Mock
    private NettyOptions nettyOptions;
    @Mock
    private EventLoopGroup adminEventExecutorGroup;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;
    private ScheduledTaskCapturingEventLoop adminExecutor;
    private EventBus eventBus;
    private AtomicReference<String> configSource;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.context.getSessionName()).thenReturn((Object)"test");
        Mockito.when((Object)this.context.getNettyOptions()).thenReturn((Object)this.nettyOptions);
        Mockito.when((Object)this.nettyOptions.adminEventExecutorGroup()).thenReturn((Object)this.adminEventExecutorGroup);
        this.adminExecutor = new ScheduledTaskCapturingEventLoop(this.adminEventExecutorGroup);
        Mockito.when((Object)this.adminEventExecutorGroup.next()).thenReturn((Object)this.adminExecutor);
        this.eventBus = (EventBus)Mockito.spy((Object)new EventBus("test"));
        Mockito.when((Object)this.context.getEventBus()).thenReturn((Object)this.eventBus);
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getDefaultProfile()).thenReturn((Object)this.defaultProfile);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.CONFIG_RELOAD_INTERVAL)).thenReturn((Object)Duration.ofSeconds(12L));
        this.configSource = new AtomicReference<String>("int1 = 42");
    }

    @Test
    public void should_build_initial_config() {
        DefaultDriverConfigLoader loader = new DefaultDriverConfigLoader(() -> ConfigFactory.parseString((String)this.configSource.get()));
        DriverConfig initialConfig = loader.getInitialConfig();
        Assertions.assertThat(initialConfig).hasIntOption(MockOptions.INT1, 42);
    }

    @Test
    public void should_schedule_reloading_task() {
        DefaultDriverConfigLoader loader = new DefaultDriverConfigLoader(() -> ConfigFactory.parseString((String)this.configSource.get()));
        loader.onDriverInit((DriverContext)this.context);
        this.adminExecutor.waitForNonScheduledTasks();
        ScheduledTaskCapturingEventLoop.CapturedTask<?> task = this.adminExecutor.nextTask();
        Assertions.assertThat((long)task.getInitialDelay(TimeUnit.SECONDS)).isEqualTo(12L);
        Assertions.assertThat((long)task.getPeriod(TimeUnit.SECONDS)).isEqualTo(12L);
    }

    @Test
    public void should_detect_config_change_from_periodic_reload() {
        DefaultDriverConfigLoader loader = new DefaultDriverConfigLoader(() -> ConfigFactory.parseString((String)this.configSource.get()));
        DriverConfig initialConfig = loader.getInitialConfig();
        Assertions.assertThat(initialConfig).hasIntOption(MockOptions.INT1, 42);
        loader.onDriverInit((DriverContext)this.context);
        this.adminExecutor.waitForNonScheduledTasks();
        ScheduledTaskCapturingEventLoop.CapturedTask<?> task = this.adminExecutor.nextTask();
        this.configSource.set("int1 = 43");
        task.run();
        Assertions.assertThat(initialConfig).hasIntOption(MockOptions.INT1, 43);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ConfigChangeEvent.INSTANCE);
    }

    @Test
    public void should_detect_config_change_from_manual_reload() {
        DefaultDriverConfigLoader loader = new DefaultDriverConfigLoader(() -> ConfigFactory.parseString((String)this.configSource.get()));
        DriverConfig initialConfig = loader.getInitialConfig();
        Assertions.assertThat(initialConfig).hasIntOption(MockOptions.INT1, 42);
        loader.onDriverInit((DriverContext)this.context);
        this.adminExecutor.waitForNonScheduledTasks();
        this.configSource.set("int1 = 43");
        CompletionStage reloaded = loader.reload();
        this.adminExecutor.waitForNonScheduledTasks();
        Assertions.assertThat(initialConfig).hasIntOption(MockOptions.INT1, 43);
        ((EventBus)Mockito.verify((Object)this.eventBus)).fire((Object)ConfigChangeEvent.INSTANCE);
        Assertions.assertThatStage(reloaded).isSuccess(changed -> Assertions.assertThat((Boolean)changed).isTrue());
    }

    @Test
    public void should_not_notify_from_periodic_reload_if_config_has_not_changed() {
        DefaultDriverConfigLoader loader = new DefaultDriverConfigLoader(() -> ConfigFactory.parseString((String)this.configSource.get()));
        DriverConfig initialConfig = loader.getInitialConfig();
        Assertions.assertThat(initialConfig).hasIntOption(MockOptions.INT1, 42);
        loader.onDriverInit((DriverContext)this.context);
        this.adminExecutor.waitForNonScheduledTasks();
        ScheduledTaskCapturingEventLoop.CapturedTask<?> task = this.adminExecutor.nextTask();
        task.run();
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire((Object)ConfigChangeEvent.INSTANCE);
    }

    @Test
    public void should_not_notify_from_manual_reload_if_config_has_not_changed() {
        DefaultDriverConfigLoader loader = new DefaultDriverConfigLoader(() -> ConfigFactory.parseString((String)this.configSource.get()));
        DriverConfig initialConfig = loader.getInitialConfig();
        Assertions.assertThat(initialConfig).hasIntOption(MockOptions.INT1, 42);
        loader.onDriverInit((DriverContext)this.context);
        this.adminExecutor.waitForNonScheduledTasks();
        CompletionStage reloaded = loader.reload();
        this.adminExecutor.waitForNonScheduledTasks();
        ((EventBus)Mockito.verify((Object)this.eventBus, (VerificationMode)Mockito.never())).fire((Object)ConfigChangeEvent.INSTANCE);
        Assertions.assertThatStage(reloaded).isSuccess(changed -> Assertions.assertThat((Boolean)changed).isFalse());
    }

    @Test
    public void should_load_from_other_classpath_resource() {
        DriverConfigLoader loader = DriverConfigLoader.fromClasspath((String)"config/customApplication");
        DriverExecutionProfile config = loader.getInitialConfig().getDefaultProfile();
        Assertions.assertThat((Duration)config.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((int)config.getInt((DriverOption)DefaultDriverOption.REQUEST_PAGE_SIZE)).isEqualTo(2000);
        Assertions.assertThat((String)config.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo(DefaultConsistencyLevel.ONE.name());
        Assertions.assertThat((String)config.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)).isEqualTo(DefaultConsistencyLevel.SERIAL.name());
    }

    @Test
    public void should_load_from_file() {
        File file = new File("src/test/resources/config/customApplication.conf");
        Assertions.assertThat((File)file).exists();
        DriverConfigLoader loader = DriverConfigLoader.fromFile((File)file);
        DriverExecutionProfile config = loader.getInitialConfig().getDefaultProfile();
        Assertions.assertThat((Duration)config.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((String)config.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)).isEqualTo(DefaultConsistencyLevel.SERIAL.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void should_load_from_file_with_system_property() {
        File file = new File("src/test/resources/config/customApplication.conf");
        Assertions.assertThat((File)file).exists();
        System.setProperty("config.file", file.getAbsolutePath());
        try {
            DefaultDriverConfigLoader loader = new DefaultDriverConfigLoader();
            DriverExecutionProfile config = loader.getInitialConfig().getDefaultProfile();
            Assertions.assertThat((Duration)config.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).isEqualTo((Object)Duration.ofSeconds(5L));
            Assertions.assertThat((String)config.getString((DriverOption)DefaultDriverOption.REQUEST_SERIAL_CONSISTENCY)).isEqualTo(DefaultConsistencyLevel.SERIAL.name());
        }
        finally {
            System.clearProperty("config.file");
        }
    }

    @Test
    public void should_return_failed_future_if_reloading_not_supported() {
        DefaultDriverConfigLoader loader = new DefaultDriverConfigLoader(() -> ConfigFactory.parseString((String)this.configSource.get()), false);
        Assertions.assertThat((boolean)loader.supportsReloading()).isFalse();
        CompletionStage stage = loader.reload();
        Assertions.assertThatStage(stage).isFailed(t -> ((AbstractThrowableAssert)Assertions.assertThat((Throwable)t).isInstanceOf(UnsupportedOperationException.class)).hasMessage("This instance of DefaultDriverConfigLoader does not support reloading"));
    }

    @Test
    public void should_load_setting_from_system_property_when_application_conf_is_also_provided() {
        System.setProperty("datastax-java-driver.basic.request.timeout", "1 millisecond");
        try {
            Assertions.assertThat((Duration)new DefaultDriverConfigLoader().getInitialConfig().getDefaultProfile().getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).isEqualTo((Object)Duration.ofMillis(1L));
        }
        finally {
            System.clearProperty("datastax-java-driver.basic.request.timeout");
        }
    }

    @Test
    public void should_load_and_resolve_setting_from_system_property_when_application_conf_is_also_provided() {
        System.setProperty("datastax-java-driver.advanced.connection.init-query-timeout", "1234 milliseconds");
        try {
            Assertions.assertThat((Duration)new DefaultDriverConfigLoader().getInitialConfig().getDefaultProfile().getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).isEqualTo((Object)Duration.ofMillis(1234L));
        }
        finally {
            System.clearProperty("datastax-java-driver.advanced.connection.init-query-timeout");
        }
    }

    @Test
    public void should_load_setting_from_system_property_when_application_conf_is_also_provided_for_custom_classloader() {
        System.setProperty("datastax-java-driver.basic.request.timeout", "1 millisecond");
        try {
            Assertions.assertThat((Duration)new DefaultDriverConfigLoader(Thread.currentThread().getContextClassLoader()).getInitialConfig().getDefaultProfile().getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).isEqualTo((Object)Duration.ofMillis(1L));
        }
        finally {
            System.clearProperty("datastax-java-driver.basic.request.timeout");
        }
    }

    @Test
    public void should_create_from_string() {
        DriverExecutionProfile config = DriverConfigLoader.fromString((String)"datastax-java-driver.basic { session-name = my-app\nrequest.timeout = 1 millisecond }").getInitialConfig().getDefaultProfile();
        Assertions.assertThat((String)config.getString((DriverOption)DefaultDriverOption.SESSION_NAME)).isEqualTo("my-app");
        Assertions.assertThat((Duration)config.getDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT)).isEqualTo((Object)Duration.ofMillis(1L));
        Assertions.assertThat((String)config.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).isEqualTo("LOCAL_ONE");
    }
}

