/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.map;

import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OptionsMap;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.internal.core.config.MockOptions;
import com.datastax.oss.driver.internal.core.config.MockTypedOptions;
import com.datastax.oss.driver.internal.core.config.typesafe.DefaultDriverConfigLoader;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.Test;

public class MapBasedDriverConfigLoaderTest {
    @Test
    public void should_reflect_changes_in_real_time() {
        OptionsMap source = new OptionsMap();
        source.put(MockTypedOptions.INT1, (Object)1);
        DriverConfigLoader loader = DriverConfigLoader.fromMap((OptionsMap)source);
        DriverConfig config = loader.getInitialConfig();
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT1)).isEqualTo(1);
        source.put(MockTypedOptions.INT1, (Object)2);
        Assertions.assertThat((int)config.getDefaultProfile().getInt((DriverOption)MockOptions.INT1)).isEqualTo(2);
    }

    @Test
    public void should_fill_default_profile_like_reference_file() {
        OptionsMap optionsMap = OptionsMap.driverDefaults();
        DriverExecutionProfile mapBasedConfig = DriverConfigLoader.fromMap((OptionsMap)optionsMap).getInitialConfig().getDefaultProfile();
        DriverExecutionProfile fileBasedConfig = new DefaultDriverConfigLoader(() -> {
            ConfigFactory.invalidateCaches();
            return ConfigFactory.defaultReference().getConfig("datastax-java-driver");
        }).getInitialConfig().getDefaultProfile();
        Assertions.assertThat((Iterable)mapBasedConfig.entrySet()).hasSize(fileBasedConfig.entrySet().size() - 1);
        for (TypedDriverOption option : TypedDriverOption.builtInValues()) {
            if (option.getRawOption() == DefaultDriverOption.CONFIG_RELOAD_INTERVAL) continue;
            Optional<Object> fileBasedValue = this.get(fileBasedConfig, option);
            Optional<Object> mapBasedValue = this.get(mapBasedConfig, option);
            ((OptionalAssert)Assertions.assertThat(mapBasedValue).as("Wrong value for %s in OptionsMap", new Object[]{option.getRawOption()})).isEqualTo(fileBasedValue);
        }
    }

    private Optional<Object> get(DriverExecutionProfile config, TypedDriverOption<?> typedOption) {
        DriverOption option = typedOption.getRawOption();
        GenericType type = typedOption.getExpectedType();
        Object value = null;
        if (config.isDefined(option)) {
            if (type.equals((Object)GenericType.listOf(String.class))) {
                value = config.getStringList(option);
            } else if (type.equals((Object)GenericType.STRING)) {
                value = config.getString(option);
            } else if (type.equals((Object)GenericType.DURATION)) {
                value = config.getDuration(option);
            } else if (type.equals((Object)GenericType.INTEGER)) {
                value = config.getInt(option);
            } else if (type.equals((Object)GenericType.BOOLEAN)) {
                value = config.getBoolean(option);
            } else if (type.equals((Object)GenericType.LONG)) {
                try {
                    value = config.getLong(option);
                }
                catch (ConfigException.WrongType e) {
                    value = config.getBytes(option);
                }
            } else if (type.equals((Object)GenericType.mapOf((GenericType)GenericType.STRING, (GenericType)GenericType.STRING))) {
                value = config.getStringMap(option);
            } else {
                Assertions.fail((String)("Unexpected type " + type));
            }
        }
        return Optional.ofNullable(value);
    }
}

