/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.composite;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.OptionsMap;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class CompositeDriverConfigTest {
    private OptionsMap primaryMap;
    private OptionsMap fallbackMap;
    private DriverConfig compositeConfig;
    private DriverExecutionProfile compositeDefaultProfile;

    @Before
    public void setup() {
        this.primaryMap = new OptionsMap();
        this.primaryMap.put(TypedDriverOption.CONTINUOUS_PAGING_MAX_PAGES, (Object)1);
        this.fallbackMap = new OptionsMap();
        this.fallbackMap.put(TypedDriverOption.CONTINUOUS_PAGING_MAX_PAGES, (Object)1);
        DriverConfigLoader compositeLoader = DriverConfigLoader.compose((DriverConfigLoader)DriverConfigLoader.fromMap((OptionsMap)this.primaryMap), (DriverConfigLoader)DriverConfigLoader.fromMap((OptionsMap)this.fallbackMap));
        this.compositeConfig = compositeLoader.getInitialConfig();
        this.compositeDefaultProfile = this.compositeConfig.getDefaultProfile();
    }

    @Test
    public void should_use_value_from_primary_config() {
        this.primaryMap.put(TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, (Object)1);
        Assertions.assertThat((boolean)this.compositeDefaultProfile.isDefined((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isTrue();
        Assertions.assertThat((int)this.compositeDefaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isEqualTo(1);
        Assertions.assertThat((Iterable)this.compositeDefaultProfile.entrySet()).containsExactly((Object[])new Map.Entry[]{Assertions.entry((Object)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE.getPath(), (Object)1), Assertions.entry((Object)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES.getPath(), (Object)1)});
    }

    @Test
    public void should_ignore_value_from_fallback_config_if_defined_in_both() {
        this.primaryMap.put(TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, (Object)1);
        this.fallbackMap.put(TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, (Object)2);
        Assertions.assertThat((boolean)this.compositeDefaultProfile.isDefined((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isTrue();
        Assertions.assertThat((int)this.compositeDefaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isEqualTo(1);
        Assertions.assertThat((Iterable)this.compositeDefaultProfile.entrySet()).containsExactly((Object[])new Map.Entry[]{Assertions.entry((Object)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE.getPath(), (Object)1), Assertions.entry((Object)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES.getPath(), (Object)1)});
    }

    @Test
    public void should_use_value_from_fallback_config_if_not_defined_in_primary() {
        this.fallbackMap.put(TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, (Object)1);
        Assertions.assertThat((boolean)this.compositeDefaultProfile.isDefined((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isTrue();
        Assertions.assertThat((int)this.compositeDefaultProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isEqualTo(1);
        Assertions.assertThat((Iterable)this.compositeDefaultProfile.entrySet()).containsExactly((Object[])new Map.Entry[]{Assertions.entry((Object)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE.getPath(), (Object)1), Assertions.entry((Object)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES.getPath(), (Object)1)});
    }

    @Test
    public void should_merge_profiles() {
        this.primaryMap.put("onlyInPrimary", TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, (Object)1);
        this.primaryMap.put("inBoth", TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, (Object)2);
        this.fallbackMap.put("inBoth", TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, (Object)3);
        this.fallbackMap.put("onlyInFallback", TypedDriverOption.CONNECTION_POOL_LOCAL_SIZE, (Object)4);
        Assertions.assertThat((Map)this.compositeConfig.getProfiles()).containsKeys((Object[])new String[]{"default", "onlyInPrimary", "inBoth", "inBoth", "onlyInFallback"});
        Assertions.assertThat((int)this.compositeConfig.getProfile("onlyInPrimary").getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isEqualTo(1);
        Assertions.assertThat((int)this.compositeConfig.getProfile("inBoth").getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isEqualTo(2);
        Assertions.assertThat((int)this.compositeConfig.getProfile("onlyInFallback").getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE)).isEqualTo(4);
        Assertions.assertThat((Iterable)this.compositeConfig.getProfile("onlyInPrimary").entrySet()).containsExactly((Object[])new Map.Entry[]{Assertions.entry((Object)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE.getPath(), (Object)1), Assertions.entry((Object)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES.getPath(), (Object)1)});
        Assertions.assertThat((Iterable)this.compositeConfig.getProfile("inBoth").entrySet()).containsExactly((Object[])new Map.Entry[]{Assertions.entry((Object)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE.getPath(), (Object)2), Assertions.entry((Object)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES.getPath(), (Object)1)});
        Assertions.assertThat((Iterable)this.compositeConfig.getProfile("onlyInFallback").entrySet()).containsExactly((Object[])new Map.Entry[]{Assertions.entry((Object)DefaultDriverOption.CONNECTION_POOL_LOCAL_SIZE.getPath(), (Object)4), Assertions.entry((Object)DseDriverOption.CONTINUOUS_PAGING_MAX_PAGES.getPath(), (Object)1)});
    }
}

