/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.config.composite;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DriverConfigLoader;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=DataProviderRunner.class)
public class CompositeDriverConfigReloadTest {
    @Mock
    private DriverConfigLoader primaryLoader;
    @Mock
    private DriverConfigLoader fallbackLoader;
    private DriverConfigLoader compositeLoader;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        this.compositeLoader = DriverConfigLoader.compose((DriverConfigLoader)this.primaryLoader, (DriverConfigLoader)this.fallbackLoader);
    }

    @Test
    @UseDataProvider(value="reloadabilities")
    public void should_be_reloadable_if_either_child_is(boolean primaryIsReloadable, boolean fallbackIsReloadable, boolean compositeShouldBeReloadable) {
        Mockito.when((Object)this.primaryLoader.supportsReloading()).thenReturn((Object)primaryIsReloadable);
        Mockito.when((Object)this.fallbackLoader.supportsReloading()).thenReturn((Object)fallbackIsReloadable);
        Assertions.assertThat((boolean)this.compositeLoader.supportsReloading()).isEqualTo(compositeShouldBeReloadable);
    }

    @Test
    @UseDataProvider(value="reloadabilities")
    public void should_delegate_reloading_to_reloadable_children(boolean primaryIsReloadable, boolean fallbackIsReloadable, boolean compositeShouldBeReloadable) {
        Mockito.when((Object)this.primaryLoader.supportsReloading()).thenReturn((Object)primaryIsReloadable);
        Mockito.when((Object)this.primaryLoader.reload()).thenReturn((Object)(primaryIsReloadable ? CompletableFuture.completedFuture(true) : CompletableFutures.failedFuture((Throwable)new UnsupportedOperationException())));
        Mockito.when((Object)this.fallbackLoader.supportsReloading()).thenReturn((Object)fallbackIsReloadable);
        Mockito.when((Object)this.fallbackLoader.reload()).thenReturn((Object)(fallbackIsReloadable ? CompletableFuture.completedFuture(true) : CompletableFutures.failedFuture((Throwable)new UnsupportedOperationException())));
        CompletionStage reloadFuture = this.compositeLoader.reload();
        if (compositeShouldBeReloadable) {
            Assertions.assertThat((CompletionStage)reloadFuture).isCompletedWithValue((Object)true);
        } else {
            Assertions.assertThat((CompletionStage)reloadFuture).isCompletedExceptionally();
            Throwable t = org.assertj.core.api.Assertions.catchThrowable(() -> {
                Boolean cfr_ignored_0 = (Boolean)reloadFuture.toCompletableFuture().get();
            });
            Assertions.assertThat((Throwable)t).hasRootCauseInstanceOf(UnsupportedOperationException.class);
        }
        ((DriverConfigLoader)Mockito.verify((Object)this.primaryLoader, (VerificationMode)(primaryIsReloadable ? Mockito.times((int)1) : Mockito.never()))).reload();
        ((DriverConfigLoader)Mockito.verify((Object)this.fallbackLoader, (VerificationMode)(fallbackIsReloadable ? Mockito.times((int)1) : Mockito.never()))).reload();
    }

    @DataProvider
    public static Object[][] reloadabilities() {
        return new Object[][]{{true, true, true}, {true, false, true}, {false, true, true}, {false, false, false}};
    }
}

