/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.channel;

import com.datastax.oss.driver.internal.core.channel.ResponseCallback;
import com.datastax.oss.protocol.internal.Frame;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.function.Predicate;

class MockResponseCallback
implements ResponseCallback {
    private final Queue<Object> responses = new ArrayDeque<Object>();
    private final Predicate<Frame> isLastResponse;
    volatile int streamId = -1;

    MockResponseCallback() {
        this(f -> true);
    }

    MockResponseCallback(Predicate<Frame> isLastResponse) {
        this.isLastResponse = isLastResponse;
    }

    public void onResponse(Frame responseFrame) {
        this.responses.offer(responseFrame);
    }

    public void onFailure(Throwable error) {
        this.responses.offer(error);
    }

    public boolean isLastResponse(Frame responseFrame) {
        return this.isLastResponse.test(responseFrame);
    }

    public void onStreamIdAssigned(int streamId) {
        this.streamId = streamId;
    }

    Frame getLastResponse() {
        return (Frame)this.responses.poll();
    }

    Throwable getFailure() {
        return (Throwable)this.responses.poll();
    }
}

