/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import com.datastax.oss.driver.internal.core.ContactPoints;
import com.datastax.oss.driver.internal.core.metadata.DefaultEndPoint;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;
import org.slf4j.LoggerFactory;

@RunWith(value=MockitoJUnitRunner.class)
public class ContactPointsTest {
    @Mock
    private Appender<ILoggingEvent> appender;
    @Captor
    private ArgumentCaptor<ILoggingEvent> loggingEventCaptor;
    private Logger logger;
    private Level initialLogLevel;

    @Before
    public void setup() {
        this.logger = (Logger)LoggerFactory.getLogger(ContactPoints.class);
        this.initialLogLevel = this.logger.getLevel();
        this.logger.setLevel(Level.INFO);
        this.logger.addAppender(this.appender);
    }

    @After
    public void teardown() {
        this.logger.detachAppender(this.appender);
        this.logger.setLevel(this.initialLogLevel);
    }

    @Test
    public void should_parse_ipv4_address_and_port_in_configuration() {
        Set endPoints = ContactPoints.merge(Collections.emptySet(), (List)ImmutableList.of((Object)"127.0.0.1:9042"), (boolean)true);
        Assertions.assertThat((Iterable)endPoints).containsExactly((Object[])new EndPoint[]{new DefaultEndPoint(new InetSocketAddress("127.0.0.1", 9042))});
    }

    @Test
    public void should_parse_ipv6_address_and_port_in_configuration() {
        Set endPoints = ContactPoints.merge(Collections.emptySet(), (List)ImmutableList.of((Object)"0:0:0:0:0:0:0:1:9042", (Object)"::2:9042"), (boolean)true);
        Assertions.assertThat((Iterable)endPoints).containsExactly((Object[])new EndPoint[]{new DefaultEndPoint(new InetSocketAddress("::1", 9042)), new DefaultEndPoint(new InetSocketAddress("::2", 9042))});
    }

    @Test
    public void should_parse_host_and_port_in_configuration_and_create_unresolved() {
        Set endPoints = ContactPoints.merge(Collections.emptySet(), (List)ImmutableList.of((Object)"localhost:9042"), (boolean)false);
        Assertions.assertThat((Iterable)endPoints).containsExactly((Object[])new EndPoint[]{new DefaultEndPoint(InetSocketAddress.createUnresolved("localhost", 9042))});
    }

    @Test
    public void should_parse_host_and_port_and_resolve_all_a_records() throws UnknownHostException {
        int localhostARecordsCount = InetAddress.getAllByName("localhost").length;
        Assume.assumeTrue((String)"This test assumes that localhost resolves to multiple A-records", (localhostARecordsCount >= 2 ? 1 : 0) != 0);
        Set endPoints = ContactPoints.merge(Collections.emptySet(), (List)ImmutableList.of((Object)"localhost:9042"), (boolean)true);
        Assertions.assertThat((Iterable)endPoints).hasSize(localhostARecordsCount);
        this.assertLog(Level.INFO, "Contact point localhost:9042 resolves to multiple addresses, will use them all");
    }

    @Test
    public void should_ignore_malformed_host_and_port_and_warn() {
        Set endPoints = ContactPoints.merge(Collections.emptySet(), (List)ImmutableList.of((Object)"foobar"), (boolean)true);
        Assertions.assertThat((Iterable)endPoints).isEmpty();
        this.assertLog(Level.WARN, "Ignoring invalid contact point foobar (expecting host:port)");
    }

    @Test
    public void should_ignore_malformed_port_and_warn() {
        Set endPoints = ContactPoints.merge(Collections.emptySet(), (List)ImmutableList.of((Object)"127.0.0.1:foobar"), (boolean)true);
        Assertions.assertThat((Iterable)endPoints).isEmpty();
        this.assertLog(Level.WARN, "Ignoring invalid contact point 127.0.0.1:foobar (expecting a number, got foobar)");
    }

    @Test
    public void should_merge_programmatic_and_configuration() {
        Set endPoints = ContactPoints.merge((Set)ImmutableSet.of((Object)new DefaultEndPoint(new InetSocketAddress("127.0.0.1", 9042))), (List)ImmutableList.of((Object)"127.0.0.2:9042"), (boolean)true);
        Assertions.assertThat((Iterable)endPoints).containsOnly((Object[])new EndPoint[]{new DefaultEndPoint(new InetSocketAddress("127.0.0.1", 9042)), new DefaultEndPoint(new InetSocketAddress("127.0.0.2", 9042))});
    }

    @Test
    public void should_warn_if_duplicate_between_programmatic_and_configuration() {
        Set endPoints = ContactPoints.merge((Set)ImmutableSet.of((Object)new DefaultEndPoint(new InetSocketAddress("127.0.0.1", 9042))), (List)ImmutableList.of((Object)"127.0.0.1:9042"), (boolean)true);
        Assertions.assertThat((Iterable)endPoints).containsOnly((Object[])new EndPoint[]{new DefaultEndPoint(new InetSocketAddress("127.0.0.1", 9042))});
        this.assertLog(Level.WARN, "Duplicate contact point /127.0.0.1:9042");
    }

    @Test
    public void should_warn_if_duplicate_in_configuration() {
        Set endPoints = ContactPoints.merge(Collections.emptySet(), (List)ImmutableList.of((Object)"127.0.0.1:9042", (Object)"127.0.0.1:9042"), (boolean)true);
        Assertions.assertThat((Iterable)endPoints).containsOnly((Object[])new EndPoint[]{new DefaultEndPoint(new InetSocketAddress("127.0.0.1", 9042))});
        this.assertLog(Level.WARN, "Duplicate contact point /127.0.0.1:9042");
    }

    private void assertLog(Level level, String message) {
        ((Appender)Mockito.verify(this.appender, (VerificationMode)Mockito.atLeast((int)1))).doAppend((Object)((ILoggingEvent)this.loggingEventCaptor.capture()));
        List logs = Assertions.filter((Iterable)this.loggingEventCaptor.getAllValues()).with("level", (Object)level).get();
        Assertions.assertThat((Iterable)logs).hasSize(1);
        Assertions.assertThat((String)((ILoggingEvent)logs.iterator().next()).getFormattedMessage()).contains(new CharSequence[]{message});
    }
}

