/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.assertj.core.api.Assertions;

public abstract class SerializationHelper {
    public static <T> byte[] serialize(T t) {
        try {
            ByteArrayOutputStream bytes = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bytes);
            out.writeObject(t);
            return bytes.toByteArray();
        }
        catch (Exception e) {
            Assertions.fail((String)"Unexpected error", (Throwable)e);
            throw new AssertionError();
        }
    }

    public static <T> T deserialize(byte[] bytes) {
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            Object t = in.readObject();
            return (T)t;
        }
        catch (Exception e) {
            Assertions.fail((String)"Unexpected error", (Throwable)e);
            throw new AssertionError();
        }
    }

    public static <T> T serializeAndDeserialize(T t) {
        return SerializationHelper.deserialize(SerializationHelper.serialize(t));
    }
}

