/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.type.reflect;

import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.driver.api.core.type.reflect.GenericTypeParameter;
import com.datastax.oss.driver.shaded.guava.common.reflect.TypeToken;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class GenericTypeTest {
    @Test
    public void should_wrap_class() {
        GenericType stringType = GenericType.of(String.class);
        Assertions.assertThat((Object)stringType.__getToken()).isEqualTo((Object)TypeToken.of(String.class));
    }

    @Test
    public void should_capture_generic_type() {
        GenericType<List<String>> stringListType = new GenericType<List<String>>(){};
        TypeToken<List<String>> stringListToken = new TypeToken<List<String>>(){};
        Assertions.assertThat((Object)stringListType.__getToken()).isEqualTo((Object)stringListToken);
    }

    @Test
    public void should_wrap_classes_in_collection() {
        GenericType mapType = GenericType.mapOf(String.class, Integer.class);
        Assertions.assertThat((Object)mapType.__getToken()).isEqualTo((Object)new TypeToken<Map<String, Integer>>(){});
    }

    @Test
    public void should_wrap_types_in_collection() {
        GenericType mapType = GenericType.mapOf((GenericType)GenericType.of(String.class), (GenericType)GenericType.listOf(Integer.class));
        Assertions.assertThat((Object)mapType.__getToken()).isEqualTo((Object)new TypeToken<Map<String, List<Integer>>>(){});
    }

    @Test
    public void should_substitute_type_parameters() {
        Assertions.assertThat((Object)this.optionalOf(GenericType.listOf(String.class)).__getToken()).isEqualTo((Object)new TypeToken<Optional<List<String>>>(){});
        Assertions.assertThat((Object)this.mapOf(String.class, Integer.class).__getToken()).isEqualTo((Object)new TypeToken<Map<String, Integer>>(){});
    }

    @Test
    public void should_report_supertype() {
        Assertions.assertThat((boolean)GenericType.of(Number.class).isSupertypeOf(GenericType.of(Integer.class))).isTrue();
        Assertions.assertThat((boolean)GenericType.of(Integer.class).isSupertypeOf(GenericType.of(Number.class))).isFalse();
    }

    @Test
    public void should_report_subtype() {
        Assertions.assertThat((boolean)GenericType.of(Number.class).isSubtypeOf(GenericType.of(Integer.class))).isFalse();
        Assertions.assertThat((boolean)GenericType.of(Integer.class).isSubtypeOf(GenericType.of(Number.class))).isTrue();
    }

    @Test
    public void should_wrap_primitive_type() {
        Assertions.assertThat((Object)GenericType.of(Integer.TYPE).wrap()).isEqualTo((Object)GenericType.of(Integer.class));
        GenericType stringType = GenericType.of(String.class);
        Assertions.assertThat((Object)stringType.wrap()).isSameAs((Object)stringType);
    }

    @Test
    public void should_unwrap_wrapper_type() {
        Assertions.assertThat((Object)GenericType.of(Integer.class).unwrap()).isEqualTo((Object)GenericType.of(Integer.TYPE));
        GenericType stringType = GenericType.of(String.class);
        Assertions.assertThat((Object)stringType.unwrap()).isSameAs((Object)stringType);
    }

    @Test
    public void should_return_raw_type() {
        Assertions.assertThat((Class)GenericType.INTEGER.getRawType()).isEqualTo(Integer.class);
        Assertions.assertThat((Class)GenericType.listOf(Integer.class).getRawType()).isEqualTo(List.class);
    }

    @Test
    public void should_return_super_type() {
        GenericType expectedType = this.iterableOf(GenericType.INTEGER);
        Assertions.assertThat((Object)GenericType.listOf(Integer.class).getSupertype(Iterable.class)).isEqualTo(expectedType);
    }

    @Test
    public void should_return_sub_type() {
        GenericType superType = this.iterableOf(GenericType.INTEGER);
        Assertions.assertThat((Object)superType.getSubtype(List.class)).isEqualTo((Object)GenericType.listOf((GenericType)GenericType.INTEGER));
    }

    @Test
    public void should_return_type() {
        Assertions.assertThat((Object)GenericType.INTEGER.getType()).isEqualTo(Integer.class);
    }

    @Test
    public void should_return_component_type() {
        Assertions.assertThat((Object)GenericType.of(Integer[].class).getComponentType()).isEqualTo((Object)GenericType.INTEGER);
    }

    @Test
    public void should_report_is_array() {
        Assertions.assertThat((boolean)GenericType.INTEGER.isArray()).isFalse();
        Assertions.assertThat((boolean)GenericType.of(Integer[].class).isArray()).isTrue();
    }

    private <T> GenericType<Optional<T>> optionalOf(GenericType<T> elementType) {
        return new GenericType<Optional<T>>(){}.where(new GenericTypeParameter<T>(){}, elementType);
    }

    private <T> GenericType<Iterable<T>> iterableOf(GenericType<T> elementType) {
        return new GenericType<Iterable<T>>(){}.where(new GenericTypeParameter<T>(){}, elementType);
    }

    private <K, V> GenericType<Map<K, V>> mapOf(Class<K> keyClass, Class<V> valueClass) {
        return new GenericType<Map<K, V>>(){}.where(new GenericTypeParameter<K>(){}, keyClass).where(new GenericTypeParameter<V>(){}, valueClass);
    }
}

