/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.specex;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.specex.ConstantSpeculativeExecutionPolicy;
import java.time.Duration;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class ConstantSpeculativeExecutionPolicyTest {
    @Mock
    private DriverContext context;
    @Mock
    private DriverConfig config;
    @Mock
    private DriverExecutionProfile defaultProfile;
    @Mock
    private Request request;

    @Before
    public void setup() {
        Mockito.when((Object)this.context.getConfig()).thenReturn((Object)this.config);
        Mockito.when((Object)this.config.getProfile("default")).thenReturn((Object)this.defaultProfile);
    }

    private void mockOptions(int maxExecutions, long constantDelayMillis) {
        Mockito.when((Object)this.defaultProfile.getInt((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_MAX)).thenReturn((Object)maxExecutions);
        Mockito.when((Object)this.defaultProfile.getDuration((DriverOption)DefaultDriverOption.SPECULATIVE_EXECUTION_DELAY)).thenReturn((Object)Duration.ofMillis(constantDelayMillis));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_if_delay_negative() {
        this.mockOptions(1, -10L);
        new ConstantSpeculativeExecutionPolicy(this.context, "default");
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_if_max_less_than_one() {
        this.mockOptions(0, 10L);
        new ConstantSpeculativeExecutionPolicy(this.context, "default");
    }

    @Test
    public void should_return_delay_until_max() {
        this.mockOptions(3, 10L);
        ConstantSpeculativeExecutionPolicy policy = new ConstantSpeculativeExecutionPolicy(this.context, "default");
        Assertions.assertThat((long)policy.nextExecution(null, null, this.request, 1)).isEqualTo(10L);
        Assertions.assertThat((long)policy.nextExecution(null, null, this.request, 2)).isEqualTo(10L);
        Assertions.assertThat((long)policy.nextExecution(null, null, this.request, 3)).isNegative();
    }
}

