/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.retry;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryVerdict;
import com.datastax.oss.driver.api.core.servererrors.CoordinatorException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.internal.core.retry.ConsistencyDowngradingRetryVerdict;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public abstract class RetryPolicyTestBase {
    private final RetryPolicy policy;
    @Mock
    private Request request;

    protected RetryPolicyTestBase(RetryPolicy policy) {
        this.policy = policy;
    }

    protected RetryVerdictAssert assertOnReadTimeout(ConsistencyLevel cl, int blockFor, int received, boolean dataPresent, int retryCount) {
        return new RetryVerdictAssert(this.policy.onReadTimeoutVerdict(this.request, cl, blockFor, received, dataPresent, retryCount));
    }

    protected RetryVerdictAssert assertOnWriteTimeout(ConsistencyLevel cl, WriteType writeType, int blockFor, int received, int retryCount) {
        return new RetryVerdictAssert(this.policy.onWriteTimeoutVerdict(this.request, cl, writeType, blockFor, received, retryCount));
    }

    protected RetryVerdictAssert assertOnUnavailable(ConsistencyLevel cl, int required, int alive, int retryCount) {
        return new RetryVerdictAssert(this.policy.onUnavailableVerdict(this.request, cl, required, alive, retryCount));
    }

    protected RetryVerdictAssert assertOnRequestAborted(Class<? extends Throwable> errorClass, int retryCount) {
        return new RetryVerdictAssert(this.policy.onRequestAbortedVerdict(this.request, (Throwable)Mockito.mock(errorClass), retryCount));
    }

    protected RetryVerdictAssert assertOnErrorResponse(Class<? extends CoordinatorException> errorClass, int retryCount) {
        return new RetryVerdictAssert(this.policy.onErrorResponseVerdict(this.request, (CoordinatorException)Mockito.mock(errorClass), retryCount));
    }

    public static class RetryVerdictAssert
    extends AbstractAssert<RetryVerdictAssert, RetryVerdict> {
        RetryVerdictAssert(RetryVerdict actual) {
            super((Object)actual, RetryVerdictAssert.class);
        }

        public RetryVerdictAssert hasDecision(RetryDecision decision) {
            Assertions.assertThat((Comparable)((RetryVerdict)this.actual).getRetryDecision()).isEqualTo((Object)decision);
            return this;
        }

        public RetryVerdictAssert hasConsistency(ConsistencyLevel cl) {
            ((ObjectAssert)Assertions.assertThat((Object)((RetryVerdict)this.actual)).isInstanceOf(ConsistencyDowngradingRetryVerdict.class)).extracting("consistencyLevel").isEqualTo((Object)cl);
            return this;
        }
    }
}

