/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.retry;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.connection.ClosedConnectionException;
import com.datastax.oss.driver.api.core.connection.HeartbeatException;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryPolicyTestBase;
import com.datastax.oss.driver.api.core.servererrors.DefaultWriteType;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.oss.driver.api.core.servererrors.ReadFailureException;
import com.datastax.oss.driver.api.core.servererrors.ServerError;
import com.datastax.oss.driver.api.core.servererrors.TruncateException;
import com.datastax.oss.driver.api.core.servererrors.WriteFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.internal.core.retry.DefaultRetryPolicy;
import org.junit.Test;

public class DefaultRetryPolicyTest
extends RetryPolicyTestBase {
    public DefaultRetryPolicyTest() {
        super((RetryPolicy)new DefaultRetryPolicy(null, null));
    }

    @Test
    public void should_process_read_timeouts() {
        this.assertOnReadTimeout((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, 2, 2, false, 0).hasDecision(RetryDecision.RETRY_SAME);
        this.assertOnReadTimeout((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, 2, 2, false, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnReadTimeout((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, 2, 2, true, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnReadTimeout((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, 2, 1, true, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnReadTimeout((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, 2, 1, false, 0).hasDecision(RetryDecision.RETHROW);
    }

    @Test
    public void should_process_write_timeouts() {
        this.assertOnWriteTimeout((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, (WriteType)DefaultWriteType.BATCH_LOG, 2, 0, 0).hasDecision(RetryDecision.RETRY_SAME);
        this.assertOnWriteTimeout((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, (WriteType)DefaultWriteType.BATCH_LOG, 2, 0, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnWriteTimeout((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, (WriteType)DefaultWriteType.SIMPLE, 2, 0, 0).hasDecision(RetryDecision.RETHROW);
    }

    @Test
    public void should_process_unavailable() {
        this.assertOnUnavailable((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, 2, 1, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnUnavailable((ConsistencyLevel)DefaultConsistencyLevel.QUORUM, 2, 1, 1).hasDecision(RetryDecision.RETHROW);
    }

    @Test
    public void should_process_aborted_request() {
        this.assertOnRequestAborted(ClosedConnectionException.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnRequestAborted(ClosedConnectionException.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnRequestAborted(HeartbeatException.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnRequestAborted(HeartbeatException.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnRequestAborted(Throwable.class, 0).hasDecision(RetryDecision.RETHROW);
    }

    @Test
    public void should_process_error_response() {
        this.assertOnErrorResponse(ReadFailureException.class, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(ReadFailureException.class, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(WriteFailureException.class, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(WriteFailureException.class, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(WriteFailureException.class, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(OverloadedException.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(OverloadedException.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(ServerError.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(ServerError.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(TruncateException.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(TruncateException.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
    }
}

