/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.retry;

import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.connection.ClosedConnectionException;
import com.datastax.oss.driver.api.core.connection.HeartbeatException;
import com.datastax.oss.driver.api.core.retry.RetryDecision;
import com.datastax.oss.driver.api.core.retry.RetryPolicy;
import com.datastax.oss.driver.api.core.retry.RetryPolicyTestBase;
import com.datastax.oss.driver.api.core.servererrors.OverloadedException;
import com.datastax.oss.driver.api.core.servererrors.ReadFailureException;
import com.datastax.oss.driver.api.core.servererrors.ServerError;
import com.datastax.oss.driver.api.core.servererrors.TruncateException;
import com.datastax.oss.driver.api.core.servererrors.WriteFailureException;
import com.datastax.oss.driver.api.core.servererrors.WriteType;
import com.datastax.oss.driver.internal.core.retry.ConsistencyDowngradingRetryPolicy;
import org.junit.Test;

public class ConsistencyDowngradingRetryPolicyTest
extends RetryPolicyTestBase {
    public ConsistencyDowngradingRetryPolicyTest() {
        super((RetryPolicy)new ConsistencyDowngradingRetryPolicy("test"));
    }

    @Test
    public void should_process_read_timeouts() {
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 2, 2, false, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnReadTimeout(ConsistencyLevel.SERIAL, 2, 2, false, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 4, 3, true, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.THREE);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 4, 3, false, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.THREE);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 3, 2, true, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.TWO);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 3, 2, false, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.TWO);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 2, 1, true, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.ONE);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 2, 1, false, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.ONE);
        this.assertOnReadTimeout(ConsistencyLevel.EACH_QUORUM, 2, 0, true, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.ONE);
        this.assertOnReadTimeout(ConsistencyLevel.EACH_QUORUM, 2, 0, false, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.ONE);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 2, 0, true, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 2, 0, false, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 2, 2, false, 0).hasDecision(RetryDecision.RETRY_SAME);
        this.assertOnReadTimeout(ConsistencyLevel.QUORUM, 2, 2, true, 0).hasDecision(RetryDecision.RETHROW);
    }

    @Test
    public void should_process_write_timeouts() {
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.BATCH_LOG, 2, 0, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.SIMPLE, 2, 1, 0).hasDecision(RetryDecision.IGNORE);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.SIMPLE, 2, 0, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.BATCH, 2, 1, 0).hasDecision(RetryDecision.IGNORE);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.BATCH, 2, 0, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.UNLOGGED_BATCH, 4, 3, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.THREE);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.UNLOGGED_BATCH, 3, 2, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.TWO);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.UNLOGGED_BATCH, 2, 1, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.ONE);
        this.assertOnWriteTimeout(ConsistencyLevel.EACH_QUORUM, WriteType.UNLOGGED_BATCH, 2, 0, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.ONE);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.UNLOGGED_BATCH, 2, 0, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.BATCH_LOG, 2, 1, 0).hasDecision(RetryDecision.RETRY_SAME);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.COUNTER, 2, 1, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.CAS, 2, 1, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.VIEW, 2, 1, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnWriteTimeout(ConsistencyLevel.QUORUM, WriteType.CDC, 2, 1, 0).hasDecision(RetryDecision.RETHROW);
    }

    @Test
    public void should_process_unavailable() {
        this.assertOnUnavailable(ConsistencyLevel.QUORUM, 2, 1, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnUnavailable(ConsistencyLevel.SERIAL, 2, 1, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnUnavailable(ConsistencyLevel.QUORUM, 4, 3, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.THREE);
        this.assertOnUnavailable(ConsistencyLevel.QUORUM, 3, 2, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.TWO);
        this.assertOnUnavailable(ConsistencyLevel.QUORUM, 2, 1, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.ONE);
        this.assertOnUnavailable(ConsistencyLevel.EACH_QUORUM, 2, 0, 0).hasDecision(RetryDecision.RETRY_SAME).hasConsistency(ConsistencyLevel.ONE);
        this.assertOnUnavailable(ConsistencyLevel.QUORUM, 2, 0, 0).hasDecision(RetryDecision.RETHROW);
    }

    @Test
    public void should_process_aborted_request() {
        this.assertOnRequestAborted(ClosedConnectionException.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnRequestAborted(ClosedConnectionException.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnRequestAborted(HeartbeatException.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnRequestAborted(HeartbeatException.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnRequestAborted(Throwable.class, 0).hasDecision(RetryDecision.RETHROW);
    }

    @Test
    public void should_process_error_response() {
        this.assertOnErrorResponse(ReadFailureException.class, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(ReadFailureException.class, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(WriteFailureException.class, 0).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(WriteFailureException.class, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(WriteFailureException.class, 1).hasDecision(RetryDecision.RETHROW);
        this.assertOnErrorResponse(OverloadedException.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(OverloadedException.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(ServerError.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(ServerError.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(TruncateException.class, 0).hasDecision(RetryDecision.RETRY_NEXT);
        this.assertOnErrorResponse(TruncateException.class, 1).hasDecision(RetryDecision.RETRY_NEXT);
    }
}

