/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.paging;

import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.paging.OffsetPager;
import com.datastax.oss.driver.api.core.paging.OffsetPagerTestFixture;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public abstract class OffsetPagerTestBase {
    @DataProvider
    public static Object[][] fetchSizes() {
        return TestDataProviders.fromList(1, 2, 3, 100);
    }

    @DataProvider
    public static Object[][] scenarios() {
        Object[][] fixtures = TestDataProviders.fromList("a,b,c,d,e,f | 1    | 3    | 1    | a,b,c    | false", "a,b,c,d,e,f | 2    | 3    | 2    | d,e,f    | true", "a,b,c,d,e,f | 2    | 4    | 2    | e,f      | true", "a,b,c,d,e,f | 2    | 5    | 2    | f        | true", "a,b,c       | 1    | 3    | 1    | a,b,c    | true", "a,b         | 1    | 3    | 1    | a,b      | true", "a           | 1    | 3    | 1    | a        | true", "            | 1    | 3    | 1    |          | true", "a,b,c,d,e,f | 3    | 3    | 2    | d,e,f    | true", "a,b,c,d,e   | 3    | 3    | 2    | d,e      | true");
        return TestDataProviders.combine(fixtures, OffsetPagerTestBase.fetchSizes());
    }

    @Test
    @UseDataProvider(value="scenarios")
    public void should_return_existing_page(String fixtureSpec, int fetchSize) {
        OffsetPagerTestFixture fixture = new OffsetPagerTestFixture(fixtureSpec);
        OffsetPager pager = new OffsetPager(fixture.getPageSize());
        OffsetPager.Page<String> actualPage = this.getActualPage(pager, fixture, fetchSize);
        fixture.assertMatches(actualPage);
    }

    protected abstract OffsetPager.Page<String> getActualPage(OffsetPager var1, OffsetPagerTestFixture var2, int var3);
}

