/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.paging;

import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.paging.OffsetPager;
import com.datastax.oss.driver.api.core.paging.OffsetPagerTestBase;
import com.datastax.oss.driver.api.core.paging.OffsetPagerTestFixture;
import com.datastax.oss.driver.internal.core.MockAsyncPagingIterable;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.List;
import java.util.concurrent.CompletionStage;
import org.junit.Test;

public class OffsetPagerAsyncTest
extends OffsetPagerTestBase {
    @Override
    protected OffsetPager.Page<String> getActualPage(OffsetPager pager, OffsetPagerTestFixture fixture, int fetchSize) {
        CompletionStage pageFuture = pager.getPage(fixture.getAsyncIterable(fetchSize), fixture.getRequestedPage());
        return (OffsetPager.Page)CompletableFutures.getCompleted((CompletionStage)pageFuture);
    }

    @Test
    @UseDataProvider(value="fetchSizes")
    public void should_return_last_page_when_result_finishes_with_empty_frame(int fetchSize) {
        MockAsyncPagingIterable iterable = new MockAsyncPagingIterable(ImmutableList.of((Object)"a", (Object)"b", (Object)"c"), fetchSize, true);
        OffsetPager pager = new OffsetPager(3);
        OffsetPager.Page page = (OffsetPager.Page)CompletableFutures.getCompleted((CompletionStage)pager.getPage(iterable, 1));
        Assertions.assertThat((List)page.getElements()).containsExactly((Object[])new String[]{"a", "b", "c"});
        Assertions.assertThat((int)page.getPageNumber()).isEqualTo(1);
        Assertions.assertThat((boolean)page.isLast()).isTrue();
    }
}

