/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.config;

import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import java.util.HashSet;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Test;

public class TypedDriverOptionTest {
    @Test
    public void should_have_equivalents_for_all_builtin_untyped_options() {
        HashSet<DriverOption> optionsThatHaveATypedEquivalent = new HashSet<DriverOption>();
        for (TypedDriverOption typedOption : TypedDriverOption.builtInValues()) {
            optionsThatHaveATypedEquivalent.add(typedOption.getRawOption());
        }
        ImmutableSet exclusions = ImmutableSet.of((Object)DefaultDriverOption.LOAD_BALANCING_POLICY, (Object)DefaultDriverOption.RETRY_POLICY, (Object)DefaultDriverOption.SPECULATIVE_EXECUTION_POLICY);
        for (DriverOption option : ImmutableSet.builder().add((Object[])DefaultDriverOption.values()).add((Object[])DseDriverOption.values()).build()) {
            if (exclusions.contains(option)) continue;
            ((IterableAssert)Assertions.assertThat(optionsThatHaveATypedEquivalent).as("Couldn't find a typed equivalent for %s.%s. You need to either add a constant in %s, or an exclusion in this test.", new Object[]{option.getClass().getSimpleName(), option, TypedDriverOption.class.getSimpleName()})).contains((Object[])new DriverOption[]{option});
        }
    }
}

