/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.config;

import com.datastax.oss.driver.api.core.config.OptionsMap;
import com.datastax.oss.driver.api.core.config.TypedDriverOption;
import com.datastax.oss.driver.internal.SerializationHelper;
import java.time.Duration;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class OptionsMapTest {
    @Mock
    private Consumer<OptionsMap> mockListener;

    @Test
    public void should_serialize_and_deserialize() {
        OptionsMap initial = OptionsMap.driverDefaults();
        Duration slowTimeout = Duration.ofSeconds(30L);
        initial.put("slow", TypedDriverOption.REQUEST_TIMEOUT, (Object)slowTimeout);
        initial.addChangeListener(this.mockListener);
        OptionsMap deserialized = SerializationHelper.serializeAndDeserialize(initial);
        Assertions.assertThat((Duration)((Duration)deserialized.get(TypedDriverOption.REQUEST_TIMEOUT))).isEqualTo((Object)Duration.ofSeconds(2L));
        Assertions.assertThat((Duration)((Duration)deserialized.get("slow", TypedDriverOption.REQUEST_TIMEOUT))).isEqualTo((Object)slowTimeout);
        Assertions.assertThat((boolean)deserialized.removeChangeListener(this.mockListener)).isFalse();
    }
}

