/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.api.core.auth;

import com.datastax.oss.driver.api.core.auth.PlainTextAuthProviderBase;
import com.datastax.oss.driver.api.core.auth.ProgrammaticPlainTextAuthProvider;
import com.datastax.oss.driver.api.core.metadata.EndPoint;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.Strict.class)
public class ProgrammaticPlainTextAuthProviderTest {
    @Mock
    private EndPoint endpoint;

    @Test
    public void should_return_correct_credentials_without_authorization_id() {
        ProgrammaticPlainTextAuthProvider provider = new ProgrammaticPlainTextAuthProvider("user", "pass");
        PlainTextAuthProviderBase.Credentials credentials = provider.getCredentials(this.endpoint, "irrelevant");
        Assertions.assertThat((char[])credentials.getUsername()).isEqualTo((Object)"user".toCharArray());
        Assertions.assertThat((char[])credentials.getPassword()).isEqualTo((Object)"pass".toCharArray());
        Assertions.assertThat((char[])credentials.getAuthorizationId()).isEqualTo((Object)new char[0]);
    }

    @Test
    public void should_return_correct_credentials_with_authorization_id() {
        ProgrammaticPlainTextAuthProvider provider = new ProgrammaticPlainTextAuthProvider("user", "pass", "proxy");
        PlainTextAuthProviderBase.Credentials credentials = provider.getCredentials(this.endpoint, "irrelevant");
        Assertions.assertThat((char[])credentials.getUsername()).isEqualTo((Object)"user".toCharArray());
        Assertions.assertThat((char[])credentials.getPassword()).isEqualTo((Object)"pass".toCharArray());
        Assertions.assertThat((char[])credentials.getAuthorizationId()).isEqualTo((Object)"proxy".toCharArray());
    }

    @Test
    public void should_change_username() {
        ProgrammaticPlainTextAuthProvider provider = new ProgrammaticPlainTextAuthProvider("user", "pass");
        provider.setUsername("user2");
        PlainTextAuthProviderBase.Credentials credentials = provider.getCredentials(this.endpoint, "irrelevant");
        Assertions.assertThat((char[])credentials.getUsername()).isEqualTo((Object)"user2".toCharArray());
        Assertions.assertThat((char[])credentials.getPassword()).isEqualTo((Object)"pass".toCharArray());
        Assertions.assertThat((char[])credentials.getAuthorizationId()).isEqualTo((Object)new char[0]);
    }

    @Test
    public void should_change_password() {
        ProgrammaticPlainTextAuthProvider provider = new ProgrammaticPlainTextAuthProvider("user", "pass");
        provider.setPassword("pass2");
        PlainTextAuthProviderBase.Credentials credentials = provider.getCredentials(this.endpoint, "irrelevant");
        Assertions.assertThat((char[])credentials.getUsername()).isEqualTo((Object)"user".toCharArray());
        Assertions.assertThat((char[])credentials.getPassword()).isEqualTo((Object)"pass2".toCharArray());
        Assertions.assertThat((char[])credentials.getAuthorizationId()).isEqualTo((Object)new char[0]);
    }

    @Test
    public void should_change_authorization_id() {
        ProgrammaticPlainTextAuthProvider provider = new ProgrammaticPlainTextAuthProvider("user", "pass", "proxy");
        provider.setAuthorizationId("proxy2");
        PlainTextAuthProviderBase.Credentials credentials = provider.getCredentials(this.endpoint, "irrelevant");
        Assertions.assertThat((char[])credentials.getUsername()).isEqualTo((Object)"user".toCharArray());
        Assertions.assertThat((char[])credentials.getPassword()).isEqualTo((Object)"pass".toCharArray());
        Assertions.assertThat((char[])credentials.getAuthorizationId()).isEqualTo((Object)"proxy2".toCharArray());
    }
}

