/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.util.concurrent;

import com.datastax.dse.driver.internal.core.util.concurrent.BoundedConcurrentQueue;
import com.datastax.oss.driver.Assertions;
import java.util.concurrent.CompletionStage;
import org.junit.Test;

public class BoundedConcurrentQueueTest {
    @Test
    public void should_dequeue_null_when_empty() {
        BoundedConcurrentQueue queue = new BoundedConcurrentQueue(4);
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.peek())).isNull();
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.poll())).isNull();
    }

    @Test
    public void should_enqueue_and_dequeue_while_not_full() {
        BoundedConcurrentQueue queue = new BoundedConcurrentQueue(4);
        Assertions.assertThatStage(queue.offer((Object)1)).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(1));
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.peek())).isEqualTo(1);
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.poll())).isEqualTo(1);
        Assertions.assertThatStage(queue.offer((Object)2)).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(2));
        Assertions.assertThatStage(queue.offer((Object)3)).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(3));
        Assertions.assertThatStage(queue.offer((Object)4)).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(4));
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.peek())).isEqualTo(2);
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.poll())).isEqualTo(2);
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.peek())).isEqualTo(3);
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.poll())).isEqualTo(3);
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.peek())).isEqualTo(4);
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.poll())).isEqualTo(4);
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.poll())).isNull();
    }

    @Test
    public void should_delay_insertion_when_full_until_space_available() {
        BoundedConcurrentQueue queue = new BoundedConcurrentQueue(4);
        Assertions.assertThatStage(queue.offer((Object)1)).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(1));
        Assertions.assertThatStage(queue.offer((Object)2)).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(2));
        Assertions.assertThatStage(queue.offer((Object)3)).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(3));
        Assertions.assertThatStage(queue.offer((Object)4)).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(4));
        CompletionStage enqueue5 = queue.offer((Object)5);
        org.assertj.core.api.Assertions.assertThat((CompletionStage)enqueue5).isNotDone();
        org.assertj.core.api.Assertions.assertThat((Integer)((Integer)queue.poll())).isEqualTo(1);
        Assertions.assertThatStage(enqueue5).isSuccess(e -> org.assertj.core.api.Assertions.assertThat((Integer)e).isEqualTo(5));
    }

    @Test(expected=IllegalStateException.class)
    public void should_fail_to_insert_when_other_insert_already_pending() {
        BoundedConcurrentQueue queue = new BoundedConcurrentQueue(1);
        Assertions.assertThatStage(queue.offer((Object)1)).isSuccess();
        Assertions.assertThatStage(queue.offer((Object)2)).isNotDone();
        queue.offer((Object)3);
    }
}

