/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.time;

import com.datastax.dse.driver.api.core.data.time.DateRange;
import com.datastax.dse.driver.api.core.type.codec.DseTypeCodecs;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.shaded.guava.common.base.MoreObjects;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.nio.ByteBuffer;
import java.text.ParseException;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class DateRangeCodecTest {
    @Test
    @UseDataProvider(value="dateRanges")
    public void should_encode_and_decode(DateRange dateRange) {
        TypeCodec codec = DseTypeCodecs.DATE_RANGE;
        DateRange decoded = (DateRange)codec.decode(codec.encode((Object)dateRange, ProtocolVersion.DEFAULT), ProtocolVersion.DEFAULT);
        Assertions.assertThat((Object)decoded).isEqualTo((Object)dateRange);
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_encode_unknown_date_range_type() {
        DseTypeCodecs.DATE_RANGE.decode(ByteBuffer.wrap(new byte[]{127}), ProtocolVersion.DEFAULT);
    }

    @Test
    @UseDataProvider(value="dateRangeStrings")
    public void should_format_and_parse(String dateRangeString) {
        TypeCodec codec = DseTypeCodecs.DATE_RANGE;
        String formatted = codec.format((Object)((DateRange)codec.parse(dateRangeString)));
        Assertions.assertThat((String)formatted).isEqualTo((String)MoreObjects.firstNonNull((Object)dateRangeString, (Object)"NULL"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void should_fail_to_parse_invalid_string() {
        DseTypeCodecs.DATE_RANGE.parse("foo");
    }

    @DataProvider
    public static Object[][] dateRanges() throws ParseException {
        return new Object[][]{{null}, {DateRange.parse((String)"[2011-01 TO 2015]")}, {DateRange.parse((String)"[2010-01-02 TO 2015-05-05T13]")}, {DateRange.parse((String)"[1973-06-30T13:57:28.123Z TO 1999-05-05T14:14:59]")}, {DateRange.parse((String)"[2010-01-01T15 TO 2016-02]")}, {DateRange.parse((String)"[1500 TO 1501]")}, {DateRange.parse((String)"[0001-01-01 TO 0001-01-01]")}, {DateRange.parse((String)"[0001-01-01 TO 0001-01-02]")}, {DateRange.parse((String)"[0000-01-01 TO 0000-01-01]")}, {DateRange.parse((String)"[0000-01-01 TO 0000-01-02]")}, {DateRange.parse((String)"[-0001-01-01 TO -0001-01-01]")}, {DateRange.parse((String)"[-0001-01-01 TO -0001-01-02]")}, {DateRange.parse((String)"[* TO 2014-12-01]")}, {DateRange.parse((String)"[1999 TO *]")}, {DateRange.parse((String)"[* TO *]")}, {DateRange.parse((String)"-0009")}, {DateRange.parse((String)"2000-11")}, {DateRange.parse((String)"*")}};
    }

    @DataProvider
    public static Object[][] dateRangeStrings() {
        return new Object[][]{{null}, {"NULL"}, {"'[2011-01 TO 2015]'"}, {"'[2010-01-02 TO 2015-05-05T13]'"}, {"'[1973-06-30T13:57:28.123Z TO 1999-05-05T14:14:59]'"}, {"'[2010-01-01T15 TO 2016-02]'"}, {"'[1500 TO 1501]'"}, {"'[0001-01-01 TO 0001-01-01]'"}, {"'[0001-01-01 TO 0001-01-02]'"}, {"'[0000-01-01 TO 0000-01-01]'"}, {"'[0000-01-01 TO 0000-01-02]'"}, {"'[-0001-01-01 TO -0001-01-01]'"}, {"'[-0001-01-01 TO -0001-01-02]'"}, {"'[* TO 2014-12-01]'"}, {"'[1999 TO *]'"}, {"'[* TO *]'"}, {"'-0009'"}, {"'2000-11'"}, {"'*'"}};
    }
}

