/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.type.codec.geometry.GeometryCodecTest;
import com.datastax.dse.driver.internal.core.type.codec.geometry.PointCodec;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class PointCodecTest
extends GeometryCodecTest<Point, PointCodec> {
    public PointCodecTest() {
        super(new PointCodec());
    }

    @DataProvider
    public static Object[][] serde() {
        return new Object[][]{{null, null}, {Point.fromCoordinates((double)1.0, (double)2.0), Point.fromCoordinates((double)1.0, (double)2.0)}, {Point.fromCoordinates((double)-1.1, (double)-2.2), Point.fromCoordinates((double)-1.1, (double)-2.2)}};
    }

    @DataProvider
    public static Object[][] format() {
        return new Object[][]{{null, "NULL"}, {Point.fromCoordinates((double)1.0, (double)2.0), "'POINT (1 2)'"}, {Point.fromCoordinates((double)-1.1, (double)-2.2), "'POINT (-1.1 -2.2)'"}};
    }

    @DataProvider
    public static Object[][] parse() {
        return new Object[][]{{null, null}, {"", null}, {" ", null}, {"NULL", null}, {" NULL ", null}, {"'POINT ( 1 2 )'", Point.fromCoordinates((double)1.0, (double)2.0)}, {"'POINT ( 1.0 2.0 )'", Point.fromCoordinates((double)1.0, (double)2.0)}, {"' point ( -1.1 -2.2 )'", Point.fromCoordinates((double)-1.1, (double)-2.2)}, {" ' Point ( -1.1 -2.2 ) ' ", Point.fromCoordinates((double)-1.1, (double)-2.2)}};
    }

    @Override
    @Test
    @UseDataProvider(value="format")
    public void should_format(Point input, String expected) {
        super.should_format(input, expected);
    }

    @Override
    @Test
    @UseDataProvider(value="parse")
    public void should_parse(String input, Point expected) {
        super.should_parse(input, expected);
    }
}

