/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.type.codec.geometry;

import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultLineString;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPoint;
import com.datastax.dse.driver.internal.core.type.codec.geometry.GeometryCodecTest;
import com.datastax.dse.driver.internal.core.type.codec.geometry.LineStringCodec;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class LineStringCodecTest
extends GeometryCodecTest<LineString, LineStringCodec> {
    private static DefaultLineString lineString = new DefaultLineString((Point)new DefaultPoint(30.0, 10.0), (Point)new DefaultPoint(10.0, 30.0), new Point[]{new DefaultPoint(40.0, 40.0)});

    public LineStringCodecTest() {
        super(new LineStringCodec());
    }

    @DataProvider
    public static Object[][] serde() {
        return new Object[][]{{null, null}, {lineString, lineString}};
    }

    @DataProvider
    public static Object[][] format() {
        return new Object[][]{{null, "NULL"}, {lineString, "'LINESTRING (30 10, 10 30, 40 40)'"}};
    }

    @DataProvider
    public static Object[][] parse() {
        return new Object[][]{{null, null}, {"", null}, {" ", null}, {"NULL", null}, {" NULL ", null}, {"'LINESTRING (30 10, 10 30, 40 40)'", lineString}, {" ' LineString (30 10, 10 30, 40 40 ) ' ", lineString}};
    }

    @Override
    @Test
    @UseDataProvider(value="format")
    public void should_format(LineString input, String expected) {
        super.should_format(input, expected);
    }

    @Override
    @Test
    @UseDataProvider(value="parse")
    public void should_parse(String input, LineString expected) {
        super.should_parse(input, expected);
    }
}

