/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.protocol;

import com.datastax.dse.driver.Assertions;
import com.datastax.dse.driver.internal.core.graph.binary.buffer.DseNettyBufferFactory;
import com.datastax.dse.driver.internal.core.protocol.TinkerpopBufferPrimitiveCodec;
import com.datastax.oss.protocol.internal.util.Bytes;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=DataProviderRunner.class)
public class TinkerpopBufferPrimitiveCodecTest {
    private static final DseNettyBufferFactory factory = new DseNettyBufferFactory();
    private final TinkerpopBufferPrimitiveCodec codec = new TinkerpopBufferPrimitiveCodec(factory);

    @Test
    public void should_concatenate() {
        Buffer left = factory.withBytes(new int[]{202, 254});
        Buffer right = factory.withBytes(new int[]{186, 190});
        Assertions.assertThat(this.codec.concat(left, right)).containsExactly("0xcafebabe");
    }

    @Test
    public void should_read_inet_v4() {
        Buffer source = factory.withBytes(new int[]{4, 127, 0, 0, 1, 0, 0, 35, 82});
        InetSocketAddress inet = this.codec.readInet((Object)source);
        Assertions.assertThat((String)inet.getAddress().getHostAddress()).isEqualTo("127.0.0.1");
        Assertions.assertThat((int)inet.getPort()).isEqualTo(9042);
    }

    @Test
    public void should_read_inet_v6() {
        Buffer lengthAndAddress = factory.heap(17);
        lengthAndAddress.writeByte(16);
        lengthAndAddress.writeLong(0L);
        lengthAndAddress.writeLong(1L);
        Buffer source = this.codec.concat(lengthAndAddress, factory.withBytes(new int[]{0, 0, 35, 82}));
        InetSocketAddress inet = this.codec.readInet((Object)source);
        Assertions.assertThat((String)inet.getAddress().getHostAddress()).isEqualTo("0:0:0:0:0:0:0:1");
        Assertions.assertThat((int)inet.getPort()).isEqualTo(9042);
    }

    @Test
    public void should_fail_to_read_inet_if_length_invalid() {
        Buffer source = factory.withBytes(new int[]{3, 127, 0, 1, 0, 0, 35, 82});
        ((AbstractThrowableAssert)org.assertj.core.api.Assertions.assertThatThrownBy(() -> this.codec.readInet((Object)source)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid address length: 3 ([127, 0, 1])");
    }

    @Test
    public void should_read_inetaddr_v4() {
        Buffer source = factory.withBytes(new int[]{4, 127, 0, 0, 1});
        InetAddress inetAddr = this.codec.readInetAddr(source);
        Assertions.assertThat((String)inetAddr.getHostAddress()).isEqualTo("127.0.0.1");
    }

    @Test
    public void should_read_inetaddr_v6() {
        Buffer source = factory.heap(17);
        source.writeByte(16);
        source.writeLong(0L);
        source.writeLong(1L);
        InetAddress inetAddr = this.codec.readInetAddr(source);
        Assertions.assertThat((String)inetAddr.getHostAddress()).isEqualTo("0:0:0:0:0:0:0:1");
    }

    @Test
    public void should_fail_to_read_inetaddr_if_length_invalid() {
        Buffer source = factory.withBytes(new int[]{3, 127, 0, 1});
        ((AbstractThrowableAssert)org.assertj.core.api.Assertions.assertThatThrownBy(() -> this.codec.readInetAddr(source)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Invalid address length: 3 ([127, 0, 1])");
    }

    @Test
    public void should_read_bytes() {
        Buffer source = factory.withBytes(new int[]{0, 0, 0, 4, 202, 254, 186, 190});
        ByteBuffer bytes = this.codec.readBytes(source);
        Assertions.assertThat((String)Bytes.toHexString((ByteBuffer)bytes)).isEqualTo("0xcafebabe");
    }

    @Test
    public void should_read_null_bytes() {
        Buffer source = factory.withBytes(new int[]{255, 255, 255, 255});
        Assertions.assertThat((Comparable)this.codec.readBytes(source)).isNull();
    }

    @Test
    public void should_read_short_bytes() {
        Buffer source = factory.withBytes(new int[]{0, 4, 202, 254, 186, 190});
        Assertions.assertThat((String)Bytes.toHexString((byte[])this.codec.readShortBytes(source))).isEqualTo("0xcafebabe");
    }

    @DataProvider
    public static Object[][] bufferTypes() {
        Object[][] objectArray = new Object[3][];
        Object[] objectArray2 = new Object[1];
        objectArray2[0] = () -> ((DseNettyBufferFactory)factory).heap();
        objectArray[0] = objectArray2;
        Object[] objectArray3 = new Object[1];
        objectArray3[0] = () -> ((DseNettyBufferFactory)factory).io();
        objectArray[1] = objectArray3;
        Object[] objectArray4 = new Object[1];
        objectArray4[0] = () -> ((DseNettyBufferFactory)factory).direct();
        objectArray[2] = objectArray4;
        return objectArray;
    }

    @Test
    @UseDataProvider(value="bufferTypes")
    public void should_read_string(Supplier<Buffer> supplier) {
        Buffer source = factory.withBytes(supplier, new int[]{0, 5, 104, 101, 108, 108, 111});
        Assertions.assertThat((String)this.codec.readString(source)).isEqualTo("hello");
    }

    @Test
    public void should_fail_to_read_string_if_not_enough_characters() {
        Buffer source = factory.heap();
        source.writeShort(4);
        ((AbstractThrowableAssert)org.assertj.core.api.Assertions.assertThatThrownBy(() -> this.codec.readString(source)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Not enough bytes to read an UTF-8 serialized string of size 4");
    }

    @Test
    public void should_read_long_string() {
        Buffer source = factory.withBytes(new int[]{0, 0, 0, 5, 104, 101, 108, 108, 111});
        Assertions.assertThat((String)this.codec.readLongString(source)).isEqualTo("hello");
    }

    @Test
    public void should_fail_to_read_long_string_if_not_enough_characters() {
        Buffer source = factory.heap(4, 4);
        source.writeInt(4);
        ((AbstractThrowableAssert)org.assertj.core.api.Assertions.assertThatThrownBy(() -> this.codec.readLongString(source)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Not enough bytes to read an UTF-8 serialized string of size 4");
    }

    @Test
    public void should_write_inet_v4() throws Exception {
        Buffer dest = factory.heap(9);
        InetSocketAddress inet = new InetSocketAddress(InetAddress.getByName("127.0.0.1"), 9042);
        this.codec.writeInet(inet, (Object)dest);
        Assertions.assertThat(dest).containsExactly("0x047f00000100002352");
    }

    @Test
    public void should_write_inet_v6() throws Exception {
        Buffer dest = factory.heap(21);
        InetSocketAddress inet = new InetSocketAddress(InetAddress.getByName("::1"), 9042);
        this.codec.writeInet(inet, (Object)dest);
        Assertions.assertThat(dest).containsExactly("0x100000000000000000000000000000000100002352");
    }

    @Test
    public void should_write_inetaddr_v4() throws Exception {
        Buffer dest = factory.heap(5);
        InetAddress inetAddr = InetAddress.getByName("127.0.0.1");
        this.codec.writeInetAddr(inetAddr, dest);
        Assertions.assertThat(dest).containsExactly("0x047f000001");
    }

    @Test
    public void should_write_inetaddr_v6() throws Exception {
        Buffer dest = factory.heap(17);
        InetAddress inetAddr = InetAddress.getByName("::1");
        this.codec.writeInetAddr(inetAddr, dest);
        Assertions.assertThat(dest).containsExactly("0x1000000000000000000000000000000001");
    }

    @Test
    public void should_write_string() {
        Buffer dest = factory.heap();
        this.codec.writeString("hello", dest);
        Assertions.assertThat(dest).containsExactly("0x000568656c6c6f");
    }

    @Test
    public void should_write_long_string() {
        Buffer dest = factory.heap(9);
        this.codec.writeLongString("hello", dest);
        Assertions.assertThat(dest).containsExactly("0x0000000568656c6c6f");
    }

    @Test
    public void should_write_bytes() {
        Buffer dest = factory.heap(8);
        this.codec.writeBytes(Bytes.fromHexString((String)"0xcafebabe"), dest);
        Assertions.assertThat(dest).containsExactly("0x00000004cafebabe");
    }

    @Test
    public void should_write_short_bytes() {
        Buffer dest = factory.heap(6);
        this.codec.writeShortBytes(new byte[]{-54, -2, -70, -66}, dest);
        Assertions.assertThat(dest).containsExactly("0x0004cafebabe");
    }

    @Test
    public void should_write_null_bytes() {
        Buffer dest = factory.heap(4);
        this.codec.writeBytes((ByteBuffer)null, dest);
        Assertions.assertThat(dest).containsExactly("0xFFFFFFFF");
    }
}

