/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.InsightsSupportVerifier;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Collection;
import java.util.Collections;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class InsightsSupportVerifierTest {
    @Test
    @UseDataProvider(value="dseHostsProvider")
    public void should_detect_DSE_versions_that_supports_insights(Collection<Node> hosts, boolean expected) {
        boolean result = InsightsSupportVerifier.supportsInsights(hosts);
        Assertions.assertThat((boolean)result).isEqualTo(expected);
    }

    @DataProvider
    public static Object[][] dseHostsProvider() {
        Node dse605 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)dse605.getExtras()).thenReturn((Object)ImmutableMap.of((Object)"DSE_VERSION", (Object)Version.parse((String)"6.0.5")));
        Node dse604 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)dse604.getExtras()).thenReturn((Object)ImmutableMap.of((Object)"DSE_VERSION", (Object)Version.parse((String)"6.0.4")));
        Node dse600 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)dse600.getExtras()).thenReturn((Object)ImmutableMap.of((Object)"DSE_VERSION", (Object)Version.parse((String)"6.0.0")));
        Node dse5113 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)dse5113.getExtras()).thenReturn((Object)ImmutableMap.of((Object)"DSE_VERSION", (Object)Version.parse((String)"5.1.13")));
        Node dse500 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)dse500.getExtras()).thenReturn((Object)ImmutableMap.of((Object)"DSE_VERSION", (Object)Version.parse((String)"5.0.0")));
        Node nodeWithoutExtras = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)nodeWithoutExtras.getExtras()).thenReturn(Collections.emptyMap());
        return new Object[][]{{ImmutableList.of((Object)dse605), true}, {ImmutableList.of((Object)dse604), false}, {ImmutableList.of((Object)dse600), false}, {ImmutableList.of((Object)dse5113), true}, {ImmutableList.of((Object)dse500), false}, {ImmutableList.of((Object)dse5113, (Object)dse605), true}, {ImmutableList.of((Object)dse5113, (Object)dse600), false}, {ImmutableList.of((Object)dse500, (Object)dse600), false}, {ImmutableList.of(), false}, {ImmutableList.of((Object)nodeWithoutExtras), false}};
    }
}

