/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.ExecutionProfileMockUtil;
import com.datastax.dse.driver.internal.core.insights.ExecutionProfilesInfoFinder;
import com.datastax.dse.driver.internal.core.insights.schema.LoadBalancingInfo;
import com.datastax.dse.driver.internal.core.insights.schema.SpecificExecutionProfile;
import com.datastax.dse.driver.internal.core.insights.schema.SpeculativeExecutionInfo;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class ExecutionProfilesInfoFinderTest {
    @Test
    public void should_include_info_about_default_profile() {
        DriverExecutionProfile defaultExecutionProfile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        ImmutableMap profiles = ImmutableMap.of((Object)"default", (Object)defaultExecutionProfile);
        InternalDriverContext context = this.mockDriverContextWithProfiles(defaultExecutionProfile, (Map<String, DriverExecutionProfile>)profiles);
        Map executionProfilesInfo = new ExecutionProfilesInfoFinder().getExecutionProfilesInfo(context);
        Assertions.assertThat((Map)executionProfilesInfo).isEqualTo((Object)ImmutableMap.of((Object)"default", (Object)new SpecificExecutionProfile(Integer.valueOf(100), new LoadBalancingInfo("LoadBalancingPolicyImpl", (Map)ImmutableMap.of((Object)"localDataCenter", (Object)"local-dc", (Object)"filterFunction", (Object)true), "com.datastax.oss.driver.internal.core.loadbalancing"), new SpeculativeExecutionInfo("SpeculativeExecutionImpl", (Map)ImmutableMap.of((Object)"maxSpeculativeExecutions", (Object)100, (Object)"delay", (Object)20), "com.datastax.oss.driver.internal.core.specex"), "LOCAL_ONE", "SERIAL", (Map)ImmutableMap.of((Object)"source", (Object)"src-graph"))));
    }

    @Test
    @UseDataProvider(value="executionProfileProvider")
    public void should_include_info_about_default_profile_and_only_difference_for_specific_profile(DriverExecutionProfile nonDefaultExecutionProfile, SpecificExecutionProfile expected) {
        DriverExecutionProfile defaultExecutionProfile = ExecutionProfileMockUtil.mockDefaultExecutionProfile();
        ImmutableMap profiles = ImmutableMap.of((Object)"default", (Object)defaultExecutionProfile, (Object)"non-default", (Object)nonDefaultExecutionProfile);
        InternalDriverContext context = this.mockDriverContextWithProfiles(defaultExecutionProfile, (Map<String, DriverExecutionProfile>)profiles);
        Map executionProfilesInfo = new ExecutionProfilesInfoFinder().getExecutionProfilesInfo(context);
        Assertions.assertThat((Map)executionProfilesInfo).isEqualTo((Object)ImmutableMap.of((Object)"default", (Object)new SpecificExecutionProfile(Integer.valueOf(100), new LoadBalancingInfo("LoadBalancingPolicyImpl", (Map)ImmutableMap.of((Object)"localDataCenter", (Object)"local-dc", (Object)"filterFunction", (Object)true), "com.datastax.oss.driver.internal.core.loadbalancing"), new SpeculativeExecutionInfo("SpeculativeExecutionImpl", (Map)ImmutableMap.of((Object)"maxSpeculativeExecutions", (Object)100, (Object)"delay", (Object)20), "com.datastax.oss.driver.internal.core.specex"), "LOCAL_ONE", "SERIAL", (Map)ImmutableMap.of((Object)"source", (Object)"src-graph")), (Object)"non-default", (Object)expected));
    }

    @DataProvider
    public static Object[][] executionProfileProvider() {
        return new Object[][]{{ExecutionProfileMockUtil.mockNonDefaultRequestTimeoutExecutionProfile(), new SpecificExecutionProfile(Integer.valueOf(50), null, null, null, null, null)}, {ExecutionProfileMockUtil.mockNonDefaultLoadBalancingExecutionProfile(), new SpecificExecutionProfile(null, new LoadBalancingInfo("NonDefaultLoadBalancing", (Map)ImmutableMap.of((Object)"localDataCenter", (Object)"local-dc", (Object)"filterFunction", (Object)true), "com.datastax.oss.driver.internal.core.loadbalancing"), null, null, null, null)}, {ExecutionProfileMockUtil.mockUndefinedLocalDcExecutionProfile(), new SpecificExecutionProfile(null, new LoadBalancingInfo("NonDefaultLoadBalancing", (Map)ImmutableMap.of((Object)"filterFunction", (Object)true), "com.datastax.oss.driver.internal.core.loadbalancing"), null, null, null, null)}, {ExecutionProfileMockUtil.mockNonDefaultSpeculativeExecutionInfo(), new SpecificExecutionProfile(null, null, new SpeculativeExecutionInfo("NonDefaultSpecexPolicy", (Map)ImmutableMap.of((Object)"maxSpeculativeExecutions", (Object)100, (Object)"delay", (Object)20), "com.datastax.oss.driver.internal.core.specex"), null, null, null)}, {ExecutionProfileMockUtil.mockNonDefaultConsistency(), new SpecificExecutionProfile(null, null, null, "ALL", null, null)}, {ExecutionProfileMockUtil.mockNonDefaultSerialConsistency(), new SpecificExecutionProfile(null, null, null, null, "ONE", null)}, {ExecutionProfileMockUtil.mockNonDefaultGraphOptions(), new SpecificExecutionProfile(null, null, null, null, null, (Map)ImmutableMap.of((Object)"source", (Object)"non-default-graph"))}, {ExecutionProfileMockUtil.mockDefaultExecutionProfile(), new SpecificExecutionProfile(null, null, null, null, null, null)}};
    }

    @Test
    public void should_not_include_null_fields_in_json() throws JsonProcessingException {
        SpecificExecutionProfile specificExecutionProfile = new SpecificExecutionProfile(Integer.valueOf(50), null, null, "ONE", null, (Map)ImmutableMap.of((Object)"a", (Object)"b"));
        String result = new ObjectMapper().writeValueAsString((Object)specificExecutionProfile);
        Assertions.assertThat((String)result).isEqualTo("{\"readTimeout\":50,\"consistency\":\"ONE\",\"graphOptions\":{\"a\":\"b\"}}");
    }

    @Test
    public void should_include_empty_execution_profile_if_has_all_nulls() throws JsonProcessingException {
        ImmutableMap executionProfiles = ImmutableMap.of((Object)"p", (Object)new SpecificExecutionProfile(null, null, null, null, null, null));
        String result = new ObjectMapper().writeValueAsString((Object)executionProfiles);
        Assertions.assertThat((String)result).isEqualTo("{\"p\":{}}");
    }

    private InternalDriverContext mockDriverContextWithProfiles(DriverExecutionProfile defaultExecutionProfile, Map<String, DriverExecutionProfile> profiles) {
        InternalDriverContext context = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        DriverConfig driverConfig = (DriverConfig)Mockito.mock(DriverConfig.class);
        Mockito.when((Object)driverConfig.getProfiles()).thenReturn(profiles);
        Mockito.when((Object)driverConfig.getDefaultProfile()).thenReturn((Object)defaultExecutionProfile);
        Mockito.when((Object)context.getConfig()).thenReturn((Object)driverConfig);
        return context;
    }
}

