/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.insights;

import com.datastax.dse.driver.internal.core.insights.DataCentersFinder;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.loadbalancing.NodeDistance;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.datastax.oss.driver.shaded.guava.common.collect.Sets;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Collection;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class DataCentersFinderTest {
    @Test
    @UseDataProvider(value="hostProvider")
    public void should_detect_data_centers(int numberOfRemoteHosts, String dc1, NodeDistance h1Distance, String dc2, NodeDistance h2Distance, Set<String> expected) {
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)executionProfile.getInt((DriverOption)DefaultDriverOption.CONNECTION_POOL_REMOTE_SIZE)).thenReturn((Object)numberOfRemoteHosts);
        Collection<Node> nodes = this.mockNodes(dc1, h1Distance, dc2, h2Distance);
        Set dataCenters = new DataCentersFinder().getDataCenters(nodes, executionProfile);
        Assertions.assertThat((Iterable)dataCenters).isEqualTo((Object)Sets.newHashSet(expected));
    }

    @DataProvider
    public static Object[][] hostProvider() {
        return new Object[][]{{1, "dc1", NodeDistance.LOCAL, "dc2", NodeDistance.REMOTE, Sets.newHashSet((Object[])new String[]{"dc1", "dc2"})}, {1, "dc1", NodeDistance.LOCAL, "dc1", NodeDistance.REMOTE, Sets.newHashSet((Object[])new String[]{"dc1"})}, {0, "dc1", NodeDistance.LOCAL, "dc2", NodeDistance.REMOTE, Sets.newHashSet((Object[])new String[]{"dc1"})}, {0, "dc1", NodeDistance.IGNORED, "dc2", NodeDistance.REMOTE, Sets.newHashSet()}, {1, "dc1", NodeDistance.IGNORED, "dc2", NodeDistance.REMOTE, Sets.newHashSet((Object[])new String[]{"dc2"})}, {1, "dc1", NodeDistance.LOCAL, "dc2", NodeDistance.IGNORED, Sets.newHashSet((Object[])new String[]{"dc1"})}, {0, "dc1", NodeDistance.IGNORED, "dc2", NodeDistance.REMOTE, Sets.newHashSet()}, {0, "dc1", NodeDistance.LOCAL, "dc2", NodeDistance.IGNORED, Sets.newHashSet((Object[])new String[]{"dc1"})}};
    }

    private Collection<Node> mockNodes(String dc1, NodeDistance h1Distance, String dc2, NodeDistance h2Distance) {
        Node n1 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)n1.getDatacenter()).thenReturn((Object)dc1);
        Mockito.when((Object)n1.getDistance()).thenReturn((Object)h1Distance);
        Node n2 = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)n2.getDatacenter()).thenReturn((Object)dc2);
        Mockito.when((Object)n2.getDistance()).thenReturn((Object)h2Distance);
        return ImmutableSet.of((Object)n1, (Object)n2);
    }
}

