/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph.binary;

import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.api.core.graph.BatchGraphStatement;
import com.datastax.dse.driver.api.core.graph.DseGraph;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.type.DseDataTypes;
import com.datastax.dse.driver.api.core.type.codec.DseTypeCodecs;
import com.datastax.dse.driver.internal.core.data.geometry.Distance;
import com.datastax.dse.driver.internal.core.graph.EditDistance;
import com.datastax.dse.driver.internal.core.graph.GraphConversions;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSONUtils;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.oss.driver.TestDataProviders;
import com.datastax.oss.driver.api.core.data.CqlDuration;
import com.datastax.oss.driver.api.core.detach.AttachmentPoint;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.datastax.oss.driver.api.core.type.UserDefinedType;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.codec.registry.MutableCodecRegistry;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.type.UserDefinedTypeBuilder;
import com.datastax.oss.driver.internal.core.type.codec.registry.DefaultCodecRegistry;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableSet;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.apache.tinkerpop.gremlin.structure.io.binary.TypeSerializerRegistry;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public class GraphDataTypesTest {
    private GraphBinaryModule graphBinaryModule;
    @Mock
    private DefaultDriverContext context;
    private static final MutableCodecRegistry CODEC_REGISTRY = new DefaultCodecRegistry("testDseRegistry");
    private static Object[][] graphsonOneDataTypes;
    private static Object[][] graphsonTwoDataTypes;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.context.getCodecRegistry()).thenReturn((Object)CODEC_REGISTRY);
        Mockito.when((Object)this.context.getProtocolVersion()).thenReturn((Object)DseProtocolVersion.DSE_V2);
        TypeSerializerRegistry registry = GraphBinaryModule.createDseTypeSerializerRegistry((DefaultDriverContext)this.context);
        this.graphBinaryModule = new GraphBinaryModule(new GraphBinaryReader(registry), new GraphBinaryWriter(registry));
    }

    @DataProvider
    public static Object[][] graphsonOneDataProvider() {
        return graphsonOneDataTypes;
    }

    @DataProvider
    public static Object[][] graphsonTwoDataProvider() {
        return TestDataProviders.concat(graphsonOneDataTypes, graphsonTwoDataTypes);
    }

    @DataProvider
    public static Object[][] binaryDataProvider() throws UnknownHostException {
        Object[][] binaryDataTypes = new Object[][]{{InetAddress.getLocalHost()}, {ImmutableList.of((Object)ImmutableList.of((Object)1L, (Object)3L), (Object)ImmutableList.of((Object)2L, (Object)4L))}, {ImmutableSet.of((Object)ImmutableSet.of((Object)1, (Object)2, (Object)3))}, {ImmutableMap.of((Object)ImmutableMap.of((Object)"a", (Object)1), (Object)ImmutableMap.of((Object)2, (Object)"b"))}, {DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT, DataTypes.FLOAT}).newValue(new Object[]{1, "2", Float.valueOf(3.41f)})}, {DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT, DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT, DataTypes.DURATION})}).newValue(new Object[]{1, "2", DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT, DataTypes.DURATION}).newValue(new Object[]{"a", CqlDuration.newInstance((int)2, (int)1, (long)0L)})})}, {DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.listOf((DataType)DataTypes.INT), DataTypes.setOf((DataType)DataTypes.FLOAT), DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.BIGINT), DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.DOUBLE)), DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.FLOAT)), DataTypes.listOf((DataType)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT}))}).newValue(new Object[]{ImmutableList.of((Object)4, (Object)8, (Object)22, (Object)34, (Object)37, (Object)59), ImmutableSet.of((Object)Float.valueOf(28.0f), (Object)Float.valueOf(44.0f), (Object)Float.valueOf(59.0f)), ImmutableMap.of((Object)"big10", (Object)2345L), ImmutableList.of((Object)ImmutableList.of((Object)11.1, (Object)33.3), (Object)ImmutableList.of((Object)22.2, (Object)44.4)), ImmutableSet.of((Object)ImmutableSet.of((Object)Float.valueOf(55.5f))), ImmutableList.of((Object)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT}).newValue(new Object[]{3, "three"}))})}, {new UserDefinedTypeBuilder("ks", "udt1").withField("a", DataTypes.INT).withField("b", DataTypes.TEXT).build().newValue(new Object[]{1, "two"})}, {new Distance(Point.fromCoordinates((double)3.4, (double)17.0), 2.5)}, {new EditDistance("xyz", 3)}, {DseGraph.g.V(new Object[0]).has("name", (Object)"marko").asAdmin().getBytecode()}, {GraphConversions.bytecodeToSerialize((GraphStatement)BatchGraphStatement.builder().addTraversal(DseGraph.g.addV("person").property((Object)"name", (Object)"1", new Object[0])).addTraversal(DseGraph.g.addV("person").property((Object)"name", (Object)"1", new Object[0])).build())}};
        return TestDataProviders.concat(GraphDataTypesTest.graphsonTwoDataProvider(), binaryDataTypes);
    }

    @Test
    @UseDataProvider(value="binaryDataProvider")
    public void dataTypesTest(Object value) throws IOException {
        this.verifySerDeBinary(value);
    }

    @Test
    @UseDataProvider(value="graphsonOneDataProvider")
    public void dataTypesTestGraphsonOne(Object value) throws IOException {
        this.verifySerDeGraphson(value, GraphProtocol.GRAPHSON_1_0);
    }

    @Test
    @UseDataProvider(value="graphsonTwoDataProvider")
    public void dataTypesTestGraphsonTwo(Object value) throws IOException {
        this.verifySerDeGraphson(value, GraphProtocol.GRAPHSON_2_0);
    }

    @Test
    public void complexUdtTests() throws IOException {
        UserDefinedType type1 = new UserDefinedTypeBuilder("ks", "udt1").withField("a", DataTypes.INT).withField("b", DataTypes.TEXT).build();
        this.verifySerDeBinary(type1.newValue(new Object[]{1, "2"}));
        TupleType secondNested = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.BIGINT, DataTypes.listOf((DataType)DataTypes.BIGINT)});
        TupleType firstNested = DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.TEXT, secondNested});
        UserDefinedType type2 = new UserDefinedTypeBuilder("ks", "udt2").withField("a", DataTypes.INT).withField("b", DataTypes.TEXT).withField("c", (DataType)type1).withField("mylist", (DataType)DataTypes.listOf((DataType)DataTypes.BIGINT)).withField("mytuple_withlist", (DataType)firstNested).build();
        this.verifySerDeBinary(type2.newValue(new Object[]{1, "2", type1.newValue(new Object[]{3, "4"}), ImmutableList.of((Object)5L), firstNested.newValue(new Object[]{"6", secondNested.newValue(new Object[]{7L, ImmutableList.of((Object)8L)})})}));
        UserDefinedType type3 = new UserDefinedTypeBuilder("ks", "udt3").withField("a", (DataType)DataTypes.listOf((DataType)DataTypes.INT)).withField("b", (DataType)DataTypes.setOf((DataType)DataTypes.FLOAT)).withField("c", (DataType)DataTypes.mapOf((DataType)DataTypes.TEXT, (DataType)DataTypes.BIGINT)).withField("d", (DataType)DataTypes.listOf((DataType)DataTypes.listOf((DataType)DataTypes.DOUBLE))).withField("e", (DataType)DataTypes.setOf((DataType)DataTypes.setOf((DataType)DataTypes.FLOAT))).withField("f", (DataType)DataTypes.listOf((DataType)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT}))).build();
        this.verifySerDeBinary(type3.newValue(new Object[]{ImmutableList.of((Object)1), ImmutableSet.of((Object)Float.valueOf(2.1f)), ImmutableMap.of((Object)"3", (Object)4L), ImmutableList.of((Object)ImmutableList.of((Object)5.1, (Object)6.1), (Object)ImmutableList.of((Object)7.1)), ImmutableSet.of((Object)ImmutableSet.of((Object)Float.valueOf(8.1f)), (Object)ImmutableSet.of((Object)Float.valueOf(9.1f))), ImmutableList.of((Object)DataTypes.tupleOf((DataType[])new DataType[]{DataTypes.INT, DataTypes.TEXT}).newValue(new Object[]{10, "11"}))}));
    }

    @Test
    public void complexTypesAndGeoTests() throws IOException {
        TupleType tuple = DataTypes.tupleOf((DataType[])new DataType[]{DseDataTypes.POINT, DseDataTypes.LINE_STRING, DseDataTypes.POLYGON});
        tuple.attach((AttachmentPoint)this.context);
        this.verifySerDeBinary(tuple.newValue(new Object[]{Point.fromCoordinates((double)3.3, (double)4.4), LineString.fromPoints((Point)Point.fromCoordinates((double)1.0, (double)1.0), (Point)Point.fromCoordinates((double)2.0, (double)2.0), (Point[])new Point[]{Point.fromCoordinates((double)3.0, (double)3.0)}), Polygon.fromPoints((Point)Point.fromCoordinates((double)3.0, (double)4.0), (Point)Point.fromCoordinates((double)5.0, (double)4.0), (Point)Point.fromCoordinates((double)6.0, (double)6.0), (Point[])new Point[0])}));
        UserDefinedType udt = new UserDefinedTypeBuilder("ks", "udt1").withField("a", (DataType)DseDataTypes.POINT).withField("b", (DataType)DseDataTypes.LINE_STRING).withField("c", (DataType)DseDataTypes.POLYGON).build();
        udt.attach((AttachmentPoint)this.context);
        this.verifySerDeBinary(udt.newValue(new Object[]{Point.fromCoordinates((double)3.3, (double)4.4), LineString.fromPoints((Point)Point.fromCoordinates((double)1.0, (double)1.0), (Point)Point.fromCoordinates((double)2.0, (double)2.0), (Point[])new Point[]{Point.fromCoordinates((double)3.0, (double)3.0)}), Polygon.fromPoints((Point)Point.fromCoordinates((double)3.0, (double)4.0), (Point)Point.fromCoordinates((double)5.0, (double)4.0), (Point)Point.fromCoordinates((double)6.0, (double)6.0), (Point[])new Point[0])}));
    }

    private void verifySerDeBinary(Object input) throws IOException {
        Buffer result = this.graphBinaryModule.serialize(input);
        Object deserialized = this.graphBinaryModule.deserialize(result);
        result.release();
        Assertions.assertThat((Object)deserialized).isEqualTo(input);
    }

    private void verifySerDeGraphson(Object input, GraphProtocol protocol) throws IOException {
        ByteBuffer buffer = GraphSONUtils.serializeToByteBuffer((Object)input, (GraphProtocol)protocol);
        Object deserialized = this.deserializeGraphson(buffer, protocol, input.getClass());
        Object expected = input instanceof Set ? ImmutableList.copyOf((Collection)((Set)input)) : input;
        Assertions.assertThat((Object)deserialized).isEqualTo(expected);
    }

    private Object deserializeGraphson(ByteBuffer buffer, GraphProtocol protocol, Class<?> expectedClass) throws IOException {
        ImmutableList data = ImmutableList.of((Object)buffer);
        GraphNode node = GraphSONUtils.createGraphNode((List)data, (GraphProtocol)protocol);
        return node.as(expectedClass);
    }

    static {
        CODEC_REGISTRY.register(new TypeCodec[]{DseTypeCodecs.POINT, DseTypeCodecs.LINE_STRING, DseTypeCodecs.POLYGON});
        graphsonOneDataTypes = new Object[][]{{"~\u2019~^\u00e4\u00e4#123#\u00f6"}, {(byte)34}, {BigDecimal.TEN}, {BigInteger.TEN}, {Boolean.TRUE}, {false}, {23}, {23L}, {23.0}, {Float.valueOf(23.0f)}, {(short)23}, {LocalDate.now(ZoneOffset.UTC)}, {LocalTime.now(ZoneOffset.UTC)}, {UUID.randomUUID()}, {Instant.now()}};
        graphsonTwoDataTypes = new Object[][]{{ImmutableList.of((Object)1L, (Object)2L, (Object)3L)}, {ImmutableSet.of((Object)1L, (Object)2L, (Object)3L)}, {ImmutableMap.of((Object)"a", (Object)1, (Object)"b", (Object)2)}, {Point.fromCoordinates((double)3.3, (double)4.4)}, {LineString.fromPoints((Point)Point.fromCoordinates((double)1.0, (double)1.0), (Point)Point.fromCoordinates((double)2.0, (double)2.0), (Point[])new Point[]{Point.fromCoordinates((double)3.0, (double)3.0)})}, {Polygon.fromPoints((Point)Point.fromCoordinates((double)3.0, (double)4.0), (Point)Point.fromCoordinates((double)5.0, (double)4.0), (Point)Point.fromCoordinates((double)6.0, (double)6.0), (Point[])new Point[0])}};
    }
}

