/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.DseTestDataProviders;
import com.datastax.dse.driver.DseTestFixtures;
import com.datastax.dse.driver.api.core.DseProtocolVersion;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.PagingEnabledOptions;
import com.datastax.dse.driver.internal.core.DseProtocolFeature;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DriverConfig;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.metadata.Metadata;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.internal.core.ProtocolFeature;
import com.datastax.oss.driver.internal.core.ProtocolVersionRegistry;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.metadata.MetadataManager;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForInterfaceTypes;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=DataProviderRunner.class)
public class GraphSupportCheckerTest {
    @UseDataProvider(value="graphPagingEnabledAndDseVersions")
    @Test
    public void should_check_if_paging_is_supported(boolean protocolWithPagingSupport, PagingEnabledOptions statementGraphPagingEnabled, PagingEnabledOptions contextGraphPagingEnabled, List<Version> nodeDseVersions, boolean expected) {
        GraphStatement graphStatement = (GraphStatement)Mockito.mock(GraphStatement.class);
        InternalDriverContext context = this.protocolWithPagingSupport(protocolWithPagingSupport);
        this.statementGraphPagingEnabled(graphStatement, statementGraphPagingEnabled);
        this.contextGraphPagingEnabled(context, contextGraphPagingEnabled);
        this.addNodeWithDseVersion(context, nodeDseVersions);
        boolean pagingEnabled = new GraphSupportChecker().isPagingEnabled(graphStatement, context);
        AssertionsForInterfaceTypes.assertThat((boolean)pagingEnabled).isEqualTo(expected);
    }

    @Test
    public void should_not_support_paging_when_statement_profile_not_present() {
        GraphStatement graphStatement = (GraphStatement)Mockito.mock(GraphStatement.class);
        InternalDriverContext context = this.protocolWithPagingSupport(true);
        this.contextGraphPagingEnabled(context, PagingEnabledOptions.DISABLED);
        this.addNodeWithDseVersion(context, Collections.singletonList(Version.parse((String)"6.8.0")));
        boolean pagingEnabled = new GraphSupportChecker().isPagingEnabled(graphStatement, context);
        AssertionsForInterfaceTypes.assertThat((boolean)pagingEnabled).isEqualTo(false);
    }

    @Test
    public void should_support_paging_when_statement_profile_not_present_but_context_profile_has_paging_enabled() {
        GraphStatement graphStatement = (GraphStatement)Mockito.mock(GraphStatement.class);
        InternalDriverContext context = this.protocolWithPagingSupport(true);
        this.contextGraphPagingEnabled(context, PagingEnabledOptions.ENABLED);
        this.addNodeWithDseVersion(context, Collections.singletonList(Version.parse((String)"6.8.0")));
        boolean pagingEnabled = new GraphSupportChecker().isPagingEnabled(graphStatement, context);
        AssertionsForInterfaceTypes.assertThat((boolean)pagingEnabled).isEqualTo(true);
    }

    @DataProvider
    public static Object[][] graphPagingEnabledAndDseVersions() {
        List<Version> listWithGraphPagingNode = Collections.singletonList(Version.parse((String)"6.8.0"));
        List<Version> listWithoutGraphPagingNode = Collections.singletonList(Version.parse((String)"6.7.0"));
        List<Object> listWithNull = Collections.singletonList(null);
        List<Version> listWithTwoNodesOneNotSupporting = Arrays.asList(Version.parse((String)"6.7.0"), Version.parse((String)"6.8.0"));
        return new Object[][]{{false, PagingEnabledOptions.ENABLED, PagingEnabledOptions.ENABLED, listWithGraphPagingNode, true}, {true, PagingEnabledOptions.ENABLED, PagingEnabledOptions.ENABLED, listWithoutGraphPagingNode, true}, {true, PagingEnabledOptions.ENABLED, PagingEnabledOptions.DISABLED, listWithGraphPagingNode, true}, {true, PagingEnabledOptions.ENABLED, PagingEnabledOptions.ENABLED, listWithGraphPagingNode, true}, {true, PagingEnabledOptions.ENABLED, PagingEnabledOptions.ENABLED, listWithNull, true}, {true, PagingEnabledOptions.ENABLED, PagingEnabledOptions.ENABLED, listWithTwoNodesOneNotSupporting, true}, {true, PagingEnabledOptions.DISABLED, PagingEnabledOptions.ENABLED, listWithGraphPagingNode, false}, {true, PagingEnabledOptions.DISABLED, PagingEnabledOptions.AUTO, listWithGraphPagingNode, false}, {true, PagingEnabledOptions.DISABLED, PagingEnabledOptions.DISABLED, listWithGraphPagingNode, false}, {true, PagingEnabledOptions.AUTO, PagingEnabledOptions.AUTO, listWithGraphPagingNode, true}, {true, PagingEnabledOptions.AUTO, PagingEnabledOptions.DISABLED, listWithGraphPagingNode, true}, {false, PagingEnabledOptions.AUTO, PagingEnabledOptions.AUTO, listWithGraphPagingNode, false}, {true, PagingEnabledOptions.AUTO, PagingEnabledOptions.AUTO, listWithTwoNodesOneNotSupporting, false}, {true, PagingEnabledOptions.AUTO, PagingEnabledOptions.AUTO, listWithNull, false}};
    }

    private void addNodeWithDseVersion(InternalDriverContext context, List<Version> dseVersions) {
        MetadataManager manager = (MetadataManager)Mockito.mock(MetadataManager.class);
        Mockito.when((Object)context.getMetadataManager()).thenReturn((Object)manager);
        Metadata metadata = (Metadata)Mockito.mock(Metadata.class);
        Mockito.when((Object)manager.getMetadata()).thenReturn((Object)metadata);
        HashMap<UUID, Node> nodes = new HashMap<UUID, Node>();
        for (Version v : dseVersions) {
            Node node = (Node)Mockito.mock(Node.class);
            HashMap<String, Version> extras = new HashMap<String, Version>();
            extras.put("DSE_VERSION", v);
            Mockito.when((Object)node.getExtras()).thenReturn(extras);
            nodes.put(UUID.randomUUID(), node);
        }
        Mockito.when((Object)metadata.getNodes()).thenReturn(nodes);
    }

    private void contextGraphPagingEnabled(InternalDriverContext context, PagingEnabledOptions option) {
        DriverExecutionProfile driverExecutionProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)driverExecutionProfile.getString((DriverOption)DseDriverOption.GRAPH_PAGING_ENABLED)).thenReturn((Object)option.name());
        DriverConfig config = (DriverConfig)Mockito.mock(DriverConfig.class);
        Mockito.when((Object)context.getConfig()).thenReturn((Object)config);
        Mockito.when((Object)config.getDefaultProfile()).thenReturn((Object)driverExecutionProfile);
    }

    private InternalDriverContext protocolWithPagingSupport(boolean pagingSupport) {
        InternalDriverContext context = (InternalDriverContext)Mockito.mock(InternalDriverContext.class);
        Mockito.when((Object)context.getProtocolVersion()).thenReturn((Object)DseProtocolVersion.DSE_V2);
        ProtocolVersionRegistry protocolVersionRegistry = (ProtocolVersionRegistry)Mockito.mock(ProtocolVersionRegistry.class);
        Mockito.when((Object)protocolVersionRegistry.supports((ProtocolVersion)DseProtocolVersion.DSE_V2, (ProtocolFeature)DseProtocolFeature.CONTINUOUS_PAGING)).thenReturn((Object)pagingSupport);
        Mockito.when((Object)context.getProtocolVersionRegistry()).thenReturn((Object)protocolVersionRegistry);
        return context;
    }

    private void statementGraphPagingEnabled(GraphStatement graphStatement, PagingEnabledOptions option) {
        DriverExecutionProfile driverExecutionProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)driverExecutionProfile.getString((DriverOption)DseDriverOption.GRAPH_PAGING_ENABLED)).thenReturn((Object)option.name());
        Mockito.when((Object)graphStatement.getExecutionProfile()).thenReturn((Object)driverExecutionProfile);
    }

    @Test
    @UseDataProvider(value="dseVersionsAndGraphProtocols")
    public void should_determine_default_graph_protocol_from_dse_version(Version[] dseVersions, GraphProtocol expectedProtocol) {
        DefaultDriverContext context = DseTestFixtures.mockNodesInMetadataWithVersions((DefaultDriverContext)Mockito.mock(DefaultDriverContext.class), true, dseVersions);
        GraphProtocol graphProtocol = new GraphSupportChecker().getDefaultGraphProtocol((InternalDriverContext)context);
        AssertionsForInterfaceTypes.assertThat((Comparable)graphProtocol).isEqualTo((Object)expectedProtocol);
    }

    @Test
    @UseDataProvider(value="dseVersionsAndGraphProtocols")
    public void should_determine_default_graph_protocol_from_dse_version_with_null_versions(Version[] dseVersions, GraphProtocol expectedProtocol) {
        DefaultDriverContext context = DseTestFixtures.mockNodesInMetadataWithVersions((DefaultDriverContext)Mockito.mock(DefaultDriverContext.class), false, dseVersions);
        GraphProtocol graphProtocol = new GraphSupportChecker().getDefaultGraphProtocol((InternalDriverContext)context);
        AssertionsForInterfaceTypes.assertThat((Comparable)graphProtocol).isEqualTo((Object)expectedProtocol);
    }

    @DataProvider
    public static Object[][] dseVersionsAndGraphProtocols() {
        return new Object[][]{{new Version[]{Version.parse((String)"5.0.3")}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{Version.parse((String)"6.0.1")}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{Version.parse((String)"6.7.4")}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{Version.parse((String)"6.8.0")}, GraphProtocol.GRAPH_BINARY_1_0}, {new Version[]{Version.parse((String)"7.0.0")}, GraphProtocol.GRAPH_BINARY_1_0}, {new Version[]{Version.parse((String)"5.0.3"), Version.parse((String)"6.8.0")}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{Version.parse((String)"6.7.4"), Version.parse((String)"6.8.0")}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{Version.parse((String)"6.8.0"), Version.parse((String)"6.7.4")}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{Version.parse((String)"6.8.0"), Version.parse((String)"7.0.0")}, GraphProtocol.GRAPH_BINARY_1_0}, {new Version[]{Version.parse((String)"6.7.4"), Version.parse((String)"6.7.4")}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{Version.parse((String)"6.8.0"), Version.parse((String)"6.8.0")}, GraphProtocol.GRAPH_BINARY_1_0}, {null, GraphProtocol.GRAPHSON_2_0}, {new Version[]{null}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{null, Version.parse((String)"6.8.0")}, GraphProtocol.GRAPHSON_2_0}, {new Version[]{Version.parse((String)"6.8.0"), Version.parse((String)"7.0.0"), null}, GraphProtocol.GRAPHSON_2_0}};
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_pickup_graph_protocol_from_statement(GraphProtocol graphProtocol) {
        GraphStatement graphStatement = (GraphStatement)Mockito.mock(GraphStatement.class);
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)graphStatement.getSubProtocol()).thenReturn((Object)graphProtocol.toInternalCode());
        GraphProtocol inferredProtocol = new GraphSupportChecker().inferGraphProtocol(graphStatement, executionProfile, (InternalDriverContext)Mockito.mock(InternalDriverContext.class));
        AssertionsForInterfaceTypes.assertThat((Comparable)inferredProtocol).isEqualTo((Object)graphProtocol);
        Mockito.verifyZeroInteractions((Object[])new Object[]{executionProfile});
    }

    @Test
    @UseDataProvider(value="graphProtocolStringsAndDseVersions")
    public void should_pickup_graph_protocol_and_parse_from_string_config(String stringConfig, Version dseVersion) {
        GraphStatement graphStatement = (GraphStatement)Mockito.mock(GraphStatement.class);
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        Mockito.when((Object)executionProfile.isDefined((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL)).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)executionProfile.getString((DriverOption)ArgumentMatchers.eq((Object)DseDriverOption.GRAPH_SUB_PROTOCOL))).thenReturn((Object)stringConfig);
        DefaultDriverContext context = DseTestFixtures.mockNodesInMetadataWithVersions((DefaultDriverContext)Mockito.mock(DefaultDriverContext.class), true, dseVersion);
        GraphProtocol inferredProtocol = new GraphSupportChecker().inferGraphProtocol(graphStatement, executionProfile, (InternalDriverContext)context);
        AssertionsForInterfaceTypes.assertThat((String)inferredProtocol.toInternalCode()).isEqualTo(stringConfig);
    }

    @DataProvider
    public static Object[][] graphProtocolStringsAndDseVersions() {
        return new Object[][]{{"graphson-1.0", Version.parse((String)"6.7.0")}, {"graphson-1.0", Version.parse((String)"6.8.0")}, {"graphson-2.0", Version.parse((String)"6.7.0")}, {"graphson-2.0", Version.parse((String)"6.8.0")}, {"graph-binary-1.0", Version.parse((String)"6.7.0")}, {"graph-binary-1.0", Version.parse((String)"6.8.0")}};
    }

    @Test
    @UseDataProvider(value="dseVersions6")
    public void should_use_correct_default_protocol_when_parsing(Version dseVersion) {
        GraphStatement graphStatement = (GraphStatement)Mockito.mock(GraphStatement.class);
        DriverExecutionProfile executionProfile = (DriverExecutionProfile)Mockito.mock(DriverExecutionProfile.class);
        DefaultDriverContext context = DseTestFixtures.mockNodesInMetadataWithVersions((DefaultDriverContext)Mockito.mock(DefaultDriverContext.class), true, dseVersion);
        GraphProtocol inferredProtocol = new GraphSupportChecker().inferGraphProtocol(graphStatement, executionProfile, (InternalDriverContext)context);
        AssertionsForInterfaceTypes.assertThat((Comparable)inferredProtocol).isEqualTo((Object)(dseVersion.compareTo(Version.parse((String)"6.8.0")) < 0 ? GraphProtocol.GRAPHSON_2_0 : GraphProtocol.GRAPH_BINARY_1_0));
    }

    @DataProvider
    public static Object[][] dseVersions6() {
        return new Object[][]{{Version.parse((String)"6.7.0")}, {Version.parse((String)"6.8.0")}};
    }

    @Test
    public void should_fail_if_graph_protocol_used_is_invalid() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GraphProtocol.fromString((String)"invalid")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Graph protocol used [\"invalid\"] unknown. Possible values are: [ \"graphson-1.0\", \"graphson-2.0\", \"graph-binary-1.0\"]");
    }

    @Test
    public void should_fail_if_graph_protocol_used_is_graphson_3() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> GraphProtocol.fromString((String)"graphson-3.0")).isInstanceOf(IllegalArgumentException.class)).hasMessage("Graph protocol used [\"graphson-3.0\"] unknown. Possible values are: [ \"graphson-1.0\", \"graphson-2.0\", \"graph-binary-1.0\"]");
    }
}

