/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphResultSet;
import com.datastax.dse.driver.internal.core.graph.GraphResultSetTestBase;
import com.datastax.dse.driver.internal.core.graph.GraphResultSets;
import com.datastax.dse.driver.internal.core.graph.MultiPageGraphResultSet;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import java.util.Iterator;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class GraphResultSetsTest
extends GraphResultSetTestBase {
    @Test
    public void should_create_result_set_from_single_page() {
        AsyncGraphResultSet page1 = this.mockPage(false, 0, 1, 2);
        GraphResultSet resultSet = GraphResultSets.toSync((AsyncGraphResultSet)page1);
        Assertions.assertThat((Object)resultSet.getRequestExecutionInfo()).isSameAs((Object)page1.getRequestExecutionInfo());
        Iterator iterator = resultSet.iterator();
        this.assertNextRow(iterator, 0);
        this.assertNextRow(iterator, 1);
        this.assertNextRow(iterator, 2);
        Assertions.assertThat((boolean)iterator.hasNext()).isFalse();
    }

    @Test
    public void should_create_result_set_from_multiple_pages() {
        AsyncGraphResultSet page1 = this.mockPage(true, 0, 1, 2);
        AsyncGraphResultSet page2 = this.mockPage(true, 3, 4, 5);
        AsyncGraphResultSet page3 = this.mockPage(false, 6, 7, 8);
        GraphResultSetsTest.complete(page1.fetchNextPage(), page2);
        GraphResultSetsTest.complete(page2.fetchNextPage(), page3);
        GraphResultSet resultSet = GraphResultSets.toSync((AsyncGraphResultSet)page1);
        Assertions.assertThat((boolean)resultSet.iterator().hasNext()).isTrue();
        Assertions.assertThat((Object)resultSet.getRequestExecutionInfo()).isSameAs((Object)page1.getRequestExecutionInfo());
        Assertions.assertThat((List)((MultiPageGraphResultSet)resultSet).getRequestExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getRequestExecutionInfo()});
        Iterator iterator = resultSet.iterator();
        this.assertNextRow(iterator, 0);
        this.assertNextRow(iterator, 1);
        this.assertNextRow(iterator, 2);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Object)resultSet.getRequestExecutionInfo()).isEqualTo((Object)page2.getRequestExecutionInfo());
        Assertions.assertThat((List)((MultiPageGraphResultSet)resultSet).getRequestExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getRequestExecutionInfo(), page2.getRequestExecutionInfo()});
        this.assertNextRow(iterator, 3);
        this.assertNextRow(iterator, 4);
        this.assertNextRow(iterator, 5);
        Assertions.assertThat((boolean)iterator.hasNext()).isTrue();
        Assertions.assertThat((Object)resultSet.getRequestExecutionInfo()).isEqualTo((Object)page3.getRequestExecutionInfo());
        Assertions.assertThat((List)((MultiPageGraphResultSet)resultSet).getRequestExecutionInfos()).containsExactly((Object[])new ExecutionInfo[]{page1.getRequestExecutionInfo(), page2.getRequestExecutionInfo(), page3.getRequestExecutionInfo()});
        this.assertNextRow(iterator, 6);
        this.assertNextRow(iterator, 7);
        this.assertNextRow(iterator, 8);
    }
}

