/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.DseTestDataProviders;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.graph.BatchGraphStatement;
import com.datastax.dse.driver.api.core.graph.DseGraph;
import com.datastax.dse.driver.api.core.graph.FluentGraphStatement;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatementBuilder;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.dse.driver.internal.core.graph.GraphConversions;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphRequestAsyncProcessor;
import com.datastax.dse.driver.internal.core.graph.GraphRequestHandlerTestHarness;
import com.datastax.dse.driver.internal.core.graph.GraphRequestSyncProcessor;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.dse.driver.internal.core.graph.GraphTestUtils;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.dse.protocol.internal.request.RawBytesQuery;
import com.datastax.dse.protocol.internal.request.query.DseQueryOptions;
import com.datastax.oss.driver.api.core.ConsistencyLevel;
import com.datastax.oss.driver.api.core.DefaultConsistencyLevel;
import com.datastax.oss.driver.api.core.Version;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.context.DriverContext;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.tracker.RequestTracker;
import com.datastax.oss.driver.api.core.type.codec.TypeCodecs;
import com.datastax.oss.driver.api.core.uuid.Uuids;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.Conversions;
import com.datastax.oss.driver.internal.core.cql.PoolBehavior;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableMap;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.request.Query;
import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.tinkerpop.gremlin.process.traversal.dsl.graph.GraphTraversal;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=DataProviderRunner.class)
public class GraphRequestHandlerTest {
    private static final Pattern LOG_PREFIX_PER_REQUEST = Pattern.compile("test-graph\\|\\d+");
    @Mock
    DefaultNode node;
    @Mock
    protected NodeMetricUpdater nodeMetricUpdater1;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.node.getMetricUpdater()).thenReturn((Object)this.nodeMetricUpdater1);
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_create_query_message_from_script_statement(GraphProtocol graphProtocol) throws IOException {
        GraphRequestHandlerTestHarness harness = GraphRequestHandlerTestHarness.builder().build();
        ScriptGraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery").setQueryParam("p1", (Object)1L).setQueryParam("p2", (Object)Uuids.random());
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile((Request)graphStatement, (DriverContext)harness.getContext());
        Message m = GraphConversions.createMessageFromGraphStatement((GraphStatement)graphStatement, (GraphProtocol)graphProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        Assertions.assertThat((Object)m).isInstanceOf(Query.class);
        Query q = (Query)m;
        Assertions.assertThat((String)q.query).isEqualTo("mockQuery");
        Assertions.assertThat((List)q.options.positionalValues).containsExactly((Object[])new ByteBuffer[]{GraphTestUtils.serialize(graphStatement.getQueryParams(), graphProtocol, module)});
        Assertions.assertThat((Map)q.options.namedValues).isEmpty();
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_create_query_message_from_fluent_statement(GraphProtocol graphProtocol) throws IOException {
        GraphRequestHandlerTestHarness harness = GraphRequestHandlerTestHarness.builder().build();
        GraphTraversal traversalTest = DseGraph.g.V(new Object[0]).has("person", "name", (Object)"marko").has("p1", (Object)1L).has("p2", (Object)Uuids.random());
        FluentGraphStatement graphStatement = FluentGraphStatement.newInstance((GraphTraversal)traversalTest);
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile((Request)graphStatement, (DriverContext)harness.getContext());
        Message m = GraphConversions.createMessageFromGraphStatement((GraphStatement)graphStatement, (GraphProtocol)graphProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        Map createdCustomPayload = GraphConversions.createCustomPayload((GraphStatement)graphStatement, (GraphProtocol)graphProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        Assertions.assertThat((Object)m).isInstanceOf(RawBytesQuery.class);
        this.testQueryRequestAndPayloadContents((RawBytesQuery)m, createdCustomPayload, GraphConversions.bytecodeToSerialize((GraphStatement)graphStatement), graphProtocol, module);
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_create_query_message_from_batch_statement(GraphProtocol graphProtocol) throws IOException {
        GraphRequestHandlerTestHarness harness = GraphRequestHandlerTestHarness.builder().build();
        ImmutableList traversalsTest = ImmutableList.of((Object)DseGraph.g.addV("person").property((Object)"p1", (Object)Float.valueOf(2.3f), new Object[0]).property((Object)"p2", (Object)LocalDateTime.now(ZoneOffset.UTC), new Object[0]), (Object)DseGraph.g.addV("software").property((Object)"p3", (Object)new BigInteger("123456789123456789123456789123456789"), new Object[0]).property((Object)"p4", (Object)ImmutableList.of((Object)Point.fromCoordinates((double)30.4, (double)25.63746284)), new Object[0]));
        BatchGraphStatement graphStatement = BatchGraphStatement.builder().addTraversals((Iterable)traversalsTest).build();
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile((Request)graphStatement, (DriverContext)harness.getContext());
        Message m = GraphConversions.createMessageFromGraphStatement((GraphStatement)graphStatement, (GraphProtocol)graphProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        Map createdCustomPayload = GraphConversions.createCustomPayload((GraphStatement)graphStatement, (GraphProtocol)graphProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        Assertions.assertThat((Object)m).isInstanceOf(RawBytesQuery.class);
        this.testQueryRequestAndPayloadContents((RawBytesQuery)m, createdCustomPayload, GraphConversions.bytecodeToSerialize((GraphStatement)graphStatement), graphProtocol, module);
    }

    private void testQueryRequestAndPayloadContents(RawBytesQuery q, Map<String, ByteBuffer> customPayload, Object traversalTest, GraphProtocol graphProtocol, GraphBinaryModule module) throws IOException {
        if (graphProtocol.isGraphBinary()) {
            Assertions.assertThat((byte[])q.query).isEqualTo((Object)GraphConversions.EMPTY_STRING_QUERY);
            Assertions.assertThat(customPayload).containsKey((Object)"graph-binary-query");
            ByteBuffer encodedQuery = customPayload.get("graph-binary-query");
            Assertions.assertThat((Comparable)encodedQuery).isNotNull();
            Assertions.assertThat((Comparable)encodedQuery).isEqualTo((Object)GraphTestUtils.serialize(traversalTest, graphProtocol, module));
        } else {
            Assertions.assertThat((byte[])q.query).isEqualTo((Object)GraphTestUtils.serialize(traversalTest, graphProtocol, module).array());
            Assertions.assertThat(customPayload).doesNotContainKey((Object)"graph-binary-query");
        }
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_set_correct_query_options_from_graph_statement(GraphProtocol subProtocol) throws IOException {
        GraphRequestHandlerTestHarness harness = GraphRequestHandlerTestHarness.builder().build();
        ScriptGraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery").setQueryParam("name", (Object)"value");
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile((Request)graphStatement, (DriverContext)harness.getContext());
        Message m = GraphConversions.createMessageFromGraphStatement((GraphStatement)graphStatement, (GraphProtocol)subProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        Query query = (Query)m;
        DseQueryOptions options = (DseQueryOptions)query.options;
        Assertions.assertThat((int)options.consistency).isEqualTo(DefaultConsistencyLevel.valueOf((String)executionProfile.getString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY)).getProtocolCode());
        Assertions.assertThat((long)options.defaultTimestamp).isEqualTo(Long.MIN_VALUE);
        Assertions.assertThat((List)options.positionalValues).isEqualTo((Object)ImmutableList.of((Object)GraphTestUtils.serialize(ImmutableMap.of((Object)"name", (Object)"value"), subProtocol, module)));
        m = GraphConversions.createMessageFromGraphStatement((GraphStatement)graphStatement.setTimestamp(2L), (GraphProtocol)subProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        query = (Query)m;
        options = (DseQueryOptions)query.options;
        Assertions.assertThat((long)options.defaultTimestamp).isEqualTo(2L);
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_create_payload_from_config_options(GraphProtocol subProtocol) {
        GraphRequestHandlerTestHarness harness = GraphRequestHandlerTestHarness.builder().build();
        GraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery").setExecutionProfileName("test-graph");
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile((Request)graphStatement, (DriverContext)harness.getContext());
        Map requestPayload = GraphConversions.createCustomPayload((GraphStatement)graphStatement, (GraphProtocol)subProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile)).getString((DriverOption)DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile)).getString((DriverOption)DseDriverOption.GRAPH_NAME, null);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile)).getBoolean((DriverOption)DseDriverOption.GRAPH_IS_SYSTEM_QUERY, false);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile)).getDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile)).getString((DriverOption)DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, null);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile)).getString((DriverOption)DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, null);
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-source"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"a", harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-results"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)subProtocol.toInternalCode(), harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-name"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"mockGraph", harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-language"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"gremlin-groovy", harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("request-timeout"))).isEqualTo((Object)TypeCodecs.BIGINT.encode(Long.valueOf(2L), harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-read-consistency"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"LOCAL_TWO", harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-write-consistency"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"LOCAL_THREE", harness.getContext().getProtocolVersion()));
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_create_payload_from_statement_options(GraphProtocol subProtocol) {
        GraphRequestHandlerTestHarness harness = GraphRequestHandlerTestHarness.builder().build();
        ScriptGraphStatement graphStatement = ((ScriptGraphStatementBuilder)((ScriptGraphStatementBuilder)((ScriptGraphStatementBuilder)((ScriptGraphStatementBuilder)((ScriptGraphStatementBuilder)ScriptGraphStatement.builder((String)"mockQuery").setGraphName("mockGraph")).setTraversalSource("a")).setTimeout(Duration.ofMillis(2L))).setReadConsistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.TWO)).setWriteConsistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.THREE)).setSystemQuery(Boolean.valueOf(false)).build();
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile((Request)graphStatement, (DriverContext)harness.getContext());
        Map requestPayload = GraphConversions.createCustomPayload((GraphStatement)graphStatement, (GraphProtocol)subProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile, (VerificationMode)Mockito.never())).getString((DriverOption)DseDriverOption.GRAPH_TRAVERSAL_SOURCE, null);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile, (VerificationMode)Mockito.never())).getString((DriverOption)DseDriverOption.GRAPH_NAME, null);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile, (VerificationMode)Mockito.never())).getBoolean((DriverOption)DseDriverOption.GRAPH_IS_SYSTEM_QUERY, false);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile, (VerificationMode)Mockito.never())).getDuration((DriverOption)DseDriverOption.GRAPH_TIMEOUT, Duration.ZERO);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile, (VerificationMode)Mockito.never())).getString((DriverOption)DseDriverOption.GRAPH_READ_CONSISTENCY_LEVEL, null);
        ((DriverExecutionProfile)Mockito.verify((Object)executionProfile, (VerificationMode)Mockito.never())).getString((DriverOption)DseDriverOption.GRAPH_WRITE_CONSISTENCY_LEVEL, null);
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-source"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"a", harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-results"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)subProtocol.toInternalCode(), harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-name"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"mockGraph", harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-language"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"gremlin-groovy", harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("request-timeout"))).isEqualTo((Object)TypeCodecs.BIGINT.encode(Long.valueOf(2L), harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-read-consistency"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"TWO", harness.getContext().getProtocolVersion()));
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-write-consistency"))).isEqualTo((Object)TypeCodecs.TEXT.encode((Object)"THREE", harness.getContext().getProtocolVersion()));
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_not_set_graph_name_on_system_queries(GraphProtocol subProtocol) {
        GraphRequestHandlerTestHarness harness = GraphRequestHandlerTestHarness.builder().build();
        ScriptGraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery").setSystemQuery(Boolean.valueOf(true));
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile((Request)graphStatement, (DriverContext)harness.getContext());
        Map requestPayload = GraphConversions.createCustomPayload((GraphStatement)graphStatement, (GraphProtocol)subProtocol, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-name"))).isNull();
        Assertions.assertThat((Comparable)((ByteBuffer)requestPayload.get("graph-source"))).isNull();
    }

    @Test
    @UseDataProvider(value="supportedGraphProtocolsWithDseVersions")
    public void should_return_results_for_statements(GraphProtocol graphProtocol, Version dseVersion) throws IOException {
        GraphRequestHandlerTestHarness.Builder builder = GraphRequestHandlerTestHarness.builder().withGraphProtocolForTestConfig(graphProtocol).withDseVersionInMetadata(dseVersion);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node);
        GraphRequestHandlerTestHarness harness = builder.build();
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        node1Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf(GraphTestUtils.singleGraphRow(graphProtocol, module)));
        GraphSupportChecker graphSupportChecker = (GraphSupportChecker)Mockito.mock(GraphSupportChecker.class);
        Mockito.when((Object)graphSupportChecker.isPagingEnabled((GraphStatement)ArgumentMatchers.any(), (InternalDriverContext)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)graphSupportChecker.inferGraphProtocol((GraphStatement)ArgumentMatchers.any(), (DriverExecutionProfile)ArgumentMatchers.any(), (InternalDriverContext)ArgumentMatchers.any())).thenReturn((Object)graphProtocol);
        GraphRequestAsyncProcessor p = (GraphRequestAsyncProcessor)Mockito.spy((Object)new GraphRequestAsyncProcessor(harness.getContext(), graphSupportChecker));
        Mockito.when((Object)p.getGraphBinaryModule()).thenReturn((Object)module);
        GraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery").setExecutionProfileName("test-graph");
        GraphResultSet grs = new GraphRequestSyncProcessor(p).process(graphStatement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test-graph");
        List nodes = grs.all();
        Assertions.assertThat((int)nodes.size()).isEqualTo(1);
        GraphNode graphNode = (GraphNode)nodes.get(0);
        Assertions.assertThat((boolean)graphNode.isVertex()).isTrue();
        Vertex vRead = graphNode.asVertex();
        Assertions.assertThat((String)vRead.label()).isEqualTo("person");
        Assertions.assertThat((Object)vRead.id()).isEqualTo((Object)1);
        if (!graphProtocol.isGraphBinary()) {
            Assertions.assertThat((Object)vRead.property("name").id()).isEqualTo((Object)11);
            Assertions.assertThat((Object)vRead.property("name").value()).isEqualTo((Object)"marko");
        }
    }

    @DataProvider
    public static Object[][] supportedGraphProtocolsWithDseVersions() {
        return new Object[][]{{GraphProtocol.GRAPHSON_1_0, Version.parse((String)"6.7.0")}, {GraphProtocol.GRAPHSON_1_0, Version.parse((String)"6.8.0")}, {GraphProtocol.GRAPHSON_2_0, Version.parse((String)"6.7.0")}, {GraphProtocol.GRAPHSON_2_0, Version.parse((String)"6.8.0")}, {GraphProtocol.GRAPH_BINARY_1_0, Version.parse((String)"6.7.0")}, {GraphProtocol.GRAPH_BINARY_1_0, Version.parse((String)"6.8.0")}};
    }

    @Test
    @UseDataProvider(value="dseVersionsWithDefaultGraphProtocol")
    public void should_invoke_request_tracker_and_update_metrics(GraphProtocol graphProtocol, Version dseVersion) throws IOException {
        Mockito.when((Object)this.nodeMetricUpdater1.isEnabled((Object)DseNodeMetric.GRAPH_MESSAGES, "default")).thenReturn((Object)true);
        GraphRequestHandlerTestHarness.Builder builder = GraphRequestHandlerTestHarness.builder().withGraphProtocolForTestConfig(graphProtocol).withDseVersionInMetadata(dseVersion);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node);
        GraphRequestHandlerTestHarness harness = builder.build();
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        GraphSupportChecker graphSupportChecker = (GraphSupportChecker)Mockito.mock(GraphSupportChecker.class);
        Mockito.when((Object)graphSupportChecker.isPagingEnabled((GraphStatement)ArgumentMatchers.any(), (InternalDriverContext)ArgumentMatchers.any())).thenReturn((Object)false);
        Mockito.when((Object)graphSupportChecker.inferGraphProtocol((GraphStatement)ArgumentMatchers.any(), (DriverExecutionProfile)ArgumentMatchers.any(), (InternalDriverContext)ArgumentMatchers.any())).thenReturn((Object)graphProtocol);
        GraphRequestAsyncProcessor p = (GraphRequestAsyncProcessor)Mockito.spy((Object)new GraphRequestAsyncProcessor(harness.getContext(), graphSupportChecker));
        Mockito.when((Object)p.getGraphBinaryModule()).thenReturn((Object)module);
        RequestTracker requestTracker = (RequestTracker)Mockito.mock(RequestTracker.class);
        Mockito.when((Object)harness.getContext().getRequestTracker()).thenReturn((Object)requestTracker);
        ScriptGraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery");
        node1Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf(GraphTestUtils.singleGraphRow(graphProtocol, module)));
        GraphResultSet grs = new GraphRequestSyncProcessor(new GraphRequestAsyncProcessor(harness.getContext(), graphSupportChecker)).process((GraphStatement)graphStatement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test-graph");
        List nodes = grs.all();
        Assertions.assertThat((int)nodes.size()).isEqualTo(1);
        GraphNode graphNode = (GraphNode)nodes.get(0);
        Assertions.assertThat((boolean)graphNode.isVertex()).isTrue();
        Vertex actual = graphNode.asVertex();
        Assertions.assertThat((String)actual.label()).isEqualTo("person");
        Assertions.assertThat((Object)actual.id()).isEqualTo((Object)1);
        if (!graphProtocol.isGraphBinary()) {
            Assertions.assertThat((Object)actual.property("name").id()).isEqualTo((Object)11);
            Assertions.assertThat((Object)actual.property("name").value()).isEqualTo((Object)"marko");
        }
        ((RequestTracker)Mockito.verify((Object)requestTracker)).onSuccess((Request)ArgumentMatchers.eq((Object)graphStatement), ArgumentMatchers.anyLong(), (DriverExecutionProfile)ArgumentMatchers.any(DriverExecutionProfile.class), (Node)ArgumentMatchers.eq((Object)this.node), ArgumentMatchers.matches((Pattern)LOG_PREFIX_PER_REQUEST));
        ((RequestTracker)Mockito.verify((Object)requestTracker)).onNodeSuccess((Request)ArgumentMatchers.eq((Object)graphStatement), ArgumentMatchers.anyLong(), (DriverExecutionProfile)ArgumentMatchers.any(DriverExecutionProfile.class), (Node)ArgumentMatchers.eq((Object)this.node), ArgumentMatchers.matches((Pattern)LOG_PREFIX_PER_REQUEST));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{requestTracker});
        ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).isEnabled((Object)DseNodeMetric.GRAPH_MESSAGES, "default");
        ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DseNodeMetric.GRAPH_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
        ((SessionMetricUpdater)Mockito.verify((Object)harness.getSession().getMetricUpdater())).isEnabled((Object)DseSessionMetric.GRAPH_REQUESTS, "default");
        ((SessionMetricUpdater)Mockito.verify((Object)harness.getSession().getMetricUpdater())).updateTimer((Object)((SessionMetric)ArgumentMatchers.eq((Object)DseSessionMetric.GRAPH_REQUESTS)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{harness.getSession().getMetricUpdater()});
    }

    @Test
    public void should_honor_statement_consistency_level() {
        GraphRequestHandlerTestHarness harness = GraphRequestHandlerTestHarness.builder().build();
        ScriptGraphStatement graphStatement = ((ScriptGraphStatementBuilder)ScriptGraphStatement.builder((String)"mockScript").setConsistencyLevel((ConsistencyLevel)DefaultConsistencyLevel.THREE)).build();
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
        DriverExecutionProfile executionProfile = Conversions.resolveExecutionProfile((Request)graphStatement, (DriverContext)harness.getContext());
        Message m = GraphConversions.createMessageFromGraphStatement((GraphStatement)graphStatement, (GraphProtocol)GraphProtocol.GRAPH_BINARY_1_0, (DriverExecutionProfile)executionProfile, (InternalDriverContext)harness.getContext(), (GraphBinaryModule)module);
        Assertions.assertThat((Object)m).isInstanceOf(Query.class);
        Query q = (Query)m;
        Assertions.assertThat((int)q.options.consistency).isEqualTo(DefaultConsistencyLevel.THREE.getProtocolCode());
    }

    @DataProvider
    public static Object[][] dseVersionsWithDefaultGraphProtocol() {
        return new Object[][]{{GraphProtocol.GRAPHSON_2_0, Version.parse((String)"6.7.0")}, {GraphProtocol.GRAPH_BINARY_1_0, Version.parse((String)"6.8.0")}};
    }
}

