/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.DseTestDataProviders;
import com.datastax.dse.driver.api.core.config.DseDriverOption;
import com.datastax.dse.driver.api.core.graph.AsyncGraphResultSet;
import com.datastax.dse.driver.api.core.graph.GraphNode;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.graph.ScriptGraphStatement;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.api.core.metrics.DseSessionMetric;
import com.datastax.dse.driver.internal.core.graph.ContinuousGraphRequestHandler;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphRequestHandlerTestHarness;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.dse.driver.internal.core.graph.GraphTestUtils;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.oss.driver.api.core.DriverTimeoutException;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.metrics.SessionMetric;
import com.datastax.oss.driver.internal.core.context.DefaultDriverContext;
import com.datastax.oss.driver.internal.core.cql.PoolBehavior;
import com.datastax.oss.driver.internal.core.cql.RequestHandlerTestHarness;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.metrics.SessionMetricUpdater;
import com.datastax.oss.driver.internal.core.util.concurrent.CapturingTimer;
import com.datastax.oss.driver.internal.core.util.concurrent.CompletableFutures;
import com.datastax.oss.protocol.internal.Message;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import io.netty.util.Timeout;
import java.io.IOException;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.IterableAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=DataProviderRunner.class)
public class ContinuousGraphRequestHandlerTest {
    @Mock
    DefaultDriverContext mockContext;
    @Mock
    DefaultNode node;
    @Mock
    NodeMetricUpdater nodeMetricUpdater1;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.node.getMetricUpdater()).thenReturn((Object)this.nodeMetricUpdater1);
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="supportedGraphProtocols")
    public void should_return_paged_results(GraphProtocol graphProtocol) throws IOException {
        String profileName = "test-graph";
        Mockito.when((Object)this.nodeMetricUpdater1.isEnabled((Object)DseNodeMetric.GRAPH_MESSAGES, profileName)).thenReturn((Object)true);
        GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(this.mockContext);
        GraphRequestHandlerTestHarness.Builder builder = GraphRequestHandlerTestHarness.builder().withGraphProtocolForTestConfig(graphProtocol);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node);
        try (GraphRequestHandlerTestHarness harness = builder.build();){
            GraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery").setExecutionProfileName(profileName);
            ContinuousGraphRequestHandler handler = new ContinuousGraphRequestHandler(graphStatement, harness.getSession(), ((RequestHandlerTestHarness)harness).getContext(), "test", module, new GraphSupportChecker());
            CompletionStage page1Future = handler.handle();
            node1Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf((Message)GraphTestUtils.tenGraphRows(graphProtocol, module, 1, false)));
            com.datastax.oss.driver.Assertions.assertThatStage(page1Future).isSuccess(page1 -> {
                com.datastax.oss.driver.Assertions.assertThat((boolean)page1.hasMorePages()).isTrue();
                ((IterableAssert)com.datastax.oss.driver.Assertions.assertThat((Iterable)page1.currentPage()).hasSize(10)).allMatch(GraphNode::isVertex);
                ExecutionInfo executionInfo = page1.getRequestExecutionInfo();
                com.datastax.oss.driver.Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getErrors()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
            });
            AsyncGraphResultSet page12 = (AsyncGraphResultSet)CompletableFutures.getCompleted((CompletionStage)page1Future);
            CompletionStage page2Future = page12.fetchNextPage();
            node1Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf((Message)GraphTestUtils.tenGraphRows(graphProtocol, module, 2, true)));
            com.datastax.oss.driver.Assertions.assertThatStage(page2Future).isSuccess(page2 -> {
                com.datastax.oss.driver.Assertions.assertThat((boolean)page2.hasMorePages()).isFalse();
                ((IterableAssert)com.datastax.oss.driver.Assertions.assertThat((Iterable)page2.currentPage()).hasSize(10)).allMatch(GraphNode::isVertex);
                ExecutionInfo executionInfo = page2.getRequestExecutionInfo();
                com.datastax.oss.driver.Assertions.assertThat((Object)executionInfo.getCoordinator()).isEqualTo((Object)this.node);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getErrors()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((Map)executionInfo.getIncomingPayload()).isEmpty();
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSpeculativeExecutionCount()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((int)executionInfo.getSuccessfulExecutionIndex()).isEqualTo(0);
                com.datastax.oss.driver.Assertions.assertThat((List)executionInfo.getWarnings()).isEmpty();
            });
            this.validateMetrics(profileName, harness);
        }
    }

    @Test
    public void should_honor_default_timeout() throws Exception {
        GraphBinaryModule binaryModule = GraphTestUtils.createGraphBinaryModule(this.mockContext);
        Duration defaultTimeout = Duration.ofSeconds(1L);
        GraphRequestHandlerTestHarness.Builder builder = GraphRequestHandlerTestHarness.builder().withGraphTimeout(defaultTimeout);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node);
        try (RequestHandlerTestHarness harness = ((RequestHandlerTestHarness.Builder)builder).build();){
            DriverExecutionProfile profile = harness.getContext().getConfig().getDefaultProfile();
            Mockito.when((Object)profile.isDefined((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL)).thenReturn((Object)true);
            Mockito.when((Object)profile.getString((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL)).thenReturn((Object)GraphProtocol.GRAPH_BINARY_1_0.toInternalCode());
            ScriptGraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery");
            ContinuousGraphRequestHandler handler = new ContinuousGraphRequestHandler((GraphStatement)graphStatement, harness.getSession(), harness.getContext(), "test", binaryModule, new GraphSupportChecker());
            CompletionStage page1Future = handler.handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout globalTimeout = harness.nextScheduledTimeout();
            com.datastax.oss.driver.Assertions.assertThat((long)globalTimeout.getDelay(TimeUnit.NANOSECONDS)).isEqualTo(defaultTimeout.toNanos());
            globalTimeout.task().run((Timeout)globalTimeout);
            com.datastax.oss.driver.Assertions.assertThat(page1Future.toCompletableFuture()).isCompletedExceptionally();
            Assertions.assertThatThrownBy(() -> {
                AsyncGraphResultSet cfr_ignored_0 = (AsyncGraphResultSet)page1Future.toCompletableFuture().get();
            }).hasRootCauseExactlyInstanceOf(DriverTimeoutException.class).hasMessageContaining("Query timed out after " + defaultTimeout);
        }
    }

    @Test
    public void should_honor_statement_timeout() throws Exception {
        GraphBinaryModule binaryModule = GraphTestUtils.createGraphBinaryModule(this.mockContext);
        Duration defaultTimeout = Duration.ofSeconds(1L);
        Duration statementTimeout = Duration.ofSeconds(2L);
        GraphRequestHandlerTestHarness.Builder builder = GraphRequestHandlerTestHarness.builder().withGraphTimeout(defaultTimeout);
        PoolBehavior node1Behavior = builder.customBehavior((Node)this.node);
        try (RequestHandlerTestHarness harness = ((RequestHandlerTestHarness.Builder)builder).build();){
            DriverExecutionProfile profile = harness.getContext().getConfig().getDefaultProfile();
            Mockito.when((Object)profile.isDefined((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL)).thenReturn((Object)true);
            Mockito.when((Object)profile.getString((DriverOption)DseDriverOption.GRAPH_SUB_PROTOCOL)).thenReturn((Object)GraphProtocol.GRAPH_BINARY_1_0.toInternalCode());
            GraphStatement graphStatement = ScriptGraphStatement.newInstance((String)"mockQuery").setTimeout(statementTimeout);
            ContinuousGraphRequestHandler handler = new ContinuousGraphRequestHandler(graphStatement, harness.getSession(), harness.getContext(), "test", binaryModule, new GraphSupportChecker());
            CompletionStage page1Future = handler.handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout globalTimeout = harness.nextScheduledTimeout();
            com.datastax.oss.driver.Assertions.assertThat((long)globalTimeout.getDelay(TimeUnit.NANOSECONDS)).isEqualTo(statementTimeout.toNanos());
            globalTimeout.task().run((Timeout)globalTimeout);
            com.datastax.oss.driver.Assertions.assertThat(page1Future.toCompletableFuture()).isCompletedExceptionally();
            Assertions.assertThatThrownBy(() -> {
                AsyncGraphResultSet cfr_ignored_0 = (AsyncGraphResultSet)page1Future.toCompletableFuture().get();
            }).hasRootCauseExactlyInstanceOf(DriverTimeoutException.class).hasMessageContaining("Query timed out after " + statementTimeout);
        }
    }

    private void validateMetrics(String profileName, RequestHandlerTestHarness harness) {
        ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1, (VerificationMode)Mockito.times((int)1))).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DseNodeMetric.GRAPH_MESSAGES)), (String)ArgumentMatchers.eq((Object)profileName), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
        ((SessionMetricUpdater)Mockito.verify((Object)harness.getSession().getMetricUpdater())).updateTimer((Object)((SessionMetric)ArgumentMatchers.eq((Object)DseSessionMetric.GRAPH_REQUESTS)), (String)ArgumentMatchers.eq(null), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{harness.getSession().getMetricUpdater()});
    }
}

