/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.graph;

import com.datastax.dse.driver.DseTestDataProviders;
import com.datastax.dse.driver.api.core.graph.GraphStatement;
import com.datastax.dse.driver.api.core.metrics.DseNodeMetric;
import com.datastax.dse.driver.internal.core.graph.ContinuousGraphRequestHandler;
import com.datastax.dse.driver.internal.core.graph.GraphProtocol;
import com.datastax.dse.driver.internal.core.graph.GraphRequestHandlerTestHarness;
import com.datastax.dse.driver.internal.core.graph.GraphSupportChecker;
import com.datastax.dse.driver.internal.core.graph.GraphTestUtils;
import com.datastax.dse.driver.internal.core.graph.binary.GraphBinaryModule;
import com.datastax.oss.driver.Assertions;
import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.NoNodeAvailableException;
import com.datastax.oss.driver.api.core.config.DriverExecutionProfile;
import com.datastax.oss.driver.api.core.metadata.Node;
import com.datastax.oss.driver.api.core.metrics.DefaultNodeMetric;
import com.datastax.oss.driver.api.core.metrics.NodeMetric;
import com.datastax.oss.driver.api.core.servererrors.BootstrappingException;
import com.datastax.oss.driver.api.core.session.Request;
import com.datastax.oss.driver.api.core.specex.SpeculativeExecutionPolicy;
import com.datastax.oss.driver.internal.core.context.InternalDriverContext;
import com.datastax.oss.driver.internal.core.cql.PoolBehavior;
import com.datastax.oss.driver.internal.core.metadata.DefaultNode;
import com.datastax.oss.driver.internal.core.metrics.NodeMetricUpdater;
import com.datastax.oss.driver.internal.core.util.concurrent.CapturingTimer;
import com.datastax.oss.protocol.internal.Message;
import com.datastax.oss.protocol.internal.response.Error;
import com.tngtech.java.junit.dataprovider.DataProviderRunner;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import io.netty.util.Timeout;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.AbstractThrowableAssert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

@RunWith(value=DataProviderRunner.class)
public class ContinuousGraphRequestHandlerSpeculativeExecutionTest {
    @Mock
    DefaultNode node1;
    @Mock
    DefaultNode node2;
    @Mock
    DefaultNode node3;
    @Mock
    NodeMetricUpdater nodeMetricUpdater1;
    @Mock
    NodeMetricUpdater nodeMetricUpdater2;
    @Mock
    NodeMetricUpdater nodeMetricUpdater3;
    @Mock
    GraphSupportChecker graphSupportChecker;

    @Before
    public void setup() {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.node1.getMetricUpdater()).thenReturn((Object)this.nodeMetricUpdater1);
        Mockito.when((Object)this.node2.getMetricUpdater()).thenReturn((Object)this.nodeMetricUpdater2);
        Mockito.when((Object)this.node3.getMetricUpdater()).thenReturn((Object)this.nodeMetricUpdater3);
        Mockito.when((Object)this.nodeMetricUpdater1.isEnabled((Object)((NodeMetric)ArgumentMatchers.any(NodeMetric.class)), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.nodeMetricUpdater2.isEnabled((Object)((NodeMetric)ArgumentMatchers.any(NodeMetric.class)), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.nodeMetricUpdater3.isEnabled((Object)((NodeMetric)ArgumentMatchers.any(NodeMetric.class)), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.graphSupportChecker.inferGraphProtocol((GraphStatement)ArgumentMatchers.any(), (DriverExecutionProfile)ArgumentMatchers.any(), (InternalDriverContext)ArgumentMatchers.any())).thenReturn((Object)GraphProtocol.GRAPH_BINARY_1_0);
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="nonIdempotentGraphConfig")
    public void should_not_schedule_speculative_executions_if_not_idempotent(boolean defaultIdempotence, GraphStatement<?> statement) {
        GraphRequestHandlerTestHarness.Builder harnessBuilder = GraphRequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        try (GraphRequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
            new ContinuousGraphRequestHandler(statement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test", module, this.graphSupportChecker).handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            Assertions.assertThat((Object)harness.nextScheduledTimeout()).isNull();
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{speculativeExecutionPolicy});
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
        }
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="idempotentGraphConfig")
    public void should_schedule_speculative_executions(boolean defaultIdempotence, GraphStatement<?> statement) throws Exception {
        GraphRequestHandlerTestHarness.Builder harnessBuilder = GraphRequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior((Node)this.node3);
        try (GraphRequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            long secondExecutionDelay = 200L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)2))).thenReturn((Object)secondExecutionDelay);
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)3))).thenReturn((Object)-1L);
            GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
            new ContinuousGraphRequestHandler(statement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test", module, this.graphSupportChecker).handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).incrementCounter((Object)DefaultNodeMetric.SPECULATIVE_EXECUTIONS, "default");
            node2Behavior.verifyWrite();
            node2Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout speculativeExecution2 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution2.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(secondExecutionDelay);
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater2});
            speculativeExecution2.task().run((Timeout)speculativeExecution2);
            ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater2)).incrementCounter((Object)DefaultNodeMetric.SPECULATIVE_EXECUTIONS, "default");
            node3Behavior.verifyWrite();
            node3Behavior.setWriteSuccess();
            Assertions.assertThat((Object)harness.nextScheduledTimeout()).isNull();
        }
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="idempotentGraphConfig")
    public void should_not_start_execution_if_result_complete(boolean defaultIdempotence, GraphStatement<?> statement) throws Exception {
        GraphRequestHandlerTestHarness.Builder harnessBuilder = GraphRequestHandlerTestHarness.builder().withGraphTimeout(Duration.ofSeconds(10L)).withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        try (GraphRequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
            ContinuousGraphRequestHandler requestHandler = new ContinuousGraphRequestHandler(statement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test", module, this.graphSupportChecker);
            CompletionStage resultSetFuture = requestHandler.handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout globalTimeout = harness.nextScheduledTimeout();
            Assertions.assertThat((long)globalTimeout.getDelay(TimeUnit.SECONDS)).isEqualTo(10L);
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            node1Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf(GraphTestUtils.singleGraphRow(GraphProtocol.GRAPH_BINARY_1_0, module)));
            Assertions.assertThatStage(resultSetFuture).isSuccess();
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node2Behavior.verifyNoWrite();
            ((NodeMetricUpdater)Mockito.verify((Object)this.nodeMetricUpdater1)).updateTimer((Object)((NodeMetric)ArgumentMatchers.eq((Object)DseNodeMetric.GRAPH_MESSAGES)), (String)ArgumentMatchers.eq((Object)"default"), ArgumentMatchers.anyLong(), (TimeUnit)((Object)ArgumentMatchers.eq((Object)((Object)TimeUnit.NANOSECONDS))));
            Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.nodeMetricUpdater1});
        }
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="idempotentGraphConfig")
    public void should_fail_if_no_nodes(boolean defaultIdempotence, GraphStatement<?> statement) {
        GraphRequestHandlerTestHarness.Builder harnessBuilder = GraphRequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        try (GraphRequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
            CompletionStage resultSetFuture = new ContinuousGraphRequestHandler(statement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test", module, this.graphSupportChecker).handle();
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                AbstractThrowableAssert cfr_ignored_0 = (AbstractThrowableAssert)Assertions.assertThat((Throwable)error).isInstanceOf(NoNodeAvailableException.class);
            });
        }
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="idempotentGraphConfig")
    public void should_fail_if_no_more_nodes_and_initial_execution_is_last(boolean defaultIdempotence, GraphStatement<?> statement) throws Exception {
        GraphRequestHandlerTestHarness.Builder harnessBuilder = GraphRequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        harnessBuilder.withResponse((Node)this.node2, GraphTestUtils.defaultDseFrameOf((Message)new Error(4098, "mock message")));
        try (GraphRequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
            CompletionStage resultSetFuture = new ContinuousGraphRequestHandler(statement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test", module, this.graphSupportChecker).handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node1Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf((Message)new Error(4098, "mock message")));
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(AllNodesFailedException.class);
                Map nodeErrors = ((AllNodesFailedException)error).getAllErrors();
                Assertions.assertThat((Map)nodeErrors).containsOnlyKeys((Object[])new Node[]{this.node1, this.node2});
                Assertions.assertThat((Throwable)((Throwable)((List)nodeErrors.get(this.node1)).get(0))).isInstanceOf(BootstrappingException.class);
                Assertions.assertThat((Throwable)((Throwable)((List)nodeErrors.get(this.node2)).get(0))).isInstanceOf(BootstrappingException.class);
            });
        }
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="idempotentGraphConfig")
    public void should_fail_if_no_more_nodes_and_speculative_execution_is_last(boolean defaultIdempotence, GraphStatement<?> statement) throws Exception {
        GraphRequestHandlerTestHarness.Builder harnessBuilder = GraphRequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        try (GraphRequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
            CompletionStage resultSetFuture = new ContinuousGraphRequestHandler(statement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test", module, this.graphSupportChecker).handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node1Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf((Message)new Error(4098, "mock message")));
            node2Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf((Message)new Error(4098, "mock message")));
            Assertions.assertThatStage(resultSetFuture).isFailed(error -> {
                Assertions.assertThat((Throwable)error).isInstanceOf(AllNodesFailedException.class);
                Map nodeErrors = ((AllNodesFailedException)error).getAllErrors();
                Assertions.assertThat((Map)nodeErrors).containsOnlyKeys((Object[])new Node[]{this.node1, this.node2});
                Assertions.assertThat((Throwable)((Throwable)((List)nodeErrors.get(this.node1)).get(0))).isInstanceOf(BootstrappingException.class);
                Assertions.assertThat((Throwable)((Throwable)((List)nodeErrors.get(this.node2)).get(0))).isInstanceOf(BootstrappingException.class);
            });
        }
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="idempotentGraphConfig")
    public void should_retry_in_speculative_executions(boolean defaultIdempotence, GraphStatement<?> statement) throws Exception {
        GraphRequestHandlerTestHarness.Builder harnessBuilder = GraphRequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior((Node)this.node3);
        try (GraphRequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
            CompletionStage resultSetFuture = new ContinuousGraphRequestHandler(statement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test", module, this.graphSupportChecker).handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node2Behavior.verifyWrite();
            node2Behavior.setWriteSuccess();
            node2Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf((Message)new Error(4098, "mock message")));
            node3Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf(GraphTestUtils.singleGraphRow(GraphProtocol.GRAPH_BINARY_1_0, module)));
            Assertions.assertThatStage(resultSetFuture).isSuccess();
            node1Behavior.verifyCancellation();
        }
    }

    @Test
    @UseDataProvider(location={DseTestDataProviders.class}, value="idempotentGraphConfig")
    public void should_stop_retrying_other_executions_if_result_complete(boolean defaultIdempotence, GraphStatement<?> statement) throws Exception {
        GraphRequestHandlerTestHarness.Builder harnessBuilder = GraphRequestHandlerTestHarness.builder().withDefaultIdempotence(defaultIdempotence);
        PoolBehavior node1Behavior = harnessBuilder.customBehavior((Node)this.node1);
        PoolBehavior node2Behavior = harnessBuilder.customBehavior((Node)this.node2);
        PoolBehavior node3Behavior = harnessBuilder.customBehavior((Node)this.node3);
        try (GraphRequestHandlerTestHarness harness = harnessBuilder.build();){
            SpeculativeExecutionPolicy speculativeExecutionPolicy = harness.getContext().getSpeculativeExecutionPolicy("default");
            long firstExecutionDelay = 100L;
            Mockito.when((Object)speculativeExecutionPolicy.nextExecution((Node)ArgumentMatchers.any(Node.class), (CqlIdentifier)ArgumentMatchers.eq(null), (Request)ArgumentMatchers.eq(statement), ArgumentMatchers.eq((int)1))).thenReturn((Object)firstExecutionDelay);
            GraphBinaryModule module = GraphTestUtils.createGraphBinaryModule(harness.getContext());
            CompletionStage resultSetFuture = new ContinuousGraphRequestHandler(statement, harness.getSession(), (InternalDriverContext)harness.getContext(), "test", module, this.graphSupportChecker).handle();
            node1Behavior.verifyWrite();
            node1Behavior.setWriteSuccess();
            CapturingTimer.CapturedTimeout speculativeExecution1 = harness.nextScheduledTimeout();
            Assertions.assertThat((long)speculativeExecution1.getDelay(TimeUnit.MILLISECONDS)).isEqualTo(firstExecutionDelay);
            speculativeExecution1.task().run((Timeout)speculativeExecution1);
            node2Behavior.verifyWrite();
            node2Behavior.setWriteSuccess();
            node1Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf(GraphTestUtils.singleGraphRow(GraphProtocol.GRAPH_BINARY_1_0, module)));
            Assertions.assertThatStage(resultSetFuture).isSuccess();
            node2Behavior.setResponseSuccess(GraphTestUtils.defaultDseFrameOf((Message)new Error(4098, "mock message")));
            node3Behavior.verifyNoWrite();
        }
    }
}

