/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.dse.driver.internal.core.data.geometry;

import com.datastax.dse.driver.api.core.data.geometry.Geometry;
import com.datastax.dse.driver.api.core.data.geometry.LineString;
import com.datastax.dse.driver.api.core.data.geometry.Point;
import com.datastax.dse.driver.api.core.data.geometry.Polygon;
import com.datastax.dse.driver.internal.core.data.geometry.DefaultPolygon;
import com.datastax.dse.driver.internal.core.data.geometry.SerializationUtils;
import com.esri.core.geometry.ogc.OGCPolygon;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.junit.Test;

public class DefaultPolygonTest {
    private Polygon polygon = Polygon.fromPoints((Point)Point.fromCoordinates((double)30.0, (double)10.0), (Point)Point.fromCoordinates((double)10.0, (double)20.0), (Point)Point.fromCoordinates((double)20.0, (double)40.0), (Point[])new Point[]{Point.fromCoordinates((double)40.0, (double)40.0)});
    private String wkt = "POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))";
    private String json = "{\"type\":\"Polygon\",\"coordinates\":[[[30.0,10.0],[10.0,20.0],[20.0,40.0],[40.0,40.0],[30.0,10.0]]]}";

    @Test
    public void should_parse_valid_well_known_text() {
        Assertions.assertThat((Object)Polygon.fromWellKnownText((String)this.wkt)).isEqualTo((Object)this.polygon);
    }

    @Test
    public void should_fail_to_parse_invalid_well_known_text() {
        this.assertInvalidWkt("polygon(())");
        this.assertInvalidWkt("polygon((30 10 1, 40 40 1, 20 40 1, 10 20 1, 30 10 1))");
        this.assertInvalidWkt("polygon((0 0, 1 1, 0 1, 1 0, 0 0))");
        this.assertInvalidWkt("polygon123((30 10, 40 40, 20 40, 10 20, 30 10))");
    }

    @Test
    public void should_convert_to_well_known_binary() {
        ByteBuffer actual = this.polygon.asWellKnownBinary();
        ByteBuffer expected = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        expected.position(0);
        expected.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        expected.putInt(3);
        expected.putInt(1);
        expected.putInt(5);
        expected.putDouble(30.0);
        expected.putDouble(10.0);
        expected.putDouble(40.0);
        expected.putDouble(40.0);
        expected.putDouble(20.0);
        expected.putDouble(40.0);
        expected.putDouble(10.0);
        expected.putDouble(20.0);
        expected.putDouble(30.0);
        expected.putDouble(10.0);
        expected.flip();
        Assertions.assertThat((Comparable)actual).isEqualTo((Object)expected);
    }

    @Test
    public void should_load_from_well_known_binary() {
        ByteBuffer bb = ByteBuffer.allocate(1024).order(ByteOrder.nativeOrder());
        bb.position(0);
        bb.put((byte)(ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? 1 : 0));
        bb.putInt(3);
        bb.putInt(1);
        bb.putInt(5);
        bb.putDouble(30.0);
        bb.putDouble(10.0);
        bb.putDouble(40.0);
        bb.putDouble(40.0);
        bb.putDouble(20.0);
        bb.putDouble(40.0);
        bb.putDouble(10.0);
        bb.putDouble(20.0);
        bb.putDouble(30.0);
        bb.putDouble(10.0);
        bb.flip();
        Assertions.assertThat((Object)Polygon.fromWellKnownBinary((ByteBuffer)bb)).isEqualTo((Object)this.polygon);
    }

    @Test
    public void should_parse_valid_geo_json() {
        Assertions.assertThat((Object)Polygon.fromGeoJson((String)this.json)).isEqualTo((Object)this.polygon);
    }

    @Test
    public void should_convert_to_geo_json() {
        Assertions.assertThat((String)this.polygon.asGeoJson()).isEqualTo(this.json);
    }

    @Test
    public void should_convert_to_ogc_polygon() {
        Assertions.assertThat((Object)((DefaultPolygon)this.polygon).getOgcGeometry()).isInstanceOf(OGCPolygon.class);
    }

    @Test
    public void should_produce_same_hashCode_for_equal_objects() {
        Polygon polygon1 = Polygon.fromPoints((Point)Point.fromCoordinates((double)30.0, (double)10.0), (Point)Point.fromCoordinates((double)10.0, (double)20.0), (Point)Point.fromCoordinates((double)20.0, (double)40.0), (Point[])new Point[]{Point.fromCoordinates((double)40.0, (double)40.0)});
        Polygon polygon2 = Polygon.fromWellKnownText((String)this.wkt);
        Assertions.assertThat((Object)polygon1).isEqualTo((Object)polygon2);
        Assertions.assertThat((int)polygon1.hashCode()).isEqualTo(polygon2.hashCode());
    }

    @Test
    public void should_build_with_constructor_without_checking_orientation() {
        Polygon polygon = Polygon.fromPoints((Point)Point.fromCoordinates((double)5.0, (double)0.0), (Point)Point.fromCoordinates((double)5.0, (double)3.0), (Point)Point.fromCoordinates((double)0.0, (double)3.0), (Point[])new Point[]{Point.fromCoordinates((double)0.0, (double)0.0)});
        Assertions.assertThat((String)polygon.asWellKnownText()).isEqualTo("POLYGON ((0 0, 5 0, 5 3, 0 3, 0 0))");
    }

    @Test
    public void should_build_complex_polygon_with_builder() {
        Polygon polygon = Polygon.builder().addRing(Point.fromCoordinates((double)0.0, (double)0.0), Point.fromCoordinates((double)0.0, (double)3.0), Point.fromCoordinates((double)5.0, (double)3.0), new Point[]{Point.fromCoordinates((double)5.0, (double)0.0)}).addRing(Point.fromCoordinates((double)1.0, (double)1.0), Point.fromCoordinates((double)1.0, (double)2.0), Point.fromCoordinates((double)2.0, (double)2.0), new Point[]{Point.fromCoordinates((double)2.0, (double)1.0)}).addRing(Point.fromCoordinates((double)3.0, (double)1.0), Point.fromCoordinates((double)3.0, (double)2.0), Point.fromCoordinates((double)4.0, (double)2.0), new Point[]{Point.fromCoordinates((double)4.0, (double)1.0)}).build();
        Assertions.assertThat((String)polygon.asWellKnownText()).isEqualTo("POLYGON ((0 0, 5 0, 5 3, 0 3, 0 0), (1 1, 1 2, 2 2, 2 1, 1 1), (3 1, 3 2, 4 2, 4 1, 3 1))");
    }

    @Test
    public void should_expose_rings() {
        Assertions.assertThat((List)this.polygon.getExteriorRing()).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)30.0, (double)10.0), Point.fromCoordinates((double)10.0, (double)20.0), Point.fromCoordinates((double)20.0, (double)40.0), Point.fromCoordinates((double)40.0, (double)40.0)});
        Assertions.assertThat((boolean)this.polygon.getInteriorRings().isEmpty()).isTrue();
        Polygon fromWkt = Polygon.fromWellKnownText((String)this.wkt);
        Assertions.assertThat((List)fromWkt.getExteriorRing()).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)30.0, (double)10.0), Point.fromCoordinates((double)10.0, (double)20.0), Point.fromCoordinates((double)20.0, (double)40.0), Point.fromCoordinates((double)40.0, (double)40.0)});
        Assertions.assertThat((boolean)fromWkt.getInteriorRings().isEmpty()).isTrue();
        Polygon complex = Polygon.builder().addRing(Point.fromCoordinates((double)0.0, (double)0.0), Point.fromCoordinates((double)0.0, (double)3.0), Point.fromCoordinates((double)5.0, (double)3.0), new Point[]{Point.fromCoordinates((double)5.0, (double)0.0)}).addRing(Point.fromCoordinates((double)1.0, (double)1.0), Point.fromCoordinates((double)1.0, (double)2.0), Point.fromCoordinates((double)2.0, (double)2.0), new Point[]{Point.fromCoordinates((double)2.0, (double)1.0)}).addRing(Point.fromCoordinates((double)3.0, (double)1.0), Point.fromCoordinates((double)3.0, (double)2.0), Point.fromCoordinates((double)4.0, (double)2.0), new Point[]{Point.fromCoordinates((double)4.0, (double)1.0)}).build();
        Assertions.assertThat((List)complex.getExteriorRing()).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)0.0, (double)0.0), Point.fromCoordinates((double)0.0, (double)3.0), Point.fromCoordinates((double)5.0, (double)3.0), Point.fromCoordinates((double)5.0, (double)0.0)});
        Assertions.assertThat((List)complex.getInteriorRings()).hasSize(2);
        Assertions.assertThat((List)((List)complex.getInteriorRings().get(0))).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)1.0, (double)1.0), Point.fromCoordinates((double)1.0, (double)2.0), Point.fromCoordinates((double)2.0, (double)2.0), Point.fromCoordinates((double)2.0, (double)1.0)});
        Assertions.assertThat((List)((List)complex.getInteriorRings().get(1))).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)3.0, (double)1.0), Point.fromCoordinates((double)3.0, (double)2.0), Point.fromCoordinates((double)4.0, (double)2.0), Point.fromCoordinates((double)4.0, (double)1.0)});
        Polygon complexFromWkt = Polygon.fromWellKnownText((String)"POLYGON ((0 0, 5 0, 5 3, 0 3, 0 0), (1 1, 1 2, 2 2, 2 1, 1 1), (3 1, 3 2, 4 2, 4 1, 3 1))");
        Assertions.assertThat((List)complexFromWkt.getExteriorRing()).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)0.0, (double)0.0), Point.fromCoordinates((double)0.0, (double)3.0), Point.fromCoordinates((double)5.0, (double)3.0), Point.fromCoordinates((double)5.0, (double)0.0)});
        Assertions.assertThat((List)complexFromWkt.getInteriorRings()).hasSize(2);
        Assertions.assertThat((List)((List)complexFromWkt.getInteriorRings().get(0))).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)1.0, (double)1.0), Point.fromCoordinates((double)1.0, (double)2.0), Point.fromCoordinates((double)2.0, (double)2.0), Point.fromCoordinates((double)2.0, (double)1.0)});
        Assertions.assertThat((List)((List)complexFromWkt.getInteriorRings().get(1))).containsOnly((Object[])new Point[]{Point.fromCoordinates((double)3.0, (double)1.0), Point.fromCoordinates((double)3.0, (double)2.0), Point.fromCoordinates((double)4.0, (double)2.0), Point.fromCoordinates((double)4.0, (double)1.0)});
    }

    @Test
    public void should_encode_and_decode() throws Exception {
        Assertions.assertThat((Object)SerializationUtils.serializeAndDeserialize((Geometry)this.polygon)).isEqualTo((Object)this.polygon);
    }

    @Test
    public void should_contain_self() {
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)this.polygon)).isTrue();
    }

    @Test
    public void should_not_contain_point_or_linestring_on_exterior_ring() {
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Point.fromCoordinates((double)30.0, (double)10.0))).isFalse();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Point.fromCoordinates((double)30.0, (double)40.0))).isFalse();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)LineString.fromPoints((Point)Point.fromCoordinates((double)35.0, (double)40.0), (Point)Point.fromCoordinates((double)25.0, (double)40.0), (Point[])new Point[0]))).isFalse();
    }

    @Test
    public void should_contain_interior_shape() {
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Point.fromCoordinates((double)20.0, (double)20.0))).isTrue();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)LineString.fromPoints((Point)Point.fromCoordinates((double)20.0, (double)20.0), (Point)Point.fromCoordinates((double)30.0, (double)20.0), (Point[])new Point[0]))).isTrue();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Polygon.fromPoints((Point)Point.fromCoordinates((double)20.0, (double)20.0), (Point)Point.fromCoordinates((double)30.0, (double)20.0), (Point)Point.fromCoordinates((double)20.0, (double)30.0), (Point[])new Point[0]))).isTrue();
    }

    @Test
    public void should_not_contain_exterior_shape() {
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Point.fromCoordinates((double)10.0, (double)10.0))).isFalse();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)LineString.fromPoints((Point)Point.fromCoordinates((double)10.0, (double)10.0), (Point)Point.fromCoordinates((double)20.0, (double)20.0), (Point[])new Point[0]))).isFalse();
        Assertions.assertThat((boolean)this.polygon.contains((Geometry)Polygon.fromPoints((Point)Point.fromCoordinates((double)0.0, (double)0.0), (Point)Point.fromCoordinates((double)0.0, (double)10.0), (Point)Point.fromCoordinates((double)10.0, (double)10.0), (Point[])new Point[0]))).isFalse();
    }

    @Test
    public void should_not_contain_shapes_in_interior_hole() {
        Polygon complex = Polygon.builder().addRing(Point.fromCoordinates((double)0.0, (double)0.0), Point.fromCoordinates((double)30.0, (double)0.0), Point.fromCoordinates((double)30.0, (double)30.0), new Point[]{Point.fromCoordinates((double)0.0, (double)30.0)}).addRing(Point.fromCoordinates((double)10.0, (double)10.0), Point.fromCoordinates((double)20.0, (double)10.0), Point.fromCoordinates((double)20.0, (double)20.0), new Point[]{Point.fromCoordinates((double)10.0, (double)20.0)}).build();
        Assertions.assertThat((boolean)complex.contains((Geometry)Point.fromCoordinates((double)15.0, (double)15.0))).isFalse();
    }

    @Test
    public void should_accept_empty_shape() throws Exception {
        Polygon polygon = Polygon.fromWellKnownText((String)"POLYGON EMPTY");
        Assertions.assertThat((List)polygon.getExteriorRing()).isEmpty();
        Assertions.assertThat((boolean)((DefaultPolygon)polygon).getOgcGeometry().isEmpty()).isTrue();
    }

    private void assertInvalidWkt(String s) {
        try {
            Polygon.fromWellKnownText((String)s);
            Fail.fail((String)"Should have thrown InvalidTypeException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

